﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/init.h>
#include <nn/os.h>

#include <upnp/upnp.h>
#include <upnp/upnptools.h>
#include <upnp/upnpdebug.h>
#include <upnp/nnlibupnp_VirtualDir.h>

#include <cstdio>
#include <cstdlib>

#include "UpnpDeviceGame.h"

namespace nns {
namespace libupnp {

class UpnpDeviceGameState : public UpnpDeviceGame
{
private:
    static const char*   WebFileNintendoGame;
    static const char*   WebFileNintendoGameControlScpd;
    static const char*   WebFileNintendoGamePresentationHtml;

    nn::os::MutexType   m_MutexLock;
    UpnpDevice_Handle   m_UpnpDeviceHandle;
    int                 m_UpnpAdvertisementExpireTime;
    char                m_Udn[256];
    char                m_ServiceId[256];
    char                m_EventUrl[256];
    char                m_ControlUrl[256];
    bool                m_IsUpnpRegistered;

    static int          UpnpCallbackEventHandler(Upnp_EventType eventType, void* pEvent, void* pCookie) NN_NOEXCEPT;
    int                 FindAndParseService(const char* pLocation) NN_NOEXCEPT;

    int                 CreateVirtualFiles(nn::libupnp::VirtualDir& virtualDir) NN_NOEXCEPT;
    int                 DeviceSubscriptionRequest(struct Upnp_Subscription_Request* pEvent) NN_NOEXCEPT;
    int                 DeviceGetVarRequest(struct Upnp_State_Var_Request* pEvent) NN_NOEXCEPT;
    int                 DeviceActionRequest(struct Upnp_Action_Request* pEvent) NN_NOEXCEPT;
    int                 NotifySubscribers() NN_NOEXCEPT;

public:
    UpnpDeviceGameState() NN_NOEXCEPT;
    ~UpnpDeviceGameState() NN_NOEXCEPT;

    int                 Start(nn::libupnp::VirtualDir& virtualDir) NN_NOEXCEPT;
    int                 Stop() NN_NOEXCEPT;
};

}}  // Namespace nns / libupnp
