﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ldn.h>

namespace nns { namespace ldn
{
    /**
     * @brief       アプリケーションのシーンです。
     */
    enum Scene
    {
        //! 終了シーンです。
        Scene_Exit = -1,

        //! 無効なシーンです。
        Scene_None,

        //! ローカル通信を実行するシーンです。
        Scene_Ldn
    };

    /**
     * @brief       アプリケーションの設定です。
     */
    struct Config
    {
        //! ユーザ名です。既定値は Anonymous です。
        char userName[nn::ldn::UserNameBytesMax + 1];

        //! ネットワークに接続できるノードの最大数です。既定値は nn::ldn::NodeCountMax です。
        int8_t nodeCountMax;

        //! 無線チャンネルです。既定値は nn::ldn::AutoChannel です。
        int16_t channel;

        //! ローカル通信バージョンです。既定値は 0 です。
        int16_t localCommunicationVersion;

        //! シーン識別子です。既定値は 0 です。
        uint16_t sceneId;

        //! ローカル通信識別子です。
        uint64_t localCommunicationId;

        //! ポート番号です。規定値は 12345 です。
        uint16_t port;

        //! パケットの送信レート (packets/second) です。規定値は 30 です。
        uint8_t packetRate;

        //! 通信の暗号化の有無です。既定値は false です。
        bool isEncrypted;
        NN_PADDING4;
    };

    /**
     * @brief       アプリケーションの状態です。
     */
    struct ApplicationStatus
    {
        //! 現在実行中のシーンです。
        int16_t scene;
        NN_PADDING6;

        //! アプリケーションを起動してからの経過フレーム数です。
        int64_t totalFrame;

        //! シーンを開始してからの経過フレーム数です。
        int64_t sceneFrame;

        //! アプリケーションの設定情報です。
        Config config;

        //! 現在実行中のシーン特有のデータです。
        const void* pSceneData;
    };

}} // namespace nns::ldn
