﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief Struct and API declaration for Hand Analysis Utility
*/

#pragma once

/**
* @brief Structure for hand analysis utility
*/
struct PolygonProperties
{
    float perimeter;   //!< perimeter of the polygon
    float signedArea;  //!< signed area of the polygon. If the polygon is direct, this area is positive. If the polygon is indirect, the area is negative. In case of a self-intersecting polygon, the area is the sum of the signed areas of the sub polygons that are formed by the intersection.
    nn::util::Float2 perimeterCentroid; //!<  centroid of the points on the perimeter of the polygon
    nn::util::Float2 areaCentroid;      //!< centroid of the points inside the polygon, weighted by 1 if they are surrounded by a direct perimeter, -1 if by an indirect perimeter.
};

// Compute polygon properties from polygon
void ComputePolygonProperties(
    PolygonProperties* pPolygonProperties,
    nn::util::Float2 const* pPolygonPoints,
    size_t polygonPointCount) NN_NOEXCEPT;


// Compute ExtractConvexHull from give points
void ExtractConvexHull(
    std::vector<size_t>& convexHullIndices,
    const std::vector<nn::util::Float2>& oneTurnSilhouette) NN_NOEXCEPT;

