﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/hid/hid_NpadJoy.h>

#include "HidNpadIntegrate_PluginManager.h"
#include "HidNpadIntegrate_SettingApi.h"
#include "HidNpadIntegrate_SettingApiPluginBase.h"

class SetNpadJoyAssignmentModeDualApiState : public SettingApiPluginBase
{
    NN_DISALLOW_COPY(SetNpadJoyAssignmentModeDualApiState);
    NN_DISALLOW_MOVE(SetNpadJoyAssignmentModeDualApiState);

public:
    SetNpadJoyAssignmentModeDualApiState() NN_NOEXCEPT {}

    ~SetNpadJoyAssignmentModeDualApiState() NN_NOEXCEPT NN_OVERRIDE {}

    void Initialize(int* pNextProcessor, int* pMenuSelection) NN_NOEXCEPT NN_OVERRIDE
    {
        SettingApiPluginBase::Initialize(pNextProcessor, pMenuSelection);
        m_NpadId = 0;

        m_pNpadIdType = new NpadIdType(&m_NpadId);
        MenuItem npadIdTypeMenuItem("  NpadID", m_pNpadIdType);
        m_ReadWriteMenu.push_back(npadIdTypeMenuItem);
    }

    void Finalize() NN_NOEXCEPT NN_OVERRIDE
    {
        delete m_pNpadIdType;
        SettingApiPluginBase::Finalize();
    }

    void Start() NN_NOEXCEPT NN_OVERRIDE
    {
        nn::hid::SetNpadJoyAssignmentModeDual(m_NpadId);
        m_ResultMsg = "Success";
    }

    void Explain(
        nn::gfx::util::DebugFontTextWriter* pTextWriter,
        const float OffsetX, const float OffsetY) NN_NOEXCEPT NN_OVERRIDE
    {
        pTextWriter->SetTextColor(Color::White);
        pTextWriter->SetScale(1.0f, 1.0f);

        pTextWriter->SetCursor(OffsetX, OffsetY);
        pTextWriter->
            Print("This function sets AssignmentMode of Joy-Con to \"Dual Mode\" with one");
        pTextWriter->SetCursor(OffsetX, OffsetY + 30);
        pTextWriter->
            Print("specified NpadID.");
        pTextWriter->SetCursor(OffsetX, OffsetY + 60);
        pTextWriter->
            Print("In condition of \"Dual Mode\", newly connected Joy-Con will assigned to form");
        pTextWriter->SetCursor(OffsetX, OffsetY + 90);
        pTextWriter->
            Print("pair.");
    }

    bool DrawAssignment(
        int index, nn::gfx::util::DebugFontTextWriter* pTextWriter,
        const float OffsetX, const float OffsetY) NN_NOEXCEPT NN_OVERRIDE
    {
        pTextWriter->SetCursor(OffsetX, OffsetY);
        pTextWriter->Print("AssignmentMode: %s",
            nn::hid::GetNpadJoyAssignment(NpadIds[index]) == nn::hid::NpadJoyAssignmentMode_Dual ?
            "Dual" : "Single");

        return true;
    }

private:
    nn::hid::NpadIdType m_NpadId;
    ReadWriteBase* m_pNpadIdType;
};

namespace {
SET_PLUGIN(SetNpadJoyAssignmentModeDualApiState, "SetNpadJoyAssignmentModeDual");
}
