﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "HidNpadIntegrate_Main.h"
#include "HidNpadIntegrate_PluginBase.h"

class ScenePluginBase : public PluginBase
{
    NN_DISALLOW_COPY(ScenePluginBase);
    NN_DISALLOW_MOVE(ScenePluginBase);

public:
    ScenePluginBase() NN_NOEXCEPT : m_IsRunning(false) {}

    virtual ~ScenePluginBase() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void InitializeScene(ApplicationHeap* pAppAllocator,
                                GraphicsSystem*  pGraphicsSystem) NN_NOEXCEPT = 0;

    virtual void FinalizeScene(ApplicationHeap* pAppAllocator) NN_NOEXCEPT = 0;

    virtual void RunScene(nn::gfx::util::DebugFontTextWriter& textWriter,
                                GraphicsSystem*  pGraphicsSystem) NN_NOEXCEPT = 0;

    virtual void StopScene() NN_NOEXCEPT = 0;

    virtual void RestartScene() NN_NOEXCEPT = 0;

    virtual void SwitchScene() NN_NOEXCEPT = 0;

    virtual void ToggleProcess(const nn::hid::NpadButtonSet& Buttons,
                                ApplicationHeap* pAppAllocator,
                                GraphicsSystem*  pGraphicsSystem) NN_NOEXCEPT = 0;

    bool IsRunning() NN_NOEXCEPT
    {
        return m_IsRunning;
    }

    void SetRunnableAlways(bool state) NN_NOEXCEPT
    {
        m_IsRunnableAlways = state;
    }

    bool IsRunnableAlways() NN_NOEXCEPT
    {
        return m_IsRunnableAlways;
    }

    void SetStatusName(const std::string name) NN_NOEXCEPT
    {
        m_StatusName = name;
    }

    const char* GetStatusName() const NN_NOEXCEPT
    {
        return m_StatusName.c_str();
    }

    const char* GetToggleOperation() const NN_NOEXCEPT
    {
        return m_ToggleOperation.c_str();
    }

protected:
    int m_SceneNum;
    bool m_IsRunning;
    bool m_IsRunnableAlways;
    std::string m_StatusName;
    std::string m_ToggleOperation;

};
