﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>
#include <string>
#include <vector>

#include <nn/hid.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_TimeSpan.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>
#include <nn/hid/hid_Npad.h>

#include <nns/gfx/gfx_GraphicsFramework.h>
#include <nns/gfx/gfx_PrimitiveRenderer.h>

#include "HidNpadIntegrate_ApplicationHeap.h"
#include "HidNpadIntegrate_Color.h"
#include "HidNpadIntegrate_FontSystem.h"
#include "HidNpadIntegrate_GraphicsSystem.h"
#include "HidNpadIntegrate_StylePluginBase.h"
#include "HidNpadIntegrate_WindowMessage.h"

extern const nn::hid::NpadIdType NpadIds[];
extern const int NpadIdCountMax;
extern const int FrameBufferWidth;
extern const int FrameBufferHeight;

void WriteCommonGuide(nn::gfx::util::DebugFontTextWriter* pTextWriter) NN_NOEXCEPT;
void DrawRect(nn::gfx::util::DebugFontTextWriter* pTextWriter,
    const float OffsetX, const float OffsetY,
    const int Width, const int Height) NN_NOEXCEPT;
NpadCommonState GetNpadButtonSet(const nn::hid::NpadIdType NpadId) NN_NOEXCEPT;
