﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

#include "HidNpadIntegrate_IrSensorModeState.h"

const int ImageTransferProcessorFormatMax = 3;

class ImageTransferModeState : public IrSensorModeState
{
    NN_DISALLOW_COPY(ImageTransferModeState);
    NN_DISALLOW_MOVE(ImageTransferModeState);

public:
    NN_STATIC_ASSERT(
        nn::irsensor::ImageTransferProcessorWorkBufferSize320x240 % nn::os::MemoryPageSize == 0
    );
    static const size_t WorkMemorySize =
        nn::irsensor::ImageTransferProcessorWorkBufferSize320x240 +
        nn::irsensor::ImageTransferProcessorImageSize320x240;
    static const size_t WorkMemoryAlignement = nn::os::MemoryPageSize;

public:
    ImageTransferModeState(IrSensorMode* pNextProcessor,
        int* pMenuSelection,
        nn::irsensor::IrCameraHandle irCameraHandle,
        void* pWorkMemory, GraphicsSystem* pGraphicsSystem) NN_NOEXCEPT;
    virtual ~ImageTransferModeState() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Start() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Render(nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
        nn::gfx::CommandBuffer* pCommandBuffer, int index) NN_NOEXCEPT NN_OVERRIDE;

private:
    void CopyImageBuffer(nn::gfx::CommandBuffer* pCommandBuffer) NN_NOEXCEPT;
    void RenderImageTransferProcessorState(
        nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
        nn::gfx::CommandBuffer* pCommandBuffer,
        const int ScreenIndex) NN_NOEXCEPT;

private:
    nn::irsensor::ImageTransferProcessorFormat m_Format;
    nn::irsensor::ImageTransferProcessorState m_ImageTransferProcessorState;
    nn::irsensor::ImageTransferProcessorConfig m_ImageTransferProcessorConfig;
    void* m_pImageTransferWorkBuffer;
    void* m_pImageCopyWorkBuffer;

    nn::gfx::Texture m_Texture[ImageTransferProcessorFormatMax];
    nn::gfx::TextureView m_TextureView[ImageTransferProcessorFormatMax];
    nn::gfx::DescriptorSlot m_TextureDescriptorSlot[ImageTransferProcessorFormatMax];
    nn::gfx::Sampler m_Sampler;
    nn::gfx::DescriptorSlot m_SamplerDescriptorSlot;
    nn::gfx::Buffer m_Buffer;
    int64_t m_PreviousSamplingNumber;

    GraphicsSystem* m_pGraphicsSystem;

    ReadWriteBase* m_pFormat;
};
