﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "HidNpadIntegrate_IrSensorModeState.h"

class HandAnalysisModeState : public IrSensorModeState
{
    NN_DISALLOW_COPY(HandAnalysisModeState);
    NN_DISALLOW_MOVE(HandAnalysisModeState);

public:
    static const size_t ImageSize =
        nn::irsensor::IrHandAnalysisImageWidth *
        nn::irsensor::IrHandAnalysisImageHeight * sizeof(uint16_t);

public:
    HandAnalysisModeState(IrSensorMode* pNextProcessor, int* pMenuSelection,
        nn::irsensor::IrCameraHandle irCameraHandle, GraphicsSystem* pGraphicsSystem
    ) NN_NOEXCEPT;
    virtual ~HandAnalysisModeState() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Start() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Render(nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
        nn::gfx::CommandBuffer* pCommandBuffer, int index) NN_NOEXCEPT NN_OVERRIDE;

private:
    void RenderImageState(nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer,
        nn::gfx::CommandBuffer* pCommandBuffer, const int ScreenIndex) NN_NOEXCEPT;

private:
    nn::irsensor::HandAnalysisConfig m_NextHandAnalysisConfig;
    nn::irsensor::HandAnalysisConfig m_CurrentHandAnalysisConfig;
    nn::irsensor::HandAnalysisSilhouetteState m_HandAnalysisSilhouetteState;
    nn::irsensor::HandAnalysisImageState m_HandAnalysisImageState;
    PolygonProperties m_PolygonProperties;

    GraphicsSystem* m_pGraphicsSystem;

    nn::gfx::Texture m_Texture;
    nn::gfx::TextureView m_TextureView;
    nn::gfx::DescriptorSlot m_TextureDescriptorSlot;
    nn::gfx::Sampler m_Sampler;
    nn::gfx::DescriptorSlot m_SamplerDescriptorSlot;
    nn::gfx::Buffer m_Buffer;

    ReadWriteBase* m_pHandAnalysisCurrentMode;
    ReadWriteBase* m_pShapeArea;
    ReadWriteBase* m_pFingerShape;
};
