﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <nn/os.h>
#include <nns/hid.h>
#include "./HidControllerSequence_GraphicsSystem.h"

class ThreadState
{
public:
    static const size_t             ThreadStackSize = 32 * 1024;
protected:
    bool                            m_IsExit;
    nn::os::ThreadFunction          m_ThreadFunction;
    nn::os::ThreadType              m_ThreadType;
    std::string                     m_ThreadName;
    char*                           m_pThreadStack;
public:
    ThreadState();
    ThreadState(const char* name, nn::os::ThreadFunction func);
    void SetName(const char* name);
    void  SetFunc(nn::os::ThreadFunction func);
    nn::Result Create(int priority);
    bool Destroy();
    bool Start();
    nn::os::ThreadType* GetThreadType();

    virtual void Initialize() {}
    virtual void Update() {}
    virtual void Draw() {}
    virtual void Finalize() {}

    bool IsExit() const { return m_IsExit; }
};

class ThreadManager
{
public:
    static nn::os::ThreadType*  pPrevThread;
    static nn::os::ThreadType*  pNextThread;
    enum ThreadList
    {
        ThreadList_SceneStart = 0,              //!< スタート画面
        ThreadList_SceneTitle = 1,              //!< タイトル画面
        ThreadList_SceneGame,                   //!< ゲーム画面
        ThreadList_Num                          //!< スレッドの数
    };
private:
    std::vector<ThreadState*>    m_StateList;
    nn::os::Mutex               m_Mutex;
public:
    ThreadManager();
    ~ThreadManager();
    size_t Add(ThreadState* state);
    bool GetThreadStateFromIndex(uint32_t index, ThreadState** outState);
    bool GetThreadState(const nn::os::ThreadType* inThread, ThreadState** outState);
    void CreateThread(int priority = 9);
    void DestroyThread();
    void SetEndThread(nn::os::ThreadType* stopThread);
    void SetNextThread(nn::os::ThreadType* nextThread);
};

extern ThreadManager g_ThreadManager;
