﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/init.h>
#include <nn/os.h>
#include <nn/g3d.h>
#include "g3ddemo_DemoUtility.h"
#include "g3ddemo_GfxUtility.h"

extern int SimpleMain();
extern int NnsG3dSimpleMain();
extern int OutlineMain();
extern int SkeletalAnimationMain();
extern int ShapeAnimationMain();
extern int EditMain();
extern int TownMain();
extern int ParallelMain();
extern int DemoLauncherMain(nn::g3d::demo::CmdMenu::Item* pItems);

#define DEFINE_MENU(title) { #title, std::strlen(#title), title##Main }

nn::g3d::demo::CmdMenu::Item g_MenuItems[] = {
    DEFINE_MENU(Simple),
    DEFINE_MENU(NnsG3dSimple),
    DEFINE_MENU(Edit),
    DEFINE_MENU(SkeletalAnimation),
    DEFINE_MENU(ShapeAnimation),
    DEFINE_MENU(Outline),
    DEFINE_MENU(Parallel),
    DEFINE_MENU(Town),
    { "Exit", std::strlen("Exit"), nullptr }
};

extern "C" void nnMain()
{
    nn::g3d::demo::Initialize();
    nn::g3d::demo::InitializeDemo();

    // ジョイコンを使用します
    nn::g3d::demo::GetPad().InitializeNpad();

    NN_LOG("[g3d demo launcher]\n");

    nn::g3d::demo::CmdMenu menu(g_MenuItems);

    // 引数から起動
    if (nn::os::GetHostArgc() > 1)
    {
        int idxDemo = atoi(nn::os::GetHostArgv()[1]);
        menu.Run(idxDemo);
    }
    else
    {
        // メニューから選択
        while (NN_STATIC_CONDITION(1))
        {
            int idxDemo = DemoLauncherMain(g_MenuItems);
            if (idxDemo == 0)
            {
                break;
            }

            menu.Run(idxDemo);
        }
    }

    nn::g3d::demo::FinalizeDemo();
    nn::g3d::demo::Finalize();

    return;
}
