﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include "g3ddemo_ViewerUtility.h"

namespace g3ddemo = nn::g3d::demo;
namespace nn { namespace g3d { namespace demo { namespace skeletalanim {

// モデルとスロット数を変更した場合 MenuItem の項目も変更する
enum Model
{
    Model_Pierrot,
    Model_Robot,
    ModelCount
};

enum AnimIndex
{
    AnimIndex_0,
    AnimIndex_1,
    AnimIndexCount
};

struct AnimationPreset
{
    const char* name[AnimIndexCount];
    float weight[AnimIndexCount];
};
const int g_AnimationPresetCount = 9;
const AnimationPreset g_AnimationPresetList[g_AnimationPresetCount] =
{
    { { "Pierrot_Backflip", "None" },               { 1.f, 0.f } },
    { { "Pierrot_JumpTurn", "None" },               { 1.f, 0.f } },
    { { "Pierrot_PPK", "None" },                    { 1.f, 0.f } },
    { { "Pierrot_Run", "None" },                    { 1.f, 0.f } },
    { { "Pierrot_Walk", "None" },                   { 1.f, 0.f } },
    { { "Pierrot_JumpTurn", "Pierrot_Walk" },       { 0.6f, 0.4f } },
    { { "Pierrot_PPK", "Pierrot_Walk" },            { 0.6f, 0.4f } },
    { { "Pierrot_Run", "Pierrot_Walk_LookAround" }, { 0.5f, 0.5f } },
    { { "None", "None" },                           { 0.f, 0.f } },
};

// メニュー操作
enum MenuResult
{
    MenuResult_None,
    MenuResult_ChangeSelectedAnim,
    MenuResult_ChangeAnimStep,
};

void InitializeMenu(nn::gfx::Device* pDevice) NN_NOEXCEPT;
void FinalizeMenu(nn::gfx::Device* pDevice) NN_NOEXCEPT;

MenuResult CalculateMenu(const g3ddemo::Pad &pad) NN_NOEXCEPT;
void DrawMenu(nn::gfx::CommandBuffer* pCommandBuffer) NN_NOEXCEPT;

const AnimationPreset *GetSelectedAnimationPreset() NN_NOEXCEPT;
bool IsRetargetingEnabled() NN_NOEXCEPT;
bool IsViewSkeletonEnabled() NN_NOEXCEPT;
float GetAnimStep() NN_NOEXCEPT;

// デバッグ描画
void DrawSkeleton(nn::gfx::CommandBuffer* pCommandBuffer, nn::g3d::SkeletonObj* pSkeletonObj) NN_NOEXCEPT;

}}}} // namespace nn::g3d::demo::skeletalanim
