﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nns/hid.h>
#include <nn/vi.h>
#include <nn/nn_BitTypes.h>
#if !defined(NN_BUILD_TARGET_PLATFORM_OS_WIN)
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>
#endif
//------------------------------------------------------------------------------
//  パッドユーティリティ
//------------------------------------------------------------------------------
enum
{
    BUTTON_LEFT = 0x00000001,
    BUTTON_RIGHT = 0x00000002,
    BUTTON_DOWN = 0x00000004,
    BUTTON_UP = 0x00000008,
    BUTTON_A = 0x00000100,
    BUTTON_B = 0x00000200,
    BUTTON_X = 0x00000400,
    BUTTON_Y = 0x00000800,
};

void InitializePadUtility(nn::vi::Layer* pLayer);
void FinalizePadUtility();
void ResetPad();
void ReadPad();
bool IsPadHold(nn::Bit32 mask);
bool IsPadTriggered(nn::Bit32 mask);
bool IsPadReleased(nn::Bit32 mask);
