﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/font.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>

#include "FontCommon.h"

//------------------------------------------------------------------------------
//
// スケーラブルフォント関連処理です。
//
//------------------------------------------------------------------------------

// 初期化
void InitializeScalableFont();

// 解放
void FinalizeScalableFont();

// フォントの設定
void SetScalableFont(nn::font::WideTextWriter* pTextWriter);

// バッファ生成
void PrintScalableFont(nn::font::WideTextWriter* pTextWriter);

// フォントリストの優先順位の変更
void ChangeFontOrder();
