﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/ovln/ovln_CommonTypes.h>
#include <nn/ovln/ovln_FormatForOverlay.h>
#include <nn/nn_Log.h>
#include <nn/nn_Abort.h>
#include <cstring>

void DispatchAudioMessage(const nn::ovln::Message& message) NN_NOEXCEPT
{
    switch (message.tag)
    {
        case nn::ovln::format::AudioVolumeChangedDataTag:
        {
            nn::ovln::format::AudioVolumeChangedData data;
            if (message.dataSize == sizeof(data))
            {
                std::memcpy(&data, &message.data, sizeof(data));
                const auto& reason = data.reason;
                NN_LOG("[DispatchAudioMessage] audio volume changed message:\n");
                NN_LOG("    volume: %d\n", data.volume);
                NN_LOG("    mute: %s\n", data.mute ? "true" : "false");

                const char* audioOutputTargetName;

                switch (data.audioOutputTarget)
                {
                case nn::ovln::format::AudioOutputTarget_HeadphoneMicJack:
                    {
                        audioOutputTargetName = "HeadponeMicJack";
                    }
                    break;
                case nn::ovln::format::AudioOutputTarget_Speaker:
                    {
                        audioOutputTargetName = "Speaker";
                    }
                    break;
                case nn::ovln::format::AudioOutputTarget_Hdmi:
                    {
                        audioOutputTargetName = "Hdmi";
                    }
                    break;
                case nn::ovln::format::AudioOutputTarget_UsbOutputDevice:
                    {
                        audioOutputTargetName = "UsbOutputDevice";
                    }
                    break;
                default: NN_UNEXPECTED_DEFAULT;
                }

                NN_LOG("    target: %s\n", audioOutputTargetName);
                NN_LOG("    upButtonPressed: %s\n", reason.Test<nn::ovln::format::AudioVolumeChangeReasonFlag::upButtonPressed>() ? "true" : "false");
                NN_LOG("    downButtonPressed: %s\n", reason.Test<nn::ovln::format::AudioVolumeChangeReasonFlag::downButtonPressed>() ? "true" : "false");
                NN_LOG("    upAndDownButtonPressed: %s\n", reason.Test<nn::ovln::format::AudioVolumeChangeReasonFlag::upAndDownButtonPressed>() ? "true" : "false");
                NN_LOG("    headphoneMicJackPlugged: %s\n", reason.Test<nn::ovln::format::AudioVolumeChangeReasonFlag::headphoneMicJackPlugged>() ? "true" : "false");
                NN_LOG("    headphoneMicJackUnplugged: %s\n", reason.Test<nn::ovln::format::AudioVolumeChangeReasonFlag::headphoneMicJackUnplugged>() ? "true" : "false");
                NN_LOG("    usbOutputDeviceConnected: %s\n", reason.Test<nn::ovln::format::AudioVolumeChangeReasonFlag::usbOutputDeviceConnected>() ? "true" : "false");
                NN_LOG("    usbOutputDeviceDisconnected: %s\n", reason.Test<nn::ovln::format::AudioVolumeChangeReasonFlag::usbOutputDeviceDisconnected>() ? "true" : "false");
            }
            else
            {
                NN_LOG("[DispatchAudioMessage] invalid message: tag = %u\n", message.tag);
            }
            return;
        }
        case nn::ovln::format::AudioHeadphoneVolumeWarningDataTag:
        {
            NN_LOG("[DispatchAudioMessage] audio headphone volume warning message:\n");
            return;
        }
        default:
        {
            NN_LOG("[DispatchAudioMessage] unknown message: tag = %u\n", message.tag);
            return;
        }
    }
}

