﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/vi.h>

#include <nn/gfx/util/gfx_DebugFontTextWriter.h>
#include <nn/os/os_Event.h>
#include <nn/os/os_MutexTypes.h>
#include <nn/time/time_Api.h>
#include <nn/time/time_TimeZoneApi.h>
#include <nn/time/time_StandardUserSystemClock.h>

#include <nns/gfx/gfx_PrimitiveRenderer.h>
#include <nns/gfx/gfx_PrimitiveRendererMeterDrawer.h>
#include <nns/gfx/gfx_PrimitiveRendererMeshRes.h>

#include "Demo1Plugin.h"
#include "Demo1GraphicsSystem.h"
#include "Demo1SaveDataAccessor.h"

namespace {
const float NormalFontScaleX = 0.8f;  // 通常文字のスケールX
const float NormalFontScaleY = 0.8f;  // 通常文字のスケールY
const float NormalFontHeight = 20.0f; // 通常文字の高さ
}

class ScenePluginBase : public PluginBase
{
    NN_DISALLOW_COPY(ScenePluginBase);
    NN_DISALLOW_MOVE(ScenePluginBase);
public:
    ScenePluginBase() NN_NOEXCEPT {}

    virtual ~ScenePluginBase() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Start() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void End() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Procedure() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Wait() NN_NOEXCEPT {}

    virtual void WriteCommonGuide(
        nn::gfx::util::DebugFontTextWriter* pTextWriter,
        const char* pName
    ) const NN_NOEXCEPT;

    virtual void SetGraphicSystem(GraphicsSystem * pGraphicsSystem) NN_NOEXCEPT
    {
        m_pGraphicsSystem = pGraphicsSystem;
    }

    virtual void SetSaveDataAccessor(SaveDataAccessor* pSaveDataAccessor) NN_NOEXCEPT
    {
        m_pSaveDataAccessor = pSaveDataAccessor;
    }

    virtual void SetActive(bool isActive) NN_NOEXCEPT
    {
        NN_UNUSED(isActive);
    }

    virtual void Draw() NN_NOEXCEPT {}

    bool IsDraw() NN_NOEXCEPT
    {
        return ((m_Property & PluginProperty_Drawable) == PluginProperty_Drawable);
    }

protected:
    nns::gfx::PrimitiveRenderer::Renderer& GetPrimitiveRenderer() const NN_NOEXCEPT;
    nn::gfx::CommandBuffer& GetCommandBuffer() const NN_NOEXCEPT;
    nn::gfx::util::DebugFontTextWriter& GetDebugFont() const NN_NOEXCEPT;

    void DrawLoadMeter() const NN_NOEXCEPT;

protected:
    // GraphicsSystemのポインタ
    GraphicsSystem* m_pGraphicsSystem;

    // SaveDataAccessorのポインタ
    SaveDataAccessor* m_pSaveDataAccessor;
};
