﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <sstream>

#include <nn/nn_Common.h>

enum PluginProperty
{
    PluginProperty_None         = 0x0,
    PluginProperty_Drawable     = (0x1 << 1),
};

class PluginBase
{
    NN_DISALLOW_COPY(PluginBase);
    NN_DISALLOW_MOVE(PluginBase);
public:
    PluginBase() NN_NOEXCEPT
    {
        m_Property = 0;
    }

    virtual ~PluginBase() NN_NOEXCEPT  {}

    virtual void Initialize() NN_NOEXCEPT {}

    virtual void Finalize() NN_NOEXCEPT {}

    virtual void Start() NN_NOEXCEPT {}

    virtual void End() NN_NOEXCEPT {}

    virtual void Procedure() NN_NOEXCEPT {}

    void SetName(const std::string name) NN_NOEXCEPT
    {
        m_Name = name;
    }

    std::string GetName() const NN_NOEXCEPT
    {
        return m_Name;
    }

    void SetProperty(PluginProperty property) NN_NOEXCEPT
    {
        m_Property = property;
    }

protected:
    std::string m_Name;
    nn::Bit32 m_Property;
};
