﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>

#include "Mp4BoxHeaderReader.h"

Mp4BoxHeaderReader::Mp4BoxHeaderReader(const void* buffer, size_t size)
    : m_Type()
    , m_Size(0)
{
    NN_ASSERT(size >= 8);
    auto pSize = reinterpret_cast<const uint8_t*>(buffer);
    for (auto i = 0; i < 4; ++i)
    {
        m_Size = (m_Size << 8) | pSize[i];
    }
    auto pType = reinterpret_cast<const char*>(buffer) + 4;
    for (auto i = 0; i < 4; ++i)
    {
        m_Type += pType[i];
    }
}

const std::string& Mp4BoxHeaderReader::GetType() const
{
    return m_Type;
}

size_t Mp4BoxHeaderReader::GetSize() const
{
    return m_Size;
}

bool Mp4BoxHeaderReader::HasChild() const
{
    return m_Type == "moov"
        || m_Type == "trak"
        || m_Type == "edts"
        || m_Type == "mdia"
        || m_Type == "minf"
        || m_Type == "dtbl"
        || m_Type == "stbl"
        || m_Type == "mvex"
        || m_Type == "moof"
        || m_Type == "traf"
        || m_Type == "mfra"
        || m_Type == "skip"
        || m_Type == "cprt"
        || m_Type == "meta"
        || m_Type == "dinf"
        || m_Type == "ipro"
        || m_Type == "sinf";
}
