﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "bluetooth_Client.h"
#include <cstdlib>

class myBtClient : public bluetoothClient
{
};


static myBtClient client;

//-----------------------------------------------------------------------------
extern "C" void nnMain()
{
    NN_LOG("NBM_CLIENT NOW RUNNING \n");
    for (int shutdown_loops=1; shutdown_loops <= 4; shutdown_loops++)
    {
        NN_LOG("- Starting up: %d\n", shutdown_loops);
        client.startBluetooth();

        for (int restart_loops=1; restart_loops <= 4; restart_loops++)
        {
            NN_LOG(" - Discovery for 15 seconds\n");
            nn::bluetooth::StartDiscovery();
            nn::os::SleepThread(nn::TimeSpan::FromSeconds(15));

            NN_LOG("- Restarting: %d\n\n", restart_loops);
            client.restartBluetooth();
        }

        NN_LOG("- Shutting down: %d\n", shutdown_loops);
        client.finishBluetooth();
    }
}



