﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "bluetooth_Client.h"
#include <cstdlib>

class myBtClient : public bluetoothClient
{
    public:

    int  goalTsi = 10;
    int  controllerCount = 0;
    bool disconnect = true;


    private:

    void EventFromConnectionStateCallback(const nn::bluetooth::InfoFromConnectionStateCallback* pInfo)
    {
        bluetoothClient::EventFromConnectionStateCallback(pInfo);

        if(pInfo->state==nn::bluetooth::BTHH_CONN_STATE_CONNECTED)
        {
            nn::bluetooth::ExtSetTsi(&pInfo->bluetoothAddress, goalTsi);

            controllerCount++;
            NN_LOG("Controller count %d\n", controllerCount);

            if(controllerCount == 8)
            {
                disconnect = true;
            }
        }
        if(pInfo->state==nn::bluetooth::BTHH_CONN_STATE_DISCONNECTED)
        {
            controllerCount--;
            NN_LOG("Controller count %d\n", controllerCount);
        }
    }
};


static myBtClient client;


//-----------------------------------------------------------------------------
extern "C" void nnMain()
{
    NN_LOG("myBtClient NOW RUNNING \n");

    int loopTimeMs=0;

    int iteration = 0;

    if (client.startBluetooth() < 0)
    {
        NN_LOG("Couldn't start bluetooth!\n");
        exit(-1);
    }

    NN_LOG("\n-----------------------------------------------------------------------\n");
    NN_LOG("Connect 8 controllers to begin disconnect test\n");

    while (1)
    {
        if (client.controllerCount == 8 && client.disconnect == true)
        {
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(1000));
            NN_LOG("\n-----------------------------------------------------------------------\n");
            NN_LOG("Disconnect iteration %d\n", iteration);

            nn::bluetooth::CancelDiscovery();
            for(int i = 0; i < 8; i++)
            {
                nn::bluetooth::HidDisconnect(&client.controllerInfo[i].bdAddr);
            }

            client.disconnect = false;
            iteration++;
        }

        if (client.controllerCount < 8 && client.disconnect == false)
        {
            for(int j = 0; j < 8; j++)
            {
                if(client.controllerInfo[j].connectState != nn::bluetooth::BTHH_CONN_STATE_CONNECTED)
                {
                    NN_LOG("Wake Controller %s\n", client.toHexString(client.controllerInfo[j].bdAddr));
                    nn::bluetooth::HidWakeController(&client.controllerInfo[j].bdAddr);
                    if(client.controllerCount > 6)
                    {
                        // Wait longer for the last two to help chance of a successful connection
                        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(8000));
                    }
                    else
                    {
                        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(3000));
                    }
                }
            }
        }

        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(100));
        loopTimeMs += 100;
    }

    NN_LOG("  [Exiting...]\n");
    client.finishBluetooth();
} // NOLINT(impl/function_size)



