﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bluetooth.h>

const nn::bluetooth::GattAttributeUuid GENERIC_ACCESS_SERVICE_UUID =
{
    .length = nn::bluetooth::GattAttributeUuidLength_16,
    .uu.uuid16 = 0x1800
};

const nn::bluetooth::GattAttributeUuid GENERIC_ATTRIBUTE_SERVICE_UUID =
{
    .length = nn::bluetooth::GattAttributeUuidLength_16,
    .uu.uuid16 = 0x1801
};

const nn::bluetooth::GattAttributeUuid MY_SERVICE_UUID_0 =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x00, 0x00, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x00 }
};

const nn::bluetooth::GattAttributeUuid MY_SERVICE_UUID_1 =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x10, 0x10, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x10 }
};

const nn::bluetooth::GattAttributeUuid MY_SERVICE_UUID_2 =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }
};

const nn::bluetooth::GattAttributeUuid g_UuidDatabase[] =
{
    // GENERIC_ACCESS_SERVICE_UUID,
    // GENERIC_ATTRIBUTE_SERVICE_UUID,
    MY_SERVICE_UUID_0,
    MY_SERVICE_UUID_1,
    MY_SERVICE_UUID_2,
};

const nn::bluetooth::GattAttributeUuid ADV_SERVICE_UUID =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF, 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99 }
};
