﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{BcatPractical.h,PageSampleBcatPractical}
 *
 * @brief
 *  データ配信のサンプルプログラム
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/bcat.h>
#include <nns/console/console_SimpleConsole.h>

/*!
    @brief      サンプルプログラムクラスです。
*/
class SampleProgram : public nns::console::SimpleConsole
{
public:
    /*!
        @brief      コンストラクタです。
    */
    SampleProgram() NN_NOEXCEPT;

    /*!
        @brief      サンプルプログラムの実行を開始します。

        @param[in]  stack       スレッドスタック。
        @param[in]  stackSize   スレッドスタックサイズ。

        @pre
            - stack != nullptr
            - stackSize > 0
    */
    void Start(void* stack, size_t stackSize) NN_NOEXCEPT;

private:
    //
    enum SceneId
    {
        SceneId_Top    = 0,
        SceneId_Access = 1,
        SceneId_Sync   = 2
    };

private:
    //
    SceneId m_SceneId;
    //
    nn::bcat::DeliveryCacheProgress m_Progress;
    bool m_IsRunning;
    //
    nn::os::ThreadType m_Thread;

private:
    //
    void SetNextSceneId(SceneId sceneId) NN_NOEXCEPT;
    //
    void SceneTop() NN_NOEXCEPT;
    void SceneAccess() NN_NOEXCEPT;
    void SceneSync() NN_NOEXCEPT;
    //
    bool Connect() NN_NOEXCEPT;
    bool WaitForDone() NN_NOEXCEPT;
    //
    void Log(const char* format, ...) NN_NOEXCEPT;

private:
    //
    static void Main(void* param) NN_NOEXCEPT;
};
