﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/atk/atk_WavOutRecorder.h>
#include <nn/atk/fnd/io/atkfnd_FileStreamImpl.h>

class SoundRecorder
{
public:
    SoundRecorder() NN_NOEXCEPT;
    ~SoundRecorder() NN_NOEXCEPT;

    void Initialize(void* recordingBuffer, size_t recordingBufferSize, void* pThreadStack, size_t threadStackSize) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    size_t GetRequiredMemorySize() NN_NOEXCEPT;

    void StartRecording(uint32_t frames = 0) NN_NOEXCEPT;
    void StopRecording() NN_NOEXCEPT;

    bool IsRecording() const NN_NOEXCEPT
    {
        return m_IsRecording;
    }

    void SetOutputFileName( const char* pOutputFileName ) NN_NOEXCEPT
    {
        if ( m_IsRecording == false )
        {
            m_pOutputFileName = pOutputFileName;
        }
    }

    const char* GetOutputFileName() const NN_NOEXCEPT
    {
        return m_pOutputFileName;
    }

private:
    static const int FileIoBufferAlignment  = 64;

    bool m_IsInitialized;
    bool m_IsRecording;

    const char* m_pOutputFileName;

    nn::atk::WavOutRecorder m_Recorder;
    nn::atk::detail::fnd::FileStreamImpl m_RecordingFileStream;
};

class SoundRecorderUtil
{
public:
    static void MountContentsDirectory( const char* pMountName ) NN_NOEXCEPT;
    static void UnmountContentsDirectory( const char* pMountName ) NN_NOEXCEPT;
};
