﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../AtkSandboxCommon.h"
#include "ICheckModule.h"

class SoundActorCheckModule : public ICheckModule
{
private:
    class CommonObjectForSoundActor : public CommonObject
    {
    public:
        CommonObjectForSoundActor()
        : m_pSoundActor(nullptr) {}

        virtual void PlayWithStartSound(nn::atk::SoundArchive::ItemId soundId, const char* debugLabelName) NN_NOEXCEPT NN_OVERRIDE;

        void SetSoundActorPointer(nn::atk::SoundActor* pSoundActor)
        {
            m_pSoundActor = pSoundActor;
        }

    private:
        nn::atk::SoundActor* m_pSoundActor;
    };

public:
    virtual void OnInitializeAtk() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnFinalizeAtk() NN_NOEXCEPT NN_OVERRIDE;

    virtual void OnLoadData() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnPrintUsage() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnUpdateInput() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnUpdateAtk() NN_NOEXCEPT NN_OVERRIDE;
#if defined( NN_ATK_ENABLE_GFX_VIEWING )
    virtual void OnUpdateDraw() NN_NOEXCEPT NN_OVERRIDE;
#endif

    virtual const char* GetModuleName() const NN_NOEXCEPT NN_OVERRIDE
    {
        return "SoundActor";
    }

    virtual FlagList& GetLocalFlagList() NN_NOEXCEPT NN_OVERRIDE;

private:
    nn::atk::SoundActor m_SoundActor;
    nn::atk::SoundActor m_SharePlayerSoundActor;
    nn::atk::SoundActor::ActorPlayer m_ActorPlayer;
    float m_SoundActorPitch;
    float m_SoundActorVolume;
    int m_SoundActorBiquadFilterType;
    float m_SoundActorBiquadFilterValue;

    CommonObjectForSoundActor m_CommonObject;
};
