﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../AtkSandboxCommon.h"
#include "ICheckModule.h"

class EffectCheckModule : public ICheckModule
{
private:
    class CommonObjectForEffect : public CommonObject
    {
    public:
        virtual void OnPostStartSound() NN_NOEXCEPT NN_OVERRIDE;
    };

    enum EffectType
    {
        EffectType_Reverb,
        EffectType_Delay,
        EffectType_Aux,
        EffectType_Max = EffectType_Aux
    };

    enum SampleRate
    {
        SampleRate_32000,
        SampleRate_48000,
        SampleRate_Max = SampleRate_48000
    };

    enum EffectState
    {
        EffectState_Disable,
        EffectState_Enable,
        EffectState_Removing
    };

public:
    virtual void OnInitializeAtk() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnFinalizeAtk() NN_NOEXCEPT NN_OVERRIDE;

    virtual void OnLoadData() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnPrintUsage() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnUpdateInput() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnUpdateAtk() NN_NOEXCEPT NN_OVERRIDE;
#if defined( NN_ATK_ENABLE_GFX_VIEWING )
    virtual void OnUpdateDraw() NN_NOEXCEPT NN_OVERRIDE;
#endif

    virtual const char* GetModuleName() const NN_NOEXCEPT NN_OVERRIDE
    {
        return "Effect";
    }

    virtual FlagList& GetLocalFlagList() NN_NOEXCEPT NN_OVERRIDE;

private:
    void ShowStatus() NN_NOEXCEPT;
    void ClearEffect() NN_NOEXCEPT;

    void AppendEffect( int effectType ) NN_NOEXCEPT;
    void RemoveEffect( int effectType ) NN_NOEXCEPT;
    bool PrepareRemoveEffect( int effectType ) NN_NOEXCEPT;
    bool CheckEffectRemovable( int effectType ) NN_NOEXCEPT;
    void FadeAuxBusVolume() NN_NOEXCEPT;
    int ConvertSampleRateToInt(SampleRate sampleRate) NN_NOEXCEPT;
    nn::atk::EffectBase::SampleRate ConvertSampleRateToEffectSampleRate(SampleRate sampleRate) NN_NOEXCEPT;
    void SetAllBusChannelVolumeForAdditionalEffect() const NN_NOEXCEPT;

private:
    CommonObjectForEffect m_CommonObject;

    nn::atk::EffectDelay m_Delay;
    nn::atk::EffectReverb m_Reverb;

    void* m_DelayBuffer;
    void* m_ReverbBuffer;
    void* m_AuxBuffer;

    int m_SelectEffectType;
    EffectState m_EffectState[EffectType_Max + 1];
    size_t m_AuxEffectBufferSize;

    bool m_IsAuxBusFadedOut;

    void* m_AuxBufferForFinalMix;
    size_t m_AuxEffectBufferSizeForFinalMix;

    nn::atk::EffectReverb m_ReverbForAdditionalEffect;
    void* m_ReverbBufferForAdditionalEffect;
    int m_SubMixIndexForAdditionalEffect;

    void* m_AuxBufferForAdditionalSubMix;
    size_t m_AuxEffectBufferSizeForAdditionalSubMix;

    SampleRate m_SampleRate;

    float m_AuxBusChannelVolumeForAdditionalEffect;
};
