﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../AtkSandboxCommon.h"
#include "ICheckModule.h"

class CustomSubMixCheckModule : public ICheckModule
{
private:
    class CommonObjectForCustomSubMix : public CommonObject
    {
    public:
        static const int SubMixCount = 3;

        virtual void Initialize(const InitializeParam& param) NN_NOEXCEPT NN_OVERRIDE;

        virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;

        virtual void OnPreFinalizeSoundSystem() NN_NOEXCEPT NN_OVERRIDE;

        virtual void PlayWithStartSound(nn::atk::SoundArchive::ItemId soundId, const char* debugLabelName) NN_NOEXCEPT NN_OVERRIDE;

        //  出力先を index 番目の SubMix に設定します
        //  この関数は SetTargetToFinalMix の設定を上書きします
        void SetTargetToSubMix(int index) NN_NOEXCEPT;

        //  出力先を FinalMix に設定します
        //  この関数は SetTargetToSubMix の設定を上書きします
        void SetTargetToFinalMix() NN_NOEXCEPT;

        void PrintState(int cursorPosition) const NN_NOEXCEPT;

        int GetParameterCount() const NN_NOEXCEPT;

        void ChangeParameter(int cursorPosition, int difference) NN_NOEXCEPT;

    private:
        nn::atk::SubMix m_SubMix[SubMixCount];
        nn::atk::FinalMix* m_pFinalMix;
        void* m_SubMixBuffer[SubMixCount];

        int m_SubMixDestinationSubMixIndex; //  m_SubMix[0] の接続先 SubMix
        int m_SubMixDestinationBusIndex;    //  m_SubMix[0] の接続先バス番号

        bool m_IsNoSubMix;
        bool m_IsUseDefaultOutputReceiver;
        bool m_IsTargetToFinalMix;
        int m_TargetSubMixIndex;

        nn::atk::EffectReverb m_Reverb;
        void* m_ReverbBuffer;
    };

public:
    virtual void OnInitializeAtk() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnFinalizeAtk() NN_NOEXCEPT NN_OVERRIDE;

    virtual void OnLoadData() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnPrintUsage() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnUpdateInput() NN_NOEXCEPT NN_OVERRIDE;
    virtual void OnUpdateAtk() NN_NOEXCEPT NN_OVERRIDE;
#if defined( NN_ATK_ENABLE_GFX_VIEWING )
    virtual void OnUpdateDraw() NN_NOEXCEPT NN_OVERRIDE;
#endif

    virtual const char* GetModuleName() const NN_NOEXCEPT NN_OVERRIDE
    {
        return "CustomSubMix";
    }

    virtual FlagList& GetLocalFlagList() NN_NOEXCEPT NN_OVERRIDE;

private:
    CommonObjectForCustomSubMix m_CommonObject;
    int m_CursorPosition;
    int m_TargetIndex;
};
