﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Assert.h>
#include <nn/util/util_Arithmetic.h>

#include <nn/atk2.h>

#include "nns/atk/atk_SampleCommon.h"

#include "FlagList.h"

class CommonObject
{
public:
    class InitArg
    {
    public:
        InitArg() NN_NOEXCEPT;

        nn::atk2::AudioEngine::InitArg& GetAudioEngineInitArg() NN_NOEXCEPT;
        const nn::atk2::AudioEngine::InitArg& GetAudioEngineInitArg() const NN_NOEXCEPT;
        nn::atk2::AudioEngine::PlatformInitArg& GetAudioEnginePlatformInitArg() NN_NOEXCEPT;
        const nn::atk2::AudioEngine::PlatformInitArg& GetAudioEnginePlatformInitArg() const NN_NOEXCEPT;

    private:
        nn::atk2::AudioEngine::InitArg m_AudioEngineInitArg;
        nn::atk2::AudioEngine::PlatformInitArg m_AudioEnginePlatformInitArg;
    };

    CommonObject() NN_NOEXCEPT;
    virtual ~CommonObject() NN_NOEXCEPT;

    virtual void Initialize() NN_NOEXCEPT;
    virtual void Initialize(const CommonObject::InitArg& arg) NN_NOEXCEPT;
    virtual void Finalize() NN_NOEXCEPT;
    virtual void LoadData() NN_NOEXCEPT;
    virtual void Update() NN_NOEXCEPT;
    virtual void UpdateDraw(const char* moduleName) NN_NOEXCEPT;
    virtual void PrintUsage() NN_NOEXCEPT;
    virtual int UpdateInput() NN_NOEXCEPT;

    nn::atk2::AudioEngine& GetAudioEngine() NN_NOEXCEPT;

private:
    nn::atk2::AudioEngine m_AudioEngine;
    void* m_BufferForAudioEngine;
    void* m_PlatformBufferForAudioEngine;
    void* m_BufferMemoryPoolForAudioEngine;
};
