﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/demo/pad/win/demo_MouseWin.h>
#define WIN32_LEAN_AND_MEAN
#define NOMINMAX
#include <windows.h>

namespace nw
{
namespace demo
{

//------------------------------------------------------------------------------
MouseWin::MouseWin()
 : Mouse(),
   m_PointerOffThreshold( 1.f ),
   m_KeyboardMouseDevice( NULL )
{
}

//------------------------------------------------------------------------------
void
MouseWin::UpdateImpl()
{
    if ( m_MouseStatus == NULL && m_KeyboardMouseDevice == NULL )
    {
        return;
    }

    bool isActive = false;

    m_PadHold.SetAllZero();

    m_LeftStick = nw::math::VEC2::Zero();
    m_RightStick = nw::math::VEC2::Zero();

    m_LeftAnalogTrigger = 0.f;
    m_RightAnalogTrigger = 0.f;

    m_WheelDelta = 0;
    m_IsDoubleClick = false;

    if ( m_MouseStatus )
    {
        isActive = m_MouseStatus->isEnable;

        if ( isActive )
        {
            m_PadHold.SetDirect( m_MouseStatus->button );

            m_PointerPrev = m_Pointer;
            m_Pointer.Set( m_MouseStatus->posX, m_MouseStatus->posY );
            m_WheelDelta = m_MouseStatus->wheel;
            m_IsDoubleClick = m_MouseStatus->isDoubleClick;
        }
    }
    else if ( m_KeyboardMouseDevice )
    {
        // メインウインドウがアクティブな場合に、入力を受け付けます。
        isActive = ( m_KeyboardMouseDevice->GetActiveWindow() == KeyboardMouseDeviceWin::ACTIVE_WINDOW_MAIN ? true : false );

        if ( isActive )
        {
            if ( m_KeyboardMouseDevice->IsKeyEnable() )
            {
                if ( m_KeyboardMouseDevice->IsVkeyHold( VK_LBUTTON ) )
                {
                    m_PadHold.SetBitOn( IDX_LBUTTON );
                }

                if ( m_KeyboardMouseDevice->IsVkeyHold( VK_RBUTTON ) )
                {
                    m_PadHold.SetBitOn( IDX_RBUTTON );
                }

                if ( m_KeyboardMouseDevice->IsVkeyHold( VK_MBUTTON ) )
                {
                    m_PadHold.SetBitOn( IDX_MBUTTON );
                }
            }

            m_PointerPrev = m_Pointer;

            if ( IsPointerCenterOrigin() )
            {
                // 中央原点のとき
                const nw::math::VEC2& pos = m_KeyboardMouseDevice->GetCursorClientAreaPosCenterOrigin();
                SetPointerWithBound(
                    - m_PointerOffThreshold <= pos.x && pos.x <= m_PointerOffThreshold &&
                    - m_PointerOffThreshold <= pos.y && pos.y <= m_PointerOffThreshold,
                    false,
                    pos
                );
            }
            else
            {
                SetPointerWithBound(
                    m_KeyboardMouseDevice->IsCursorOnClientArea(),
                    false,
                    m_KeyboardMouseDevice->GetCursorClientAreaPos()
                );
            }

            // ホイール回転差分の設定
            // （ mcs の InputDevice で取得できる回転差分に大きさを合わせます。 ）
            m_WheelDelta = m_KeyboardMouseDevice->GetWheel() / 40;

            m_IsDoubleClick = m_KeyboardMouseDevice->IsDoubleClick();
        }
    }

    if ( ! isActive )
    {
        // ウィンドウがアクティブでないときは値をクリア
        m_PointerFlag.SetAllZero();
    }
}

} // namespace demo
} // namespace nw

