﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/demo/pad/cafe/demo_VPadCafe.h>

namespace nw
{
namespace demo
{

//------------------------------------------------------------------------------
VPadCafe::VPadCafe()
: Pad(),
  m_IsConnected( false ),
  m_PadDevice( NULL )
{
}

//------------------------------------------------------------------------------
void
VPadCafe::GetVPadStatus( VPADStatus* pad )
{
    if ( m_PadDevice )
    {
        *pad = m_PadDevice->GetVPadInfo().status[0];
    }
}

//------------------------------------------------------------------------------
void
VPadCafe::UpdateImpl()
{
    if ( m_PadDevice == NULL ) return;

    const VPadDeviceCafe::VPadInfo& vpadInfo = m_PadDevice->GetVPadInfo();

    if ( vpadInfo.lastReadLength > 0 || vpadInfo.lastReadError == VPAD_READ_ERR_NO_DATA )
    {
        const VPADStatus& lastStatus = vpadInfo.status[0];
        u32 padHold = lastStatus.hold;

        m_PadHold.SetAllZero();
        m_PadHold.ChangeMask(MASK_A, padHold & VPAD_BUTTON_A);
        m_PadHold.ChangeMask(MASK_B, padHold & VPAD_BUTTON_B);
        m_PadHold.ChangeMask(MASK_X, padHold & VPAD_BUTTON_X);
        m_PadHold.ChangeMask(MASK_Y, padHold & VPAD_BUTTON_Y);
        m_PadHold.ChangeMask(MASK_ZL, padHold & VPAD_TRIGGER_ZL);
        m_PadHold.ChangeMask(MASK_ZR, padHold & VPAD_TRIGGER_ZR);
        m_PadHold.ChangeMask(MASK_L, padHold & VPAD_TRIGGER_L);
        m_PadHold.ChangeMask(MASK_R, padHold & VPAD_TRIGGER_R);
        m_PadHold.ChangeMask(MASK_PLUS | MASK_START, padHold & VPAD_BUTTON_PLUS);
        m_PadHold.ChangeMask(MASK_MINUS | MASK_SELECT, padHold & VPAD_BUTTON_MINUS);
        m_PadHold.ChangeMask(MASK_HOME, padHold & VPAD_BUTTON_HOME);
        m_PadHold.ChangeMask(MASK_RIGHT, padHold & VPAD_BUTTON_RIGHT);
        m_PadHold.ChangeMask(MASK_LEFT, padHold & VPAD_BUTTON_LEFT);
        m_PadHold.ChangeMask(MASK_UP, padHold & VPAD_BUTTON_UP);
        m_PadHold.ChangeMask(MASK_DOWN, padHold & VPAD_BUTTON_DOWN);

        m_LeftStick.Set( lastStatus.lStick.x, lastStatus.lStick.y );
        m_RightStick.Set( lastStatus.rStick.x, lastStatus.rStick.y );

        m_LeftAnalogTrigger = 0.f;
        m_RightAnalogTrigger = 0.f;

        // タッチパネルの値を設定
        // MEMO: 現在、タッチパネルの座標は左上 (0, 0) 、 右下 (1280, 720) となっている模様。
        VPADTPData tp_data;
        VPADGetTPCalibratedPoint( 0, &tp_data, &lastStatus.tpData );
        m_PointerPrev = m_Pointer;
        SetPointerWithBound( tp_data.touch != 0 && tp_data.validity == VPAD_TP_VALIDITY_VALID, true, nw::math::VEC2( tp_data.x, tp_data.y ) );
        m_IsConnected = true;
    }
    else
    {
        m_IsConnected = false;
    }
}

} // namespace demo
} // namespace nw

