﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/demo/gl/demo_FrameBufferGL.h>
#include <nw/demo/gl/demo_TextureFrameBufferGL.h>
#include <nw/demo/gl/demo_FrameBufferUtilGL.h>

namespace nw
{
namespace demo
{

//------------------------------------------------------------------------------
TextureFrameBufferGL::TextureFrameBufferGL()
: FrameBuffer(),
  m_FBO( 0 ),
  m_ColorTexture( NULL ),
  m_DepthTexture( NULL )
{
}

//------------------------------------------------------------------------------
TextureFrameBufferGL::TextureFrameBufferGL( const nw::math::VEC2& size )
: FrameBuffer( size ),
  m_FBO( 0 ),
  m_ColorTexture( NULL ),
  m_DepthTexture( NULL )
{
}

//------------------------------------------------------------------------------
TextureFrameBufferGL::~TextureFrameBufferGL()
{
    if ( m_FBO )
    {
        glDeleteFramebuffersEXT( 1, &m_FBO );
    }
}

//------------------------------------------------------------------------------
void
TextureFrameBufferGL::Setup( nw::gfnd::TextureGL* colorTexture, nw::gfnd::TextureGL* depthTexture )
{
    if ( m_FBO != 0 )
    {
        NW_ERR( "Setup twice." );
        return;
    }

    NW_ASSERT( colorTexture || depthTexture );

    {
        // フレームバッファ生成。
        glGenFramebuffersEXT( 1, &m_FBO );
        NW_ASSERT( m_FBO != 0 );

        glBindFramebufferEXT( GL_FRAMEBUFFER_EXT, m_FBO );
        NW_GL_ASSERT();

        // テクスチャとデプスバッファのバインド。
        if ( colorTexture )
        {
            glFramebufferTexture2DEXT( GL_FRAMEBUFFER_EXT, GL_COLOR_ATTACHMENT0_EXT, GL_TEXTURE_2D, colorTexture->GetID(), 0 );
        }
        if ( depthTexture )
        {
            glFramebufferTexture2DEXT( GL_FRAMEBUFFER_EXT, GL_DEPTH_ATTACHMENT_EXT, GL_TEXTURE_2D, depthTexture->GetID(), 0 );
        }
        NW_GL_ASSERT();
    }

    m_ColorTexture = colorTexture;
    m_DepthTexture = depthTexture;
}

//------------------------------------------------------------------------------
void
TextureFrameBufferGL::BindImpl() const
{
    glBindFramebufferEXT( GL_FRAMEBUFFER_EXT, m_FBO );
    NW_GL_ASSERT();
}

//------------------------------------------------------------------------------
void
TextureFrameBufferGL::CopyToDisplayBuffer( const DisplayBufferGL* displayBuffer ) const
{
    NW_ASSERT( displayBuffer );
    CopyToFrameBuffer( m_ColorTexture, displayBuffer->GetHandle(), displayBuffer->GetWidth(), displayBuffer->GetHeight() );
}

} // namespace demo
} // namespace nw
