﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEMO_V_PAD_DEVICE_CAFE_H_
#define NW_DEMO_V_PAD_DEVICE_CAFE_H_

#include <nw/ut/ut_Memory.h>
#include <cafe/vpad.h>

namespace nw
{
namespace demo
{

//---------------------------------------------------------------------------
//! @brief        Cafe VPAD デバイス情報管理クラスです。
//!
//! @details :category     入力デバイス
//---------------------------------------------------------------------------
class VPadDeviceCafe
{
public:
    //! @brief VPAD 情報を表す構造体です。
    struct VPadInfo
    {
        VPADStatus status[VPAD_MAX_READ_BUFS];
        s32 lastReadLength;
        s32 lastReadError;

        //! @brief コンストラクタです。
        VPadInfo()
            : lastReadLength( 0 )
            , lastReadError( VPAD_READ_ERR_NO_CONTROLLER )
        {}
    };


    //---------------------------------------------------------------------------
    //! @brief        インスタンスを取得します。
    //!
    //! @return       シングルトンのインスタンスを返します。
    //---------------------------------------------------------------------------
    static VPadDeviceCafe* GetInstance()
    {
        static VPadDeviceCafe s_Instance;
        return &s_Instance;
    }


    //---------------------------------------------------------------------------
    //! @brief        初期化処理です。VPADInit() が SDK 2.06 で廃止されたため廃止します。
    //---------------------------------------------------------------------------
    NW_DEPRECATED_FUNCTION(void Initialize());

    //---------------------------------------------------------------------------
    //! @brief        終了処理です。VPadShutdown() が SDK 2.06 で廃止されたため廃止します。
    //---------------------------------------------------------------------------
    NW_DEPRECATED_FUNCTION(void Finalize());

    //---------------------------------------------------------------------------
    //! @brief        デバイスを更新します。
    //---------------------------------------------------------------------------
    void Update();

    //---------------------------------------------------------------------------
    //! @brief        VPAD で読み込んだ値の情報を取得します。
    //!
    //! @return       パッドの状態を返します。
    //---------------------------------------------------------------------------
    const VPadInfo& GetVPadInfo() const { return m_VPadInfo; }


protected:
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //---------------------------------------------------------------------------
    VPadDeviceCafe()
    {
        if (s_pInstance != NULL)
        {
            NW_FATAL_ERROR("nw::demo::WPadDeviceCafe instance already exists.");
        }
        s_pInstance = this;
    }


    VPadInfo m_VPadInfo;

    static VPadDeviceCafe* s_pInstance;

};

} // namespace demo
} // namespace nw

#endif // NW_DEMO_V_PAD_DEVICE_CAFE_H_
