﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEMO_TEXTURE_FRAME_BUFFER_GL_H_
#define NW_DEMO_TEXTURE_FRAME_BUFFER_GL_H_

#include <nw/demo/gl/demo_FrameBufferGL.h>
#include <nw/gfnd/gl/gfnd_TextureGL.h>

namespace nw
{
namespace demo
{

//---------------------------------------------------------------------------
//! @brief   GL 用のテクスチャに直接描画を行うフレームバッファクラスです。
//---------------------------------------------------------------------------
class TextureFrameBufferGL : public FrameBuffer
{
public:
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //---------------------------------------------------------------------------
    TextureFrameBufferGL();

    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //!
    //! @param[in]    size     フレームバッファサイズです。
    //---------------------------------------------------------------------------
    /* ctor */ explicit TextureFrameBufferGL( const nw::math::VEC2& size );

    //---------------------------------------------------------------------------
    //! @brief        デストラクタです。
    //---------------------------------------------------------------------------
    virtual ~TextureFrameBufferGL();


    //---------------------------------------------------------------------------
    //! @brief        テクスチャを指定して、フレームバッファオブジェクトをセットアップします。
    //!
    //! @param[in]    colorTexture カラー用テクスチャです。
    //! @param[in]    depthTexture デプス用テクスチャです。
    //---------------------------------------------------------------------------
    void Setup( nw::gfnd::TextureGL* colorTexture, nw::gfnd::TextureGL* depthTexture = NULL );

    //---------------------------------------------------------------------------
    //! @brief        ディスプレイバッファにコピーします。
    //!
    //! @param[in]    displayBuffer コピー先のディスプレイバッファへのポインタです。
    //---------------------------------------------------------------------------
    void CopyToDisplayBuffer( const DisplayBufferGL* displayBuffer ) const;

    //---------------------------------------------------------------------------
    //! @brief        フレームバッファオブジェクトを取得します。
    //!
    //! @return       フレームバッファオブジェクトを返します。
    //---------------------------------------------------------------------------
    GLuint GetFBO() const { return m_FBO; }


protected:
    virtual void BindImpl() const;

private:
    GLuint               m_FBO;
    nw::gfnd::TextureGL* m_ColorTexture;
    nw::gfnd::TextureGL* m_DepthTexture;
};

} // namespace demo
} // namespace nw

#endif // NW_DEMO_TEXTURE_FRAME_BUFFER_GL_H_
