﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEMO_FRAME_BUFFER_CAFE_H_
#define NW_DEMO_FRAME_BUFFER_CAFE_H_

#include <nw/demo/demo_FrameBuffer.h>
#include <cafe/gx2.h>

namespace nw
{
namespace demo
{

//---------------------------------------------------------------------------
//! @brief        Cafe 上でのフレームバッファを表すクラスです。
//---------------------------------------------------------------------------
class FrameBufferCafe : public FrameBuffer
{
public:
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //---------------------------------------------------------------------------
    FrameBufferCafe() : FrameBuffer() {}

    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //!
    //! @param[in]    size        フレームバッファサイズです。
    //! @param[in]    colorBuffer 割り当てるカラーバッファです。
    //! @param[in]    depthBuffer 割り当てるデプスバッファです。
    //---------------------------------------------------------------------------
    FrameBufferCafe(
        const nw::math::VEC2& size,
        GX2ColorBuffer* colorBuffer,
        GX2DepthBuffer* depthBuffer
    )
      : FrameBuffer( size ),
        m_ColorBuffer(colorBuffer),
        m_DepthBuffer(depthBuffer)
        {}

    //---------------------------------------------------------------------------
    //! @brief        デストラクタです。
    //---------------------------------------------------------------------------
    virtual ~FrameBufferCafe();


    //---------------------------------------------------------------------------
    //! @brief        割り当てられたカラーバッファを取得します。
    //!
    //! @return       カラーバッファを返します。
    //---------------------------------------------------------------------------
    GX2ColorBuffer* GetGX2ColorBuffer() const { return m_ColorBuffer; }

    //---------------------------------------------------------------------------
    //! @brief        割り当てられたデプスバッファを取得します。
    //!
    //! @return       デプスバッファを返します。
    //---------------------------------------------------------------------------
    GX2DepthBuffer* GetGX2DepthBuffer() const { return m_DepthBuffer; }


protected:
    //! @brief 結び付けられたフレームバッファオブジェクトをバインドします。
    virtual void BindImpl() const;

    GX2ColorBuffer* m_ColorBuffer;
    GX2DepthBuffer* m_DepthBuffer;
};

} // namespace nw::demo
} // namespace nw

#endif // NW_DEMO_FRAME_BUFFER_CAFE_H_
