﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{OutputFileHeaders.h,PageSampleNvnTutorialLibrary}
 *
 * @brief
 *  This file defines the data structures that make up the
 *  the overall structure of the output asset file. All offsets
 *  are from the beginning of the file. If an offset is 0, that
 *  means that the corresponding block does not exist.
 */

#pragma once

#include <cstdint>

struct OutputFileHeader
{
    uint32_t m_MagicPadding;
    float    m_Version;
    uint64_t m_ShaderBlockOffset;
    uint64_t m_TextureBlockOffset;
    uint64_t m_ModelBlockOffset;
};

struct ShaderBlockHeader
{
    uint32_t  m_NumShaderPrograms;
    uint32_t  m_MagicPadding;
    uint64_t* m_pShaderProgramOffsets;
};

struct ShaderProgramHeader
{
    uint32_t    m_NumShaderStages;
    uint32_t    m_ProgramNameLength;
    uint32_t    m_ShaderScratchMemorySize;
    uint32_t    m_MagicPadding;
    uint64_t*   m_pShaderStageOffsets;
    const char* m_pProgramName;
};

struct ShaderStageHeader
{
    uint32_t m_ShaderStage;
    uint32_t m_ShaderDataSize;
    uint32_t m_ShaderControlSize;
    uint32_t m_ShaderControlOffset;
    void*    m_pShaderData;
    void*    m_pShaderControl;
};

struct TextureBlockHeader
{
    uint32_t  m_NumTextures;
    uint32_t  m_MagicPadding;
    uint64_t* m_pTextureOffsets;
};

struct TextureDataHeader
{
    uint64_t       m_TextureDataSize;
    int            m_GpuVersion;
    uint32_t       m_Alignment;
    uint32_t       m_Width;
    uint32_t       m_Height;
    uint32_t       m_Depth;
    uint32_t       m_NvnTextureTarget;
    uint32_t       m_NvnFormat;
    uint32_t       m_MipLevels;
    uint32_t       m_TextureNameLength;
    uint32_t       m_TextureDataOffset;
    const char*    m_pTextureName;
    void*          m_pTextureData;
};

struct ModelBlockHeader
{
    uint32_t  m_NumModels;
    uint32_t  m_MagicPadding;
    uint64_t* m_pModelOffsets;
};

struct ModelHeader
{
    uint32_t    m_NumPrimitives;
    uint32_t    m_NvnDrawPrimitiveType;
    uint32_t    m_NumVertexAttributes;
    uint32_t    m_ModelNameLength;
    uint64_t    m_IndexBufferOffset;
    uint64_t*   m_pVertexAttributeOffsets;
    const char* m_pModelName;
};

struct VertexAttributeHeader
{
    uint32_t    m_AttributeStride;
    uint32_t    m_NvnFormat;
    uint32_t    m_AttributeDataSize;
    uint32_t    m_AttributeNameLength;
    uint32_t    m_AttributeDataOffset;
    uint32_t    m_MagicPadding;
    const char* m_pAttributeName;
    void*       m_AttributeData;
};

struct IndexBufferHeader
{
    uint32_t m_IndexBufferSize;
    uint32_t m_NumIndices;
    uint32_t m_IndexType;
    uint32_t m_MagicPadding;
    void*    m_pIndexData;
};
