﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{DebugTextData.h,PageSampleNvnTutorialLibrary}
 *
 * @brief
 *  This file contains the raw texture data for the debug text
 *  renderer font.
 */

#pragma once

#include <cstdint>

/* Data format :texWidth, texHeight, channels, bitsPerChannel, lineHeight, numCharData */
static uint32_t s_FontHeaderP[] = { 256, 128, 1, 8, 32, 95 };
static uint32_t s_FontHeaderF[] = { 256, 128, 1, 8, 32, 95 };

/* Char format : id, x, y, width, height, xoffset, yoffset, xadvance */
static int32_t s_CharDataP[][8] =
{
    { 32, 250, 82, 5, 3, -2, 24, 10 },
    { 33, 243, 62, 9, 19, 0, 7, 9 },
    { 34, 241, 100, 13, 9, -1, 6, 11 },
    { 35, 214, 43, 19, 19, -1, 7, 17 },
    { 36, 132, 0, 17, 23, -1, 5, 14 },
    { 37, 203, 0, 24, 20, -2, 7, 20 },
    { 38, 0, 28, 22, 20, -1, 7, 18 },
    { 39, 200, 117, 9, 9, -1, 6, 7 },
    { 40, 53, 0, 13, 24, -1, 6, 10 },
    { 41, 95, 0, 12, 24, -1, 6, 10 },
    { 42, 224, 100, 16, 13, -1, 6, 13 },
    { 43, 154, 85, 20, 16, -1, 10, 18 },
    { 44, 188, 117, 11, 9, -1, 20, 9 },
    { 45, 240, 114, 14, 5, -1, 16, 12 },
    { 46, 230, 114, 9, 6, 0, 20, 8 },
    { 47, 234, 21, 17, 20, -2, 7, 13 },
    { 48, 142, 24, 18, 20, -1, 7, 16 },
    { 49, 118, 86, 13, 19, 0, 7, 16 },
    { 50, 52, 87, 16, 19, 0, 7, 16 },
    { 51, 180, 22, 17, 20, 0, 7, 16 },
    { 52, 40, 67, 19, 19, -2, 7, 16 },
    { 53, 0, 49, 16, 20, 0, 7, 16 },
    { 54, 161, 22, 18, 20, -1, 7, 16 },
    { 55, 207, 63, 17, 19, 0, 7, 16 },
    { 56, 85, 25, 18, 20, -1, 7, 16 },
    { 57, 123, 24, 18, 20, -1, 7, 16 },
    { 58, 104, 107, 9, 15, 1, 11, 10 },
    { 59, 142, 85, 11, 18, -1, 11, 11 },
    { 60, 213, 83, 18, 16, -1, 10, 17 },
    { 61, 155, 117, 19, 10, 0, 13, 18 },
    { 62, 175, 85, 18, 16, 0, 10, 17 },
    { 63, 225, 63, 17, 19, -1, 7, 15 },
    { 64, 228, 0, 23, 20, -1, 9, 20 },
    { 65, 193, 43, 20, 19, -2, 7, 17 },
    { 66, 135, 65, 17, 19, 0, 7, 15 },
    { 67, 66, 25, 18, 20, -2, 7, 15 },
    { 68, 60, 67, 18, 19, 0, 7, 17 },
    { 69, 69, 87, 16, 19, -1, 7, 15 },
    { 70, 35, 90, 16, 19, -1, 7, 14 },
    { 71, 45, 25, 20, 20, -2, 7, 17 },
    { 72, 20, 70, 19, 19, -1, 7, 17 },
    { 73, 132, 86, 9, 19, 0, 7, 9 },
    { 74, 34, 46, 16, 20, -2, 7, 13 },
    { 75, 79, 67, 18, 19, -1, 7, 16 },
    { 76, 171, 65, 17, 19, -1, 7, 15 },
    { 77, 128, 45, 22, 19, -1, 7, 20 },
    { 78, 0, 70, 19, 19, -1, 7, 17 },
    { 79, 23, 25, 21, 20, -2, 7, 18 },
    { 80, 189, 63, 17, 19, 0, 7, 16 },
    { 81, 108, 0, 23, 23, -2, 7, 18 },
    { 82, 153, 65, 17, 19, 0, 7, 16 },
    { 83, 17, 49, 16, 20, -1, 7, 14 },
    { 84, 98, 67, 18, 19, -1, 7, 16 },
    { 85, 104, 25, 18, 20, -1, 7, 16 },
    { 86, 172, 43, 20, 19, -2, 7, 17 },
    { 87, 103, 46, 24, 19, -1, 7, 21 },
    { 88, 234, 42, 19, 19, -1, 7, 16 },
    { 89, 151, 45, 20, 19, -2, 7, 16 },
    { 90, 117, 66, 17, 19, -1, 7, 15 },
    { 91, 81, 0, 13, 24, 0, 6, 12 },
    { 92, 68, 46, 16, 20, -1, 7, 13 },
    { 93, 67, 0, 13, 24, -1, 6, 12 },
    { 94, 203, 100, 20, 13, -2, 7, 16 },
    { 95, 114, 122, 19, 5, -2, 25, 14 },
    { 96, 175, 117, 12, 9, -2, 5, 8 },
    { 97, 32, 110, 15, 16, -1, 11, 14 },
    { 98, 216, 21, 17, 20, -1, 7, 15 },
    { 99, 0, 110, 15, 16, -2, 11, 12 },
    { 100, 51, 46, 16, 20, -1, 7, 15 },
    { 101, 232, 83, 17, 16, -2, 11, 13 },
    { 102, 86, 87, 15, 19, -1, 7, 13 },
    { 103, 168, 0, 17, 21, -2, 11, 14 },
    { 104, 18, 90, 16, 19, -1, 7, 14 },
    { 105, 94, 46, 8, 20, 0, 6, 9 },
    { 106, 9, 0, 12, 26, -3, 6, 9 },
    { 107, 0, 90, 17, 19, -1, 7, 14 },
    { 108, 85, 46, 8, 20, 0, 6, 9 },
    { 109, 48, 110, 21, 15, -1, 11, 19 },
    { 110, 70, 107, 16, 15, -1, 11, 14 },
    { 111, 194, 83, 18, 16, -2, 11, 14 },
    { 112, 150, 0, 17, 21, -1, 11, 14 },
    { 113, 186, 0, 16, 21, -1, 11, 14 },
    { 114, 188, 102, 14, 14, -1, 12, 12 },
    { 115, 16, 110, 15, 16, -1, 11, 13 },
    { 116, 102, 87, 15, 19, -1, 8, 13 },
    { 117, 87, 107, 16, 15, -1, 12, 14 },
    { 118, 137, 106, 17, 14, -2, 12, 14 },
    { 119, 114, 107, 22, 14, -1, 12, 19 },
    { 120, 155, 102, 16, 14, -1, 12, 14 },
    { 121, 198, 22, 17, 20, -1, 12, 15 },
    { 122, 172, 102, 15, 14, -1, 12, 14 },
    { 123, 22, 0, 15, 24, -1, 6, 13 },
    { 124, 0, 0, 8, 27, 1, 5, 9 },
    { 125, 38, 0, 14, 24, 0, 6, 13 },
    { 126, 210, 114, 19, 8, -1, 14, 17 },
};

static int32_t s_CharDataF[][8] =
{
    { 32, 248, 41, 5, 3, -2, 24, 12 },
    { 33, 245, 21, 8, 19, 2, 7, 12 },
    { 34, 12, 107, 12, 9, 0, 6, 12 },
    { 35, 47, 46, 15, 19, -2, 7, 12 },
    { 36, 115, 0, 14, 23, -1, 5, 12 },
    { 37, 176, 0, 16, 20, -2, 7, 12 },
    { 38, 193, 0, 16, 20, -2, 7, 12 },
    { 39, 35, 106, 8, 9, 2, 6, 12 },
    { 40, 49, 0, 12, 24, 0, 6, 12 },
    { 41, 62, 0, 11, 24, 0, 6, 12 },
    { 42, 221, 79, 15, 13, -2, 6, 12 },
    { 43, 161, 83, 14, 14, -1, 11, 12 },
    { 44, 25, 106, 9, 9, 1, 20, 12 },
    { 45, 84, 102, 12, 5, 0, 16, 12 },
    { 46, 59, 104, 9, 6, 1, 20, 12 },
    { 47, 32, 25, 15, 20, -2, 7, 12 },
    { 48, 186, 21, 14, 20, -1, 7, 12 },
    { 49, 184, 63, 12, 19, -1, 7, 12 },
    { 50, 130, 65, 13, 19, -1, 7, 12 },
    { 51, 201, 21, 14, 20, -1, 7, 12 },
    { 52, 95, 46, 15, 19, -2, 7, 12 },
    { 53, 216, 21, 14, 20, -1, 7, 12 },
    { 54, 141, 22, 14, 20, -1, 7, 12 },
    { 55, 102, 66, 13, 19, -1, 7, 12 },
    { 56, 210, 0, 15, 20, -2, 7, 12 },
    { 57, 96, 25, 14, 20, -1, 7, 12 },
    { 58, 119, 85, 8, 15, 2, 11, 12 },
    { 59, 197, 62, 10, 18, 0, 11, 12 },
    { 60, 15, 89, 14, 16, -1, 10, 12 },
    { 61, 237, 79, 14, 10, -1, 13, 12 },
    { 62, 224, 62, 14, 16, -1, 10, 12 },
    { 63, 158, 43, 14, 19, -1, 7, 12 },
    { 64, 226, 0, 15, 20, -2, 9, 12 },
    { 65, 14, 49, 16, 19, -2, 7, 12 },
    { 66, 143, 43, 14, 19, -1, 7, 12 },
    { 67, 242, 0, 13, 20, -1, 7, 12 },
    { 68, 45, 68, 14, 19, -1, 7, 12 },
    { 69, 60, 66, 13, 19, -1, 7, 12 },
    { 70, 158, 63, 12, 19, 0, 7, 12 },
    { 71, 48, 25, 15, 20, -2, 7, 12 },
    { 72, 188, 42, 14, 19, -1, 7, 12 },
    { 73, 74, 66, 13, 19, -1, 7, 12 },
    { 74, 231, 21, 13, 20, -1, 7, 12 },
    { 75, 203, 42, 14, 19, -1, 7, 12 },
    { 76, 171, 63, 12, 19, 0, 7, 12 },
    { 77, 79, 46, 15, 19, -2, 7, 12 },
    { 78, 173, 43, 14, 19, -1, 7, 12 },
    { 79, 64, 25, 15, 20, -2, 7, 12 },
    { 80, 218, 42, 14, 19, -1, 7, 12 },
    { 81, 98, 0, 16, 23, -2, 7, 12 },
    { 82, 233, 42, 14, 19, -1, 7, 12 },
    { 83, 171, 22, 14, 20, -1, 7, 12 },
    { 84, 30, 69, 14, 19, -1, 7, 12 },
    { 85, 156, 22, 14, 20, -1, 7, 12 },
    { 86, 111, 45, 15, 19, -2, 7, 12 },
    { 87, 127, 45, 15, 19, -2, 7, 12 },
    { 88, 31, 48, 15, 19, -2, 7, 12 },
    { 89, 63, 46, 15, 19, -2, 7, 12 },
    { 90, 88, 66, 13, 19, -1, 7, 12 },
    { 91, 86, 0, 11, 24, 1, 6, 12 },
    { 92, 16, 27, 15, 20, -2, 7, 12 },
    { 93, 74, 0, 11, 24, 0, 6, 12 },
    { 94, 205, 81, 15, 13, -2, 7, 12 },
    { 95, 69, 104, 14, 5, -1, 25, 12 },
    { 96, 0, 107, 11, 10, 0, 5, 12 },
    { 97, 239, 62, 14, 16, -1, 11, 12 },
    { 98, 111, 24, 14, 20, -1, 7, 12 },
    { 99, 45, 88, 13, 16, -1, 11, 12 },
    { 100, 80, 25, 15, 20, -2, 7, 12 },
    { 101, 30, 89, 14, 16, -1, 11, 12 },
    { 102, 116, 65, 13, 19, -1, 7, 12 },
    { 103, 161, 0, 14, 21, -1, 11, 12 },
    { 104, 0, 70, 14, 19, -1, 7, 12 },
    { 105, 0, 49, 13, 20, 0, 6, 12 },
    { 106, 8, 0, 11, 26, -1, 6, 12 },
    { 107, 15, 69, 14, 19, -1, 7, 12 },
    { 108, 126, 24, 14, 20, -1, 7, 12 },
    { 109, 59, 88, 16, 15, -2, 11, 12 },
    { 110, 76, 86, 14, 15, -1, 11, 12 },
    { 111, 208, 62, 15, 16, -2, 11, 12 },
    { 112, 146, 0, 14, 21, -1, 11, 12 },
    { 113, 130, 0, 15, 21, -2, 11, 12 },
    { 114, 91, 86, 13, 15, 0, 11, 12 },
    { 115, 0, 90, 14, 16, -1, 11, 12 },
    { 116, 144, 63, 13, 19, -1, 8, 12 },
    { 117, 105, 86, 13, 15, -1, 12, 12 },
    { 118, 145, 83, 15, 14, -2, 12, 12 },
    { 119, 128, 85, 16, 14, -2, 12, 12 },
    { 120, 176, 83, 14, 14, -1, 12, 12 },
    { 121, 0, 28, 15, 20, -2, 12, 12 },
    { 122, 191, 83, 13, 14, -1, 12, 12 },
    { 123, 35, 0, 13, 24, -1, 6, 12 },
    { 124, 0, 0, 7, 27, 2, 5, 12 },
    { 125, 20, 0, 14, 24, -1, 6, 12 },
    { 126, 44, 106, 14, 6, -1, 15, 12 },
};

    /* This is the image data for the font texture. */
static uint8_t s_FontImageDataP[] =
{
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 219, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 103, 115, 71, 19,
    0, 0, 0, 0, 0, 0, 0, 0, 11, 59, 111, 115, 63, 11, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 15, 79, 111, 51, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 95, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 95,
    0, 0, 0, 0, 0, 0, 0, 0, 23, 183, 255, 155, 3, 0, 0, 0, 0, 0, 71, 199,
    227, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 127, 71, 7, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 3, 131, 255, 255, 255, 255, 255, 255, 199, 0, 0, 0,
    0, 0, 39, 243, 255, 255, 255, 255, 255, 255, 207, 31, 0, 0, 0, 0, 0, 0, 0, 131,
    255, 255, 255, 255, 255, 179, 255, 255, 255, 0, 0, 0, 0, 0, 63, 255, 255, 255, 31, 0,
    0, 255, 255, 255, 95, 0, 0, 191, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    63, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 87, 23, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 163, 255, 255, 163, 0, 0, 0, 0, 0, 0, 95, 255, 255, 255, 27, 0,
    0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3, 191, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 255, 255, 255, 255, 255, 227, 7, 0, 0, 0, 0, 0, 103, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 63, 255, 255, 255, 31, 0, 0, 255, 255, 255,
    95, 0, 0, 191, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59,
    255, 255, 255, 55, 0, 0, 0, 0, 0, 0, 23, 255, 255, 255, 131, 0, 0, 0, 0, 0,
    0, 0, 11, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103,
    255, 255, 255, 119, 0, 0, 0, 27, 27, 0, 0, 0, 0, 0, 23, 51, 27, 0, 0, 0,
    75, 255, 255, 255, 67, 0, 0, 0, 0, 0, 199, 255, 255, 231, 11, 3, 135, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 63, 255, 255, 255, 31, 0, 0, 255, 255, 255, 95, 0, 0, 191,
    255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 211, 255, 255, 211, 0,
    0, 0, 0, 0, 0, 0, 0, 211, 255, 255, 239, 7, 0, 0, 0, 0, 0, 0, 31, 255,
    255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 255, 255, 203, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 255, 255, 255,
    79, 0, 0, 0, 0, 0, 223, 255, 255, 139, 0, 0, 0, 195, 255, 255, 255, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 31, 0, 0, 255, 255, 255, 95, 0, 0, 191, 255, 255, 159, 0,
    0, 0, 0, 0, 63, 255, 255, 255, 31, 0, 0, 0, 127, 255, 255, 223, 0, 0, 0, 0,
    0, 0, 0, 0, 35, 99, 91, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255,
    255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 219, 59, 0, 0, 0, 0, 0, 0, 103, 255, 255, 255, 107, 0, 0, 0, 0, 0,
    0, 0, 0, 143, 255, 255, 255, 91, 0, 0, 0, 0, 0, 0, 39, 255, 255, 255, 91, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 131, 187, 123, 31, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 251, 255, 255, 139, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 255, 255, 255, 255, 27, 0, 0, 0,
    0, 0, 191, 255, 255, 187, 0, 0, 0, 115, 255, 255, 255, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 31, 0, 0, 255, 255, 255, 95, 0, 0, 191, 255, 255, 159, 0, 0, 0, 0, 0,
    63, 255, 255, 255, 31, 0, 0, 0, 127, 255, 255, 223, 0, 0, 0, 0, 0, 0, 39, 251,
    255, 255, 255, 255, 251, 211, 255, 255, 159, 0, 0, 0, 0, 0, 223, 255, 255, 255, 31, 0,
    0, 0, 0, 0, 0, 0, 11, 255, 255, 255, 255, 79, 0, 0, 243, 255, 255, 255, 95, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 95,
    0, 0, 0, 0, 0, 19, 255, 255, 255, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 71,
    255, 255, 255, 199, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 95, 0, 0, 0, 0, 0,
    0, 63, 63, 0, 0, 0, 11, 171, 255, 255, 255, 255, 255, 147, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 59, 215, 255, 255, 255, 255, 255, 131, 0, 0, 0, 0, 0, 0, 83, 255,
    255, 255, 211, 51, 0, 95, 255, 255, 255, 0, 0, 0, 0, 0, 63, 255, 255, 255, 31, 0,
    0, 255, 255, 255, 95, 0, 0, 191, 255, 255, 159, 0, 0, 0, 0, 0, 63, 255, 255, 255,
    31, 0, 0, 0, 127, 255, 255, 223, 0, 0, 0, 0, 0, 0, 219, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 159, 0, 0, 0, 0, 0, 223, 255, 255, 255, 31, 0, 0, 0, 0, 0,
    0, 0, 71, 255, 255, 255, 255, 131, 0, 43, 255, 255, 255, 255, 159, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 91, 255, 255, 255, 255, 47, 0, 0, 0, 0, 0, 0, 0,
    0, 95, 191, 191, 191, 191, 191, 191, 191, 191, 191, 191, 191, 191, 131, 35, 0, 0, 0, 0,
    0, 75, 235, 255, 255, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 139, 255, 255, 143,
    15, 0, 0, 0, 0, 0, 47, 239, 255, 255, 91, 0, 0, 0, 0, 0, 119, 255, 255, 155,
    7, 27, 223, 255, 255, 255, 255, 255, 255, 255, 147, 0, 0, 0, 0, 0, 223, 255, 255, 255,
    31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 31, 255, 255, 255, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 159,
    255, 255, 255, 255, 255, 227, 63, 0, 0, 0, 0, 0, 0, 0, 0, 107, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 63, 255, 255, 255, 31, 0, 0, 255, 255, 255,
    95, 0, 0, 191, 255, 255, 159, 0, 0, 0, 0, 0, 63, 255, 255, 255, 31, 0, 0, 0,
    127, 255, 255, 223, 0, 0, 0, 0, 0, 51, 255, 255, 255, 103, 0, 19, 219, 255, 255, 255,
    159, 0, 0, 0, 0, 0, 111, 239, 255, 143, 15, 0, 0, 0, 0, 0, 0, 0, 135, 255,
    255, 255, 255, 179, 0, 91, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 175, 255, 255, 255, 255, 131, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 255, 255, 255, 255, 255, 255, 255,
    235, 27, 0, 43, 255, 255, 151, 0, 0, 0, 0, 0, 223, 255, 255, 255, 31, 0, 0, 0,
    0, 0, 15, 79, 127, 127, 127, 127, 127, 127, 71, 7, 0, 0, 0, 0, 0, 0, 0, 251,
    255, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 255, 255, 255, 227, 63,
    3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 119, 247, 255, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 63, 255, 255, 255, 31, 0, 0, 255, 255, 255, 95, 0, 0, 191,
    255, 255, 159, 0, 0, 0, 0, 0, 63, 255, 255, 255, 31, 0, 0, 0, 127, 255, 255, 223,
    0, 0, 0, 0, 0, 91, 255, 255, 255, 11, 0, 0, 31, 255, 255, 255, 159, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 255, 255, 255, 255, 235,
    0, 143, 255, 255, 255, 255, 255, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 255,
    255, 255, 255, 255, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 247, 255, 255, 255, 255, 167, 11, 0, 0, 0,
    19, 19, 0, 0, 0, 0, 0, 0, 223, 255, 255, 255, 31, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 255, 255, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 199, 255, 255, 207, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 215, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 255, 255, 247, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 39, 0, 11, 255, 255, 255, 107, 0, 0, 203, 255, 255, 159, 0,
    0, 0, 0, 0, 63, 255, 255, 255, 31, 0, 0, 0, 127, 255, 255, 223, 0, 0, 0, 0,
    0, 95, 255, 255, 255, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 255, 255, 255, 247, 255, 255, 27, 195, 255, 255,
    251, 255, 255, 103, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 255, 255, 211, 231, 255,
    255, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 23, 79, 67, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 111, 239, 255, 143, 15, 0, 0, 0, 0, 0, 39, 199, 255, 255, 255, 255,
    255, 255, 179, 19, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 255, 119, 0, 0, 0, 19,
    19, 0, 0, 0, 0, 0, 143, 255, 255, 235, 11, 0, 0, 0, 47, 47, 0, 0, 0, 0,
    0, 0, 31, 99, 75, 7, 0, 0, 3, 183, 255, 255, 199, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 179, 3, 79, 255, 255, 255, 247, 23, 15, 255, 255, 255, 127, 0, 0, 0, 0, 0,
    63, 255, 255, 255, 31, 0, 0, 0, 127, 255, 255, 223, 0, 0, 0, 0, 0, 95, 255, 255,
    255, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 79, 255, 255, 239, 163, 255, 255, 79, 243, 255, 255, 143, 255, 255, 167,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 255, 255, 135, 159, 255, 255, 143, 0, 0,
    0, 0, 0, 0, 0, 139, 255, 255, 255, 15, 0, 0, 67, 255, 255, 255, 99, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 3, 183, 255, 255, 255, 255, 255, 255, 255, 191, 0, 0, 0,
    0, 0, 43, 255, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 107, 0, 0, 0, 0, 0, 63, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 55, 0, 0, 0, 0, 0, 63, 255, 255, 255,
    31, 0, 0, 0, 135, 255, 255, 215, 0, 0, 0, 0, 0, 95, 255, 255, 255, 0, 0, 0,
    0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 143, 255, 255, 187, 115, 255, 255, 175, 255, 255, 227, 75, 255, 255, 235, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 19, 255, 255, 255, 63, 87, 255, 255, 227, 0, 0, 0, 0, 0, 0,
    0, 11, 235, 255, 255, 147, 0, 3, 215, 255, 255, 191, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 195, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 3, 131, 255, 255, 255, 255, 255, 255, 175, 0, 0, 0, 0, 0, 0, 63,
    255, 255, 255, 255, 255, 255, 255, 163, 0, 0, 0, 0, 0, 0, 31, 211, 255, 255, 255, 255,
    255, 255, 255, 119, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 223, 255, 255, 255, 255, 71,
    231, 255, 255, 255, 255, 119, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 103, 0, 0, 0,
    171, 255, 255, 191, 0, 0, 0, 0, 0, 95, 255, 255, 255, 0, 0, 0, 0, 223, 255, 255,
    159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 215, 255, 255,
    139, 67, 255, 255, 255, 255, 255, 179, 19, 255, 255, 255, 47, 0, 0, 0, 0, 0, 0, 0,
    0, 99, 255, 255, 247, 3, 15, 255, 255, 255, 59, 0, 0, 0, 0, 0, 0, 0, 71, 255,
    255, 255, 39, 103, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 3, 199, 255, 255, 255, 31,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 31, 67, 67, 43, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 55, 67,
    55, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 59, 67, 55, 23, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 59, 39, 3, 0, 0, 23, 59, 47,
    11, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 255, 67, 0, 23, 255, 255, 255, 143,
    0, 0, 0, 0, 0, 95, 255, 255, 255, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0,
    0, 0, 223, 255, 255, 255, 31, 0, 0, 0, 0, 0, 23, 255, 255, 255, 83, 15, 255, 255,
    255, 255, 255, 131, 0, 227, 255, 255, 111, 0, 0, 0, 0, 0, 0, 0, 0, 187, 255, 255,
    171, 0, 0, 195, 255, 255, 143, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 199, 251,
    255, 255, 115, 0, 0, 0, 0, 0, 0, 0, 0, 27, 255, 255, 255, 207, 3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 155, 255, 255, 95, 0, 0, 0, 0, 0, 0, 75, 235, 255, 175, 15, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 95, 223, 159, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 47, 0, 0, 0, 0,
    0, 95, 255, 255, 255, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 223, 255,
    255, 255, 31, 0, 0, 0, 0, 0, 87, 255, 255, 255, 35, 0, 219, 255, 255, 255, 255, 79,
    0, 175, 255, 255, 183, 0, 0, 0, 0, 0, 0, 0, 19, 255, 255, 255, 99, 0, 0, 123,
    255, 255, 227, 0, 0, 0, 0, 0, 0, 0, 0, 19, 255, 255, 255, 255, 255, 211, 3, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 67, 255, 255, 255, 151, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 255,
    255, 243, 7, 0, 0, 0, 0, 0, 211, 255, 255, 175, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 191, 255, 255, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    63, 255, 255, 255, 167, 255, 255, 255, 255, 255, 91, 0, 0, 0, 0, 0, 0, 95, 255, 255,
    255, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 223, 255, 255, 255, 31, 0,
    0, 0, 0, 0, 155, 255, 255, 239, 0, 0, 171, 255, 255, 255, 255, 27, 0, 123, 255, 255,
    247, 3, 0, 0, 0, 0, 0, 0, 99, 255, 255, 255, 27, 0, 0, 47, 255, 255, 255, 59,
    0, 0, 0, 0, 0, 0, 0, 0, 87, 255, 255, 255, 255, 47, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 127, 255, 255, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 255, 255, 111, 0,
    0, 0, 0, 79, 255, 255, 255, 47, 0, 0, 0, 0, 0, 0, 3, 147, 167, 23, 159, 255,
    255, 31, 95, 175, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 7, 43, 67, 31, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 255, 0, 0, 0,
    0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 83, 179, 191, 107, 11, 0, 0, 0, 0, 0,
    223, 255, 255, 187, 0, 0, 123, 255, 255, 255, 235, 0, 0, 75, 255, 255, 255, 55, 0, 0,
    0, 0, 0, 0, 187, 255, 255, 211, 0, 0, 0, 0, 227, 255, 255, 143, 0, 0, 0, 0,
    0, 0, 0, 0, 59, 255, 255, 255, 255, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 183, 255, 255, 255, 43, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 71, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 255, 255, 231, 3, 0, 0, 0, 199,
    255, 255, 175, 0, 0, 0, 0, 0, 0, 0, 115, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    235, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 63, 0, 0, 47, 255, 255, 255, 183, 3, 0, 0, 0, 0, 0,
    63, 255, 255, 255, 63, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 31, 255, 255,
    255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19,
    255, 255, 255, 135, 0, 0, 0, 0, 155, 255, 255, 227, 0, 0, 0, 0, 0, 0, 0, 7,
    223, 255, 255, 255, 255, 179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 243,
    255, 255, 223, 11, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 123, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 23, 255, 255, 255, 95, 0, 0, 63, 255, 255, 255, 47, 0,
    0, 0, 0, 0, 0, 0, 15, 147, 255, 255, 255, 255, 255, 255, 255, 255, 63, 0, 0, 0,
    0, 0, 0, 7, 71, 111, 47, 0, 47, 111, 71, 7, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 63, 0, 27, 255, 255, 255, 211, 11, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255,
    63, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135, 255, 255, 247, 255,
    255, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 255, 255, 255, 167,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 255, 23, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 143, 255, 255, 211, 0, 0, 179, 255, 255, 175, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 23, 235, 255, 255, 255, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 31,
    255, 255, 207, 0, 191, 255, 255, 47, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 11,
    227, 255, 255, 239, 23, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0,
    127, 255, 255, 255, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 255, 255, 255, 87, 103, 255, 255, 255, 19,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 255, 255, 255, 107, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 255, 255, 139, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    23, 255, 255, 255, 79, 47, 255, 255, 255, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79,
    255, 255, 255, 255, 255, 255, 255, 163, 19, 0, 0, 0, 0, 0, 0, 35, 255, 255, 223, 0,
    203, 255, 255, 63, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 67, 191, 255, 255, 255, 39,
    0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 127, 255, 255, 255,
    0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 223, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 191, 0, 0, 0, 0, 0, 31,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 55, 111, 111,
    59, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3, 211, 255, 255, 195, 0, 3, 215, 255, 255, 167, 0, 0, 0, 0,
    0, 0, 55, 255, 255, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 255, 255, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 255, 255,
    195, 163, 255, 255, 175, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 235, 7, 0, 0, 0, 0, 0, 63, 255, 255, 231, 0, 223, 255, 255, 71,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 223, 255, 255, 255, 55, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0,
    0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 191, 0, 0, 0, 0, 0, 31, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 255, 255, 255, 255, 255, 191, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 223, 0, 0, 0, 0, 0, 127, 255,
    255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 119, 255, 255, 255, 51, 0, 0, 67, 255, 255, 255, 75, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 63, 255, 255, 255, 43, 131,
    255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 255, 255, 255, 255, 255,
    47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 215, 255, 63, 159, 255, 255, 47, 163, 255,
    119, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 0, 231, 255, 255, 95, 0, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 255, 255, 255, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    63, 255, 255, 255, 63, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 31, 255, 255,
    255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 255, 255, 255, 255, 107,
    63, 63, 63, 63, 55, 23, 0, 0, 0, 0, 0, 31, 255, 255, 255, 175, 63, 63, 63, 63,
    63, 63, 31, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 27, 255, 255, 255, 255, 255, 255, 155, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 191, 255, 255, 223, 0, 0, 0, 0, 0, 127, 255, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 255, 255, 255, 255, 175, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183, 255, 255, 31, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 91, 255, 255, 255, 3, 255, 255, 255, 99, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 255, 255, 247, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255,
    63, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 255, 255, 255, 255, 67, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 87, 255, 255, 255, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 191, 255, 255, 223, 0, 0, 0, 0, 0, 127, 255, 255, 255, 63, 0, 0, 0, 0, 0,
    15, 143, 255, 155, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 23, 215, 255, 255, 239, 47, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 143, 255, 239, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71,
    255, 255, 215, 23, 191, 255, 255, 95, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 255, 255,
    255, 235, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 71, 0, 0, 0,
    127, 255, 255, 227, 0, 0, 0, 0, 0, 31, 255, 255, 255, 223, 127, 127, 127, 127, 127, 87,
    23, 0, 0, 0, 0, 0, 0, 0, 23, 235, 255, 255, 255, 83, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255,
    223, 0, 0, 0, 0, 0, 127, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 231, 255, 255,
    139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 87, 243, 255, 255, 207, 11,
    0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 163, 0, 0, 0, 143, 255, 255, 219,
    0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 95, 0, 0, 0,
    0, 0, 0, 0, 0, 11, 207, 255, 255, 255, 83, 0, 0, 0, 0, 0, 0, 0, 0, 31,
    255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 223, 0, 0, 0,
    0, 0, 127, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 163, 255, 255, 247, 7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 127, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 131, 179, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 39, 255, 255, 255, 207, 11, 0, 0, 0,
    0, 0, 0, 0, 63, 255, 255, 255, 255, 127, 3, 23, 251, 255, 255, 171, 0, 0, 0, 0,
    0, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 71, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 11, 207, 255, 255, 255, 71, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 223, 0, 0, 0, 0, 0, 127, 255,
    255, 255, 63, 0, 0, 0, 0, 0, 0, 95, 255, 255, 255, 99, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 127, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 223, 255, 255, 255, 83, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 63, 0, 39, 255, 255, 255, 207, 11, 0, 0, 0, 0, 0, 0,
    63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 75, 0, 0, 0, 0, 0, 31, 255, 255,
    255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11,
    219, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 191, 255, 255, 223, 0, 0, 0, 0, 0, 127, 255, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 23, 255, 255, 255, 207, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 127, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255,
    255, 255, 255, 131, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    3, 47, 107, 107, 47, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7, 99, 179, 87, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31,
    95, 123, 87, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 63, 0, 0, 47, 255, 255, 255, 179, 3, 0, 0, 0, 0, 0, 63, 255, 255, 255,
    191, 255, 255, 255, 255, 255, 111, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 255, 255, 255,
    183, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 159, 0,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 191, 255, 255, 223, 0, 0, 0, 0, 0, 127, 255, 255, 255, 63, 0, 0, 0, 0, 0,
    0, 0, 215, 255, 255, 255, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255,
    255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 103, 255, 255, 255, 255,
    255, 191, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 127, 255, 255, 255, 255,
    255, 255, 143, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23,
    147, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 3, 123, 255, 255, 255, 255, 255, 255,
    255, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 3, 39, 67,
    35, 3, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131, 255, 255, 255, 51, 0, 0,
    0, 0, 0, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 159, 0, 0, 0, 0, 0,
    71, 167, 231, 255, 255, 255, 231, 191, 191, 95, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255,
    223, 0, 0, 0, 0, 0, 127, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 79, 207,
    255, 199, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 127, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 191, 255, 255, 255, 255, 255,
    75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 171, 255, 255, 255, 255, 255, 255, 255, 255, 195,
    3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 215, 255, 255, 255, 255, 255,
    63, 0, 0, 0, 0, 0, 0, 0, 171, 255, 255, 255, 255, 255, 255, 255, 255, 127, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0, 31,
    255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 83, 179, 255, 255, 255, 255, 191, 191,
    191, 107, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 223, 0, 0, 0,
    0, 0, 127, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 15, 79, 127, 127, 127, 127, 223, 255, 255, 223, 127, 127, 127, 127, 71, 7,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 103, 255, 255, 255, 255, 239, 19, 0,
    0, 0, 0, 0, 0, 95, 255, 255, 255, 91, 0, 0, 75, 255, 255, 255, 111, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3, 87, 255, 255, 255, 255, 255, 203, 51, 0, 0, 0, 0, 0,
    0, 0, 0, 95, 255, 255, 255, 99, 0, 0, 0, 3, 31, 27, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 31, 255, 255, 255, 223, 127, 127, 127, 127, 127, 119, 55, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 235, 255, 255, 175, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 223, 255, 255, 255, 255, 255, 255,
    255, 127, 0, 0, 0, 0, 0, 0, 223, 255, 255, 255, 255, 255, 255, 255, 255, 255, 31, 0,
    0, 0, 0, 0, 35, 63, 27, 0, 0, 191, 255, 255, 223, 0, 0, 0, 0, 0, 127, 255,
    255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 31, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 255, 255, 255, 31, 0, 0, 0, 0, 0,
    0, 195, 255, 255, 187, 0, 0, 0, 0, 175, 255, 255, 215, 0, 0, 0, 0, 0, 0, 0,
    19, 139, 255, 255, 255, 255, 255, 115, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 199,
    255, 255, 179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 239, 255, 255, 187, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 111, 239, 255, 255, 255, 255, 255, 255, 255, 143, 15, 0, 0, 0, 0, 0,
    63, 255, 255, 59, 0, 191, 255, 255, 223, 0, 0, 0, 0, 0, 127, 255, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 199, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 179, 19, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 19, 135, 255, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 251, 255, 255,
    119, 0, 0, 0, 0, 107, 255, 255, 255, 15, 0, 0, 0, 0, 0, 91, 255, 255, 255, 255,
    215, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 251, 255, 255, 107, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 239,
    255, 239, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 239, 255, 239,
    47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 215, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 167, 0, 0, 0, 0, 0, 43, 51, 7, 0, 0, 0, 0, 55, 255, 255,
    255, 147, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 43, 255, 255, 255, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255,
    99, 191, 255, 255, 223, 0, 0, 0, 0, 0, 127, 255, 255, 255, 63, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255,
    255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 231,
    255, 255, 255, 255, 215, 51, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 95, 0, 0, 0,
    0, 75, 255, 255, 255, 31, 0, 0, 0, 0, 0, 127, 255, 255, 151, 15, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 235, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 127, 255, 255, 203, 99, 63, 119, 255, 255, 255, 255, 59, 0, 0,
    0, 0, 0, 31, 255, 255, 255, 223, 127, 127, 127, 127, 127, 127, 63, 0, 0, 0, 0, 0,
    0, 0, 3, 247, 255, 255, 195, 7, 3, 11, 7, 0, 0, 0, 0, 0, 0, 0, 127, 255,
    255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 195, 255, 255, 255, 255, 255, 255,
    223, 0, 0, 0, 0, 0, 127, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 127, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 123, 255, 255, 255, 255, 255, 155, 23,
    0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 95, 0, 0, 0, 0, 75, 255, 255,
    255, 31, 0, 0, 0, 0, 0, 127, 255, 255, 255, 255, 75, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 127, 255, 255, 255, 255, 255, 255, 255, 255, 255, 139, 0, 0, 0, 0, 0, 0, 31,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 123,
    255, 255, 255, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 143, 255, 255, 255, 255, 255, 223, 0, 0, 0,
    0, 0, 127, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 95, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 127, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 55, 215, 255, 255, 255, 255, 255, 99, 7, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 251, 255, 255, 123, 0, 0, 0, 0, 107, 255, 255, 255, 15, 0, 0,
    0, 0, 0, 7, 107, 255, 255, 255, 255, 255, 143, 23, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 255, 255, 255, 151, 63, 63, 63, 91, 255, 255, 255, 43, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 111,
    255, 255, 255, 255, 255, 255, 255, 75, 0, 0, 0, 0, 0, 0, 0, 23, 215, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 107, 255, 255, 255,
    255, 255, 43, 0, 0, 0, 0, 0, 0, 0, 111, 255, 255, 223, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 91, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 127, 255,
    255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 95, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 127, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 223, 255, 255, 255, 231, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 195, 255, 255, 195, 0, 0, 0, 0, 179, 255, 255, 211, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 59, 235, 255, 255, 255, 255, 243, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203,
    255, 255, 155, 0, 0, 0, 75, 255, 255, 255, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 31, 255, 255, 255, 95, 0, 0, 0, 0, 0, 163, 255, 255, 255, 31, 0, 0, 0,
    0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0, 95, 255, 255, 255, 31, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 47, 235, 255, 255, 167, 0, 0, 0, 0, 0, 95, 255, 255, 239, 47, 0,
    0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 127, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 255, 163,
    27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 255, 255,
    255, 99, 0, 0, 87, 255, 255, 255, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    31, 171, 255, 255, 255, 255, 255, 135, 19, 0, 0, 0, 0, 0, 0, 111, 255, 255, 255, 47,
    0, 3, 191, 255, 255, 183, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255,
    255, 255, 95, 0, 0, 0, 0, 55, 255, 255, 255, 255, 31, 0, 0, 0, 0, 0, 31, 255,
    255, 255, 127, 0, 0, 0, 0, 0, 95, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 59, 155, 191, 131, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 143,
    143, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 255, 255, 255, 255, 255,
    255, 255, 255, 175, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 111,
    255, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 3, 199, 255, 255, 255, 255, 255, 255, 255,
    255, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 95, 0,
    0, 0, 0, 199, 255, 255, 255, 255, 31, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0,
    0, 0, 0, 0, 95, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 111, 255, 255, 255, 255, 255, 255, 127, 3,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 251, 255,
    127, 0, 0, 0, 0, 0, 0, 0, 11, 151, 255, 255, 255, 255, 255, 255, 55, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 95, 0, 0, 0, 91, 255,
    255, 255, 255, 255, 31, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0,
    95, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255,
    255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 255, 255, 255, 255, 255, 175, 43,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 127, 255,
    255, 255, 123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 63, 63, 27, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3, 35, 67, 55, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 95, 0, 0, 7, 235, 255, 255, 255, 255, 255,
    31, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0, 95, 255, 255, 255,
    31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 191, 0, 0,
    0, 0, 0, 0, 0, 0, 223, 255, 255, 255, 255, 255, 255, 255, 255, 255, 171, 11, 0, 0,
    0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 71, 255, 255, 255, 167, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 191, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 31, 255, 255, 255, 95, 0, 0, 127, 255, 255, 255, 255, 255, 255, 31, 0, 0, 0,
    0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0, 95, 255, 255, 255, 31, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 191, 0, 0, 0, 0, 0, 0,
    0, 0, 223, 255, 255, 203, 63, 71, 131, 255, 255, 255, 255, 207, 11, 0, 0, 0, 0, 0,
    0, 31, 255, 255, 255, 127, 0, 0, 35, 255, 255, 255, 219, 11, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 191, 0, 0, 0, 0, 0, 223, 255, 255,
    255, 255, 255, 255, 255, 255, 107, 7, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0,
    0, 0, 0, 7, 247, 255, 255, 167, 0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255,
    255, 255, 95, 0, 27, 255, 255, 255, 171, 255, 255, 255, 31, 0, 0, 0, 0, 0, 31, 255,
    255, 255, 127, 0, 0, 0, 0, 0, 95, 255, 255, 255, 31, 0, 0, 0, 0, 0, 47, 143,
    191, 191, 191, 191, 191, 191, 255, 255, 255, 255, 191, 131, 35, 0, 0, 0, 0, 0, 223, 255,
    255, 159, 0, 0, 0, 0, 91, 255, 255, 255, 147, 0, 0, 0, 0, 0, 0, 31, 255, 255,
    255, 127, 0, 11, 223, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 255, 255, 255, 255,
    71, 63, 63, 63, 63, 63, 55, 23, 0, 0, 0, 0, 0, 223, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 39, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 91,
    255, 255, 255, 63, 0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 95, 0,
    167, 255, 255, 187, 95, 255, 255, 255, 31, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0,
    0, 0, 0, 0, 95, 255, 255, 255, 31, 0, 0, 0, 0, 0, 127, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 95, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0,
    0, 0, 0, 147, 255, 255, 255, 23, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 171,
    255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255,
    159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 255, 139, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 15, 63, 195, 255, 255, 255,
    203, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 191, 255, 255, 215, 0,
    0, 0, 0, 0, 0, 31, 255, 255, 255, 203, 63, 63, 63, 63, 63, 63, 39, 7, 0, 0,
    0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 219, 255, 255, 195, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 31, 255, 255, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 95, 59, 255, 255, 255, 43,
    95, 255, 255, 255, 31, 0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 31, 0, 0, 0, 0, 0, 115, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 71, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 27,
    255, 255, 255, 99, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 119, 255, 255, 255, 99, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 255, 255, 255, 47, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 127, 255, 255, 255, 55, 0, 0,
    0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 31, 255, 255, 255, 115, 0, 0, 0, 0, 0,
    0, 31, 255, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223,
    255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131,
    255, 255, 255, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255,
    255, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 127, 0, 0,
    0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 95, 203, 255, 255, 151, 0, 95, 255, 255, 255,
    31, 0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    31, 0, 0, 0, 0, 0, 11, 235, 255, 255, 147, 0, 0, 0, 191, 255, 255, 191, 0, 0,
    0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 211, 255, 255, 151,
    0, 0, 0, 0, 0, 31, 255, 255, 255, 195, 255, 255, 255, 151, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 31, 255, 255, 255, 207, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 223, 255, 255, 159, 0, 0, 0, 0, 39, 255, 255, 255, 95, 0, 0, 0, 0, 0, 223,
    255, 255, 159, 0, 0, 0, 135, 255, 255, 255, 19, 0, 0, 0, 0, 0, 0, 31, 255, 255,
    255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 255, 255, 255, 99,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 191, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0,
    0, 0, 31, 255, 255, 255, 191, 255, 255, 255, 19, 0, 95, 255, 255, 255, 31, 0, 0, 0,
    0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0, 95, 255, 255, 255, 31, 0, 0, 0,
    0, 0, 0, 59, 255, 255, 255, 71, 0, 0, 191, 255, 255, 191, 0, 0, 0, 0, 0, 0,
    0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 179, 255, 255, 187, 0, 0, 0, 0,
    0, 31, 255, 255, 255, 255, 255, 255, 195, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 115, 255, 255, 255, 115, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255,
    159, 0, 0, 0, 0, 35, 255, 255, 255, 87, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0,
    0, 7, 239, 255, 255, 167, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 159, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 255, 255, 187, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 63, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255,
    255, 255, 255, 255, 255, 115, 0, 0, 95, 255, 255, 255, 31, 0, 0, 0, 0, 0, 31, 255,
    255, 255, 127, 0, 0, 0, 0, 0, 95, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0,
    135, 255, 255, 243, 15, 0, 191, 255, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255,
    255, 159, 0, 0, 0, 0, 0, 0, 159, 255, 255, 191, 0, 0, 0, 0, 0, 31, 255, 255,
    255, 255, 255, 255, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 203,
    255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0,
    0, 115, 255, 255, 255, 27, 0, 0, 0, 0, 0, 223, 255, 255, 203, 63, 87, 231, 255, 255,
    255, 39, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 159, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 103, 255, 255, 255, 27, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 31, 63, 51, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 255,
    223, 3, 0, 0, 95, 255, 255, 255, 31, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0,
    0, 0, 0, 0, 95, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 3, 211, 255, 255,
    171, 0, 191, 255, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0,
    0, 0, 0, 0, 175, 255, 255, 191, 0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 255, 255,
    103, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255,
    159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 255, 255, 255, 191,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 19, 55, 111, 235, 255, 255, 255,
    107, 0, 0, 0, 0, 0, 0, 223, 255, 255, 255, 255, 255, 255, 255, 255, 107, 0, 0, 0,
    0, 0, 0, 0, 0, 31, 255, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 11, 255, 255, 255, 119, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 239, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 63,
    39, 7, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 255, 75, 0, 0, 0,
    95, 255, 255, 255, 31, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0,
    95, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 43, 255, 255, 255, 91, 191, 255,
    255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0,
    215, 255, 255, 155, 0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 255, 255, 255, 71, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135, 255, 255, 255, 95, 0, 0, 0,
    0, 0, 0, 0, 0, 223, 255, 255, 255, 255, 255, 255, 255, 255, 255, 71, 0, 0, 0, 0,
    0, 0, 0, 223, 255, 255, 255, 255, 255, 255, 255, 255, 255, 147, 3, 0, 0, 0, 0, 0,
    0, 31, 255, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223,
    255, 255, 255, 255, 255, 255, 255, 147, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 147, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187,
    255, 255, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 255, 255, 255, 63, 0, 0,
    0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 187, 0, 0, 0, 0, 95, 255, 255, 255,
    31, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0, 95, 255, 255, 255,
    31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 115, 255, 255, 255, 219, 255, 255, 191, 0, 0,
    0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 35, 255, 255, 255, 103,
    0, 0, 0, 0, 0, 31, 255, 255, 255, 131, 191, 255, 255, 255, 43, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 7, 223, 255, 255, 255, 23, 0, 0, 0, 0, 0, 0,
    0, 223, 255, 255, 255, 255, 255, 255, 255, 255, 127, 7, 0, 0, 0, 0, 0, 0, 0, 223,
    255, 255, 159, 0, 0, 39, 179, 255, 255, 255, 143, 0, 0, 0, 0, 0, 0, 31, 255, 255,
    255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 179, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 255, 255,
    255, 75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87, 255, 255, 255, 119,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 79, 0, 0, 0, 0, 0, 0,
    0, 0, 31, 255, 255, 255, 255, 43, 0, 0, 0, 0, 95, 255, 255, 255, 31, 0, 0, 0,
    0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 0, 0, 95, 255, 255, 255, 31, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 255, 255, 255, 191, 0, 0, 0, 0, 0, 0,
    0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 171, 255, 255, 255, 19, 0, 0, 0, 0,
    0, 31, 255, 255, 255, 127, 15, 231, 255, 255, 251, 23, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 63, 255, 255, 255, 171, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255,
    159, 0, 11, 75, 251, 255, 255, 203, 7, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0,
    0, 0, 0, 131, 255, 255, 255, 27, 0, 0, 0, 0, 0, 31, 255, 255, 255, 159, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 247, 127, 143, 191, 255, 255,
    255, 255, 179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 255, 255, 191, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 255, 255, 255, 147, 3, 0, 0,
    0, 0, 0, 0, 0, 31, 255, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 23, 215,
    255, 255, 127, 0, 0, 0, 0, 0, 71, 255, 255, 215, 23, 0, 0, 0, 0, 0, 23, 215,
    255, 255, 95, 0, 0, 0, 0, 0, 71, 255, 255, 215, 23, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 27, 255, 255, 255, 255, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255,
    255, 159, 0, 0, 0, 7, 159, 255, 255, 255, 131, 0, 0, 0, 0, 0, 0, 31, 255, 255,
    255, 127, 0, 39, 255, 255, 255, 215, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 151, 255, 255, 255, 79, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0,
    3, 227, 255, 255, 119, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 39,
    255, 255, 255, 83, 0, 0, 0, 0, 0, 31, 255, 255, 255, 159, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 151, 255, 255, 255, 55,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 255, 255, 255, 47, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 255, 255, 255, 243, 35, 0, 0, 0, 0, 0,
    0, 31, 255, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    91, 255, 255, 255, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 247, 131, 167,
    247, 255, 255, 255, 255, 175, 3, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0,
    67, 255, 255, 255, 179, 3, 0, 0, 0, 0, 0, 0, 59, 155, 191, 191, 191, 255, 255, 255,
    255, 191, 191, 191, 131, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 243,
    255, 255, 243, 15, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 171, 255, 255,
    179, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 35, 255, 255, 255, 95,
    0, 0, 0, 0, 0, 31, 255, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 15, 255, 255, 255, 119, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 175, 255, 255, 175, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 51, 255, 255, 255, 255, 35, 0, 0, 0, 0, 0, 31, 255, 255,
    255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 171, 255, 255,
    255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    119, 3, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0, 0, 103, 255, 255,
    255, 139, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 95, 0, 0, 0, 0, 0, 15, 79, 127, 127, 127, 127, 127, 127, 203, 255, 255, 255, 147,
    0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 11, 239, 255, 255, 159, 0, 0, 0,
    0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 131, 255, 255, 255, 63, 0, 0, 0, 0,
    0, 31, 255, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223,
    255, 255, 159, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 47, 255, 255, 255, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 43, 255, 255, 255, 171, 0, 0, 0, 0, 0, 55, 255, 255, 255, 103, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 203, 255, 255, 143, 0, 0,
    0, 0, 0, 0, 0, 0, 167, 255, 255, 255, 255, 255, 255, 231, 95, 7, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 23, 215, 255, 255, 95, 0, 0, 0, 0, 131, 255, 255, 251, 59, 0,
    0, 0, 0, 0, 119, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 71, 0, 0,
    0, 0, 0, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 191, 0, 0, 0, 0,
    0, 223, 255, 255, 247, 127, 131, 175, 255, 255, 255, 255, 79, 0, 0, 0, 0, 0, 0, 223,
    255, 255, 247, 127, 127, 167, 255, 255, 255, 255, 211, 3, 0, 0, 0, 0, 0, 31, 255, 255,
    255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0,
    0, 0, 0, 7, 251, 255, 255, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    159, 255, 255, 195, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    183, 255, 255, 239, 0, 0, 0, 0, 0, 63, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 15, 63, 111, 115, 67, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 23, 83, 123, 99, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47,
    239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 143, 0, 0, 0, 0, 0, 223, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 131, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 223, 23, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 159, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 119,
    255, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 255, 255,
    87, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 255, 255, 243,
    0, 0, 0, 0, 0, 63, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 87, 255,
    255, 255, 255, 255, 255, 255, 255, 83, 0, 0, 0, 0, 0, 0, 0, 15, 155, 255, 255, 255,
    255, 255, 255, 255, 151, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 255, 255, 255, 255, 255, 255,
    255, 147, 31, 0, 0, 0, 0, 0, 0, 0, 0, 167, 255, 255, 255, 255, 255, 255, 255, 191,
    59, 0, 0, 0, 0, 0, 0, 0, 0, 23, 215, 255, 255, 119, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 247, 127, 127, 163, 255, 255, 255, 255, 231, 7,
    0, 0, 0, 0, 0, 63, 127, 127, 127, 127, 127, 127, 127, 231, 255, 255, 235, 7, 0, 0,
    0, 0, 0, 31, 235, 255, 215, 123, 75, 63, 91, 227, 255, 255, 255, 175, 0, 0, 0, 0,
    0, 63, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 139, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 199, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 223, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 39, 0, 0, 0, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 31, 0, 0, 0, 0, 0, 31,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 31, 0, 0, 0, 0, 0, 75, 255, 255,
    255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 123, 239, 147, 31, 0, 0, 51, 255, 255, 255,
    255, 67, 0, 0, 0, 0, 0, 63, 255, 255, 75, 3, 0, 23, 199, 255, 255, 255, 91, 0,
    0, 0, 0, 0, 0, 0, 3, 39, 99, 127, 99, 35, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 11, 71, 111, 59, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 35, 255, 255, 255, 63, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0,
    0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167,
    255, 255, 255, 255, 255, 255, 255, 211, 71, 3, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 215, 23, 0, 0, 0, 0, 0, 11, 131, 255, 255, 255,
    255, 255, 255, 255, 255, 139, 15, 0, 0, 0, 0, 0, 0, 95, 255, 255, 255, 155, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 255, 255, 255, 171, 0, 0,
    0, 0, 0, 11, 11, 0, 0, 0, 0, 0, 7, 251, 255, 255, 155, 0, 0, 0, 0, 0,
    19, 211, 255, 255, 255, 255, 255, 255, 255, 139, 7, 0, 0, 0, 0, 0, 0, 0, 3, 147,
    255, 255, 255, 255, 255, 227, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 143, 255, 255, 215, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0,
    127, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 135, 255, 255, 255, 199, 0, 0, 0,
    87, 255, 255, 255, 239, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 255, 255, 255, 119, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 255, 255, 223, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 187, 0, 0, 0, 0, 0, 31, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 183, 0, 0, 0, 0, 0, 0, 0, 163, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 255, 255, 255,
    103, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 127, 255, 255, 255,
    0, 0, 0, 0, 0, 0, 0, 0, 187, 255, 255, 255, 243, 0, 0, 0, 139, 255, 255, 255,
    255, 43, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 175, 0, 0, 15, 255, 255, 255,
    239, 0, 0, 0, 211, 255, 255, 175, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 159, 255, 255, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 15, 255, 255, 255, 151, 0, 0, 0, 0, 0, 23, 159, 191, 59, 3, 0, 35, 251,
    255, 255, 255, 75, 0, 0, 0, 0, 0, 71, 255, 255, 255, 103, 0, 0, 115, 255, 255, 255,
    223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 255, 255, 239, 7, 0, 0, 0,
    0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 0, 0, 243, 255, 255, 255, 255, 35, 0, 0, 179, 255, 255, 255, 255, 95, 0, 0,
    0, 0, 0, 0, 0, 0, 159, 255, 255, 199, 0, 0, 79, 255, 255, 255, 255, 39, 0, 0,
    235, 255, 255, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 167, 255, 255, 227, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 219, 255,
    255, 255, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 255, 255, 255, 147,
    0, 0, 0, 0, 0, 167, 255, 255, 199, 0, 0, 0, 0, 187, 255, 255, 223, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 3, 235, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 127,
    255, 255, 255, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 43,
    255, 255, 255, 255, 255, 79, 0, 0, 227, 255, 255, 255, 255, 147, 0, 0, 0, 0, 0, 0,
    0, 0, 127, 255, 255, 223, 0, 0, 135, 255, 255, 255, 255, 99, 0, 3, 255, 255, 255, 119,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 255, 91, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 39, 255, 255, 255, 111, 0, 0, 0, 0, 0, 0, 3, 239,
    255, 255, 191, 0, 0, 0, 0, 0, 0, 47, 255, 255, 255, 31, 27, 255, 255, 255, 47, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 95, 107, 43, 0, 0, 0, 11, 247, 255,
    255, 183, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 211, 255, 255, 255, 255, 163, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 251, 255, 255, 191, 0, 0, 0, 0,
    0, 219, 255, 255, 139, 0, 0, 0, 0, 159, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 91, 255, 255, 255, 23, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0,
    0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 255, 255,
    255, 123, 0, 15, 255, 255, 255, 255, 255, 203, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255,
    255, 251, 0, 0, 195, 255, 255, 255, 255, 159, 0, 31, 255, 255, 255, 87, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 27, 255, 255, 255, 255, 175, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 207, 255, 255, 187, 0, 0, 0, 0, 0, 0, 59, 255, 255, 255, 99, 0,
    0, 0, 0, 0, 0, 3, 255, 255, 255, 75, 0, 239, 255, 255, 87, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 123, 255, 255, 255, 95, 0, 0, 0, 0, 35, 255, 255, 255, 215, 3, 0,
    0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 231, 107, 119, 255, 255, 255, 255, 75, 0, 0,
    0, 0, 0, 0, 0, 55, 251, 255, 255, 255, 255, 255, 115, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 191, 0, 0, 0, 0, 0, 255, 255, 255,
    107, 0, 0, 0, 0, 159, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207,
    255, 255, 155, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0,
    127, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 147, 255, 255, 247, 255, 255, 171, 0, 63,
    255, 255, 247, 255, 255, 255, 7, 0, 0, 0, 0, 0, 0, 0, 67, 255, 255, 255, 19, 7,
    255, 255, 255, 255, 255, 215, 0, 55, 255, 255, 255, 59, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 159, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 111, 255, 255, 255, 255, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    123, 255, 255, 255, 11, 0, 0, 0, 0, 0, 135, 255, 255, 255, 19, 0, 0, 0, 0, 0,
    0, 0, 207, 255, 255, 119, 0, 195, 255, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    7, 231, 255, 255, 223, 3, 0, 0, 0, 159, 255, 255, 255, 67, 0, 0, 0, 0, 0, 0,
    0, 0, 107, 255, 255, 255, 255, 255, 255, 255, 255, 255, 139, 0, 0, 0, 0, 0, 0, 0,
    83, 255, 255, 255, 255, 255, 131, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 223, 255, 255, 191, 0, 0, 0, 0, 0, 255, 255, 255, 107, 0, 0, 0,
    0, 159, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 255, 255, 255, 43, 0,
    0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 127, 255, 255, 255,
    0, 0, 0, 0, 0, 0, 0, 207, 255, 255, 159, 255, 255, 211, 0, 107, 255, 255, 179, 235,
    255, 255, 55, 0, 0, 0, 0, 0, 0, 0, 39, 255, 255, 255, 39, 55, 255, 255, 207, 215,
    255, 255, 19, 79, 255, 255, 255, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195,
    255, 255, 255, 255, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 255, 255, 255,
    91, 0, 0, 0, 0, 0, 219, 255, 255, 187, 0, 0, 0, 0, 0, 0, 0, 0, 167, 255,
    255, 167, 0, 147, 255, 255, 179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87, 255, 255,
    255, 95, 0, 0, 35, 255, 255, 255, 183, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255,
    255, 255, 255, 255, 255, 255, 223, 63, 0, 0, 0, 0, 0, 0, 0, 35, 255, 255, 255, 255,
    63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    223, 255, 255, 191, 0, 0, 0, 0, 0, 219, 255, 255, 139, 0, 0, 0, 0, 159, 255, 255,
    223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 179, 255, 255, 179, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0,
    0, 0, 7, 255, 255, 255, 71, 255, 255, 255, 7, 151, 255, 255, 139, 187, 255, 255, 111, 0,
    0, 0, 0, 0, 0, 0, 11, 255, 255, 255, 63, 115, 255, 255, 143, 159, 255, 255, 79, 99,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 255, 255, 255, 183, 255,
    255, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 99, 0, 0, 0, 0, 0, 0, 195, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 111, 0, 0, 0, 0, 0, 0, 0, 0, 195, 255, 255, 239, 7, 0,
    159, 255, 255, 255, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 255, 255, 255, 31, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 39, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 191,
    0, 0, 0, 0, 0, 171, 255, 255, 199, 0, 0, 0, 0, 195, 255, 255, 223, 0, 0, 0,
    0, 0, 0, 0, 0, 39, 255, 255, 255, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127,
    255, 255, 255, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 0, 55, 255,
    255, 255, 15, 211, 255, 255, 51, 203, 255, 255, 87, 143, 255, 255, 163, 0, 0, 0, 0, 0,
    0, 0, 0, 235, 255, 255, 95, 175, 255, 255, 87, 95, 255, 255, 139, 127, 255, 255, 223, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 255, 255, 255, 255, 91, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 255, 255, 227, 55, 255, 255, 255, 19, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 15, 0, 0, 0, 0, 0, 0, 223, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 55, 255, 255, 255, 111, 47, 255, 255, 255, 147,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 31, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 191, 0, 0, 0, 0,
    0, 79, 255, 255, 255, 99, 0, 0, 119, 255, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0,
    0, 155, 255, 255, 207, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0,
    0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 0, 111, 255, 255, 231, 0, 171,
    255, 255, 95, 243, 255, 255, 43, 95, 255, 255, 219, 0, 0, 0, 0, 0, 0, 0, 0, 207,
    255, 255, 119, 235, 255, 255, 23, 39, 255, 255, 199, 155, 255, 255, 195, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 147, 255, 255, 255, 255, 235, 7, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 207, 255, 255, 147, 0, 227, 255, 255, 99, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 27, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 175, 0, 0, 0,
    0, 0, 0, 0, 27, 59, 87, 255, 255, 255, 107, 75, 255, 255, 255, 119, 47, 15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 163, 255, 255, 239, 183, 255, 255, 255, 15, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 147, 255, 255, 251, 7, 0, 0, 0, 0, 15, 15, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 191, 0, 0, 0, 0, 0, 0, 175, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 23, 255, 255, 255,
    95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0,
    127, 255, 255, 255, 0, 0, 0, 0, 0, 0, 167, 255, 255, 179, 0, 119, 255, 255, 179, 255,
    255, 255, 3, 51, 255, 255, 255, 15, 0, 0, 0, 0, 0, 0, 0, 175, 255, 255, 179, 255,
    255, 219, 0, 0, 231, 255, 255, 183, 255, 255, 163, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 39, 255, 255, 255, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 35, 255, 255, 255, 67, 0, 151, 255, 255, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 195, 255, 255, 151, 0, 0, 23, 255, 255, 255, 91, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 239, 255, 255, 95, 0, 223, 255, 255, 107, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 27, 255, 255, 255, 255, 255, 255, 115, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 43, 255, 255, 255, 175, 127, 127, 127, 127, 127, 79, 15, 0, 0, 0, 0, 0, 75,
    255, 255, 255, 207, 31, 15, 79, 211, 255, 239, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 223, 255, 255, 191, 0, 0, 0, 0, 0, 0, 7, 147, 255, 255, 255, 255,
    255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 235, 3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 219, 255, 255, 139, 0, 79, 255, 255, 255, 255, 255, 207, 0, 7,
    255, 255, 255, 75, 0, 0, 0, 0, 0, 0, 0, 147, 255, 255, 255, 255, 255, 159, 0, 0,
    175, 255, 255, 255, 255, 255, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183, 255, 255,
    231, 119, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 255, 255,
    243, 3, 0, 67, 255, 255, 255, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 107, 255,
    255, 227, 0, 0, 99, 255, 255, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195,
    255, 255, 139, 0, 175, 255, 255, 151, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    127, 255, 255, 255, 255, 223, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 167, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    223, 255, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 7, 43, 67, 31, 0, 159, 255, 255,
    223, 0, 0, 0, 0, 0, 0, 7, 239, 255, 255, 119, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 15, 255, 255, 255, 87, 0, 31, 255, 255, 255, 255, 255, 167, 0, 0, 211, 255, 255, 123,
    0, 0, 0, 0, 0, 0, 0, 119, 255, 255, 255, 255, 255, 99, 0, 0, 111, 255, 255, 255,
    255, 255, 103, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 255, 255, 255, 95, 7, 239, 255,
    255, 167, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 255, 255, 163, 0, 0, 7,
    251, 255, 255, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 255, 255, 255, 51, 0,
    179, 255, 255, 175, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 255, 255, 183, 0,
    131, 255, 255, 203, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 255, 255, 255,
    255, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 215, 255, 255, 255, 255,
    255, 255, 255, 255, 239, 47, 0, 0, 0, 0, 0, 0, 3, 111, 255, 255, 255, 255, 255, 255,
    227, 75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 191,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 223, 0, 0, 0,
    0, 0, 0, 103, 255, 255, 255, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127,
    255, 255, 255, 0, 0, 0, 0, 0, 31, 95, 127, 63, 0, 0, 0, 0, 0, 75, 255, 255,
    255, 47, 0, 0, 239, 255, 255, 255, 255, 115, 0, 0, 171, 255, 255, 179, 0, 0, 0, 0,
    0, 0, 0, 87, 255, 255, 255, 255, 255, 39, 0, 0, 47, 255, 255, 255, 255, 255, 75, 0,
    0, 0, 0, 0, 0, 0, 0, 3, 219, 255, 255, 223, 3, 0, 107, 255, 255, 255, 59, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 47, 255, 255, 255, 87, 0, 0, 0, 163, 255, 255, 195,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 255, 255, 131, 7, 255, 255, 255, 79,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 255, 255, 235, 0, 83, 255, 255, 243,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 255, 255, 255, 255, 219, 3, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 191, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 223, 0, 0, 0, 0, 0, 0, 215,
    255, 255, 143, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0,
    0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0, 127, 255, 255, 255, 3, 0, 0,
    199, 255, 255, 255, 255, 75, 0, 0, 123, 255, 255, 235, 0, 0, 0, 0, 0, 0, 0, 59,
    255, 255, 255, 255, 235, 0, 0, 0, 3, 247, 255, 255, 255, 255, 47, 0, 0, 0, 0, 0,
    0, 0, 0, 111, 255, 255, 255, 95, 0, 0, 3, 223, 255, 255, 203, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 131, 255, 255, 255, 11, 0, 0, 0, 91, 255, 255, 255, 27, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 99, 255, 255, 207, 79, 255, 255, 251, 7, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 167, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 167, 0,
    0, 0, 0, 0, 0, 0, 0, 23, 255, 255, 255, 255, 255, 255, 107, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 159, 255, 255, 223, 0, 0, 0, 0, 0, 75, 255, 255, 255, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 0, 0, 0, 0, 0,
    127, 255, 255, 255, 0, 0, 0, 0, 0, 179, 255, 255, 211, 0, 0, 0, 147, 255, 255, 255,
    255, 23, 0, 0, 79, 255, 255, 255, 35, 0, 0, 0, 0, 0, 0, 27, 255, 255, 255, 255,
    175, 0, 0, 0, 0, 183, 255, 255, 255, 255, 15, 0, 0, 0, 0, 0, 0, 0, 19, 255,
    255, 255, 207, 0, 0, 0, 0, 95, 255, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0,
    219, 255, 255, 183, 0, 0, 0, 0, 11, 255, 255, 255, 111, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 19, 255, 255, 255, 187, 255, 255, 163, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 191, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 191, 0, 0, 0, 0, 0,
    0, 0, 0, 159, 255, 255, 255, 175, 255, 255, 255, 15, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 167, 255, 255, 143, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 119, 255, 255, 167, 0, 0, 0, 0, 0, 131, 255, 255, 143, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 31, 95, 127, 63, 0, 0, 0, 0, 0, 31, 95, 127, 63,
    0, 0, 0, 0, 0, 171, 255, 255, 127, 0, 0, 0, 83, 255, 255, 255, 183, 0, 0, 0,
    27, 219, 255, 251, 59, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 111, 0, 0, 0,
    0, 127, 255, 255, 255, 243, 0, 0, 0, 0, 0, 0, 0, 0, 151, 255, 255, 255, 79, 0,
    0, 0, 0, 3, 219, 255, 255, 247, 15, 0, 0, 0, 0, 0, 0, 47, 255, 255, 255, 99,
    0, 0, 0, 0, 0, 187, 255, 255, 203, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    179, 255, 255, 255, 255, 255, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 55, 63,
    251, 255, 255, 167, 63, 239, 255, 255, 183, 55, 23, 0, 0, 0, 0, 0, 0, 0, 51, 255,
    255, 255, 127, 23, 255, 255, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 39, 99, 123, 83, 23, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 167, 255, 255, 239, 47, 0, 0, 0, 0, 55, 247, 255,
    255, 163, 0, 0, 0, 0, 0, 0, 0, 23, 211, 255, 255, 167, 0, 0, 0, 0, 0, 0,
    71, 255, 255, 255, 91, 0, 0, 0, 0, 0, 0, 139, 255, 255, 255, 23, 0, 0, 0, 0,
    0, 99, 255, 255, 255, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 255, 255, 255,
    255, 243, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 171, 255, 255, 159,
    0, 159, 255, 255, 175, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 255, 255, 255, 15, 0,
    143, 255, 255, 255, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 175, 255, 255, 255,
    255, 255, 255, 255, 119, 7, 111, 255, 255, 255, 143, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 227, 255, 255, 195, 0, 0, 0, 0, 0, 0, 27, 255, 255,
    255, 123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 255, 255, 255, 255, 155, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 207, 0, 111, 255, 255,
    219, 0, 0, 0, 0, 0, 0, 0, 0, 87, 255, 255, 255, 127, 0, 0, 19, 255, 255, 255,
    179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 219, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 39, 231, 255, 255, 99, 0, 0, 0, 0, 0, 0, 0, 155, 255, 255, 147, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 139, 255, 255, 251, 59, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 183, 0, 55, 247, 255, 195, 3, 0, 0,
    0, 0, 0, 0, 7, 227, 255, 255, 239, 7, 0, 0, 0, 127, 255, 255, 255, 67, 0, 0,
    0, 0, 0, 0, 0, 0, 95, 255, 255, 255, 151, 3, 0, 0, 75, 255, 255, 255, 255, 255,
    175, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 63, 115, 107, 47,
    3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 91,
    127, 99, 39, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 51,
    107, 123, 91, 35, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 67, 115, 111, 59,
    11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 47, 107, 115, 67, 15,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    75, 255, 255, 255, 95, 0, 0, 0, 0, 15, 203, 255, 255, 147, 0, 0, 0, 0, 0, 0,
    0, 0, 143, 255, 255, 255, 7, 0, 0, 0, 0, 103, 255, 255, 255, 247, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 255, 255, 255, 255, 255, 255, 255, 203, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 159, 255, 255, 255, 255, 255, 255, 255,
    255, 135, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 219, 255, 255, 255, 255, 255, 255,
    255, 131, 0, 0, 0, 0, 0, 0, 0, 91, 255, 255, 255, 255, 255, 255, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 19, 175, 255, 255, 255, 255, 255, 255, 255, 63, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 27, 87, 123, 103, 39, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 7, 55, 111, 107, 47, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131, 255,
    255, 255, 11, 0, 0, 0, 83, 255, 255, 255, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 135, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 83, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 59, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 111, 255, 255, 255, 255, 255, 255, 255, 255, 255, 159, 0, 0,
    0, 0, 0, 0, 143, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 111, 0, 0, 0, 0,
    0, 0, 0, 23, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 79, 0, 0, 0, 0, 0,
    0, 0, 23, 255, 255, 255, 255, 255, 255, 255, 163, 19, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 19, 179, 255, 255, 255, 255, 255, 255, 151, 11, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 255, 255, 255, 131, 0,
    0, 83, 255, 255, 255, 255, 255, 255, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 115,
    255, 255, 255, 231, 43, 0, 0, 75, 255, 255, 255, 255, 51, 0, 0, 0, 0, 0, 0, 0,
    0, 55, 255, 255, 255, 255, 115, 11, 0, 0, 51, 255, 255, 255, 63, 0, 0, 0, 0, 0,
    0, 0, 99, 255, 255, 255, 255, 103, 7, 0, 0, 35, 91, 55, 0, 0, 0, 0, 0, 75,
    255, 255, 255, 199, 23, 0, 0, 35, 235, 255, 255, 255, 47, 0, 0, 0, 0, 0, 0, 159,
    255, 255, 255, 139, 11, 0, 55, 255, 255, 255, 255, 15, 0, 0, 0, 0, 0, 0, 31, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 35, 0, 0, 0, 0, 0, 0, 0, 0, 23, 239, 255,
    255, 255, 255, 255, 255, 255, 255, 203, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
    47, 107, 111, 55, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 71, 115,
    111, 59, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 103, 83, 19, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135, 255, 255, 255, 127, 83, 255, 255, 255,
    207, 79, 255, 255, 255, 39, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 255, 255, 195, 3,
    0, 0, 0, 0, 23, 255, 255, 255, 207, 0, 0, 0, 0, 0, 0, 0, 7, 231, 255, 255,
    255, 39, 0, 0, 0, 0, 31, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 23, 255, 255,
    255, 255, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 255, 255, 227, 3,
    0, 0, 0, 0, 27, 255, 255, 255, 135, 0, 0, 0, 0, 0, 11, 255, 255, 255, 175, 0,
    0, 0, 0, 59, 255, 255, 255, 95, 0, 0, 0, 0, 0, 0, 11, 67, 59, 3, 0, 7,
    107, 255, 255, 255, 211, 3, 0, 0, 0, 0, 0, 0, 0, 167, 255, 255, 255, 99, 0, 3,
    127, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 11, 155, 255, 255, 255, 255, 255,
    255, 195, 31, 0, 0, 0, 0, 0, 0, 0, 27, 167, 255, 255, 255, 255, 255, 255, 255, 255,
    63, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 255, 59, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 83, 111, 47, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 11, 227, 255, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 139, 255, 255, 255, 255, 255, 255, 207, 11, 7, 255, 255,
    255, 103, 0, 0, 0, 0, 0, 0, 0, 0, 131, 255, 255, 255, 39, 0, 0, 0, 0, 0,
    0, 103, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 103, 255, 255, 255, 95, 0, 0, 0,
    0, 0, 31, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 123, 255, 255, 255, 79, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 159, 0, 0, 0, 0, 0,
    0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 51, 255, 255, 255, 103, 0, 0, 0, 0, 0,
    235, 255, 255, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 255, 255,
    255, 95, 0, 0, 0, 0, 0, 0, 27, 255, 255, 255, 147, 0, 0, 0, 0, 179, 255, 255,
    247, 7, 0, 0, 0, 0, 0, 0, 11, 227, 255, 255, 255, 255, 255, 255, 255, 255, 255, 47,
    0, 0, 0, 0, 0, 0, 95, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 103, 0, 0,
    0, 0, 0, 0, 99, 255, 255, 255, 255, 255, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 211, 255, 255, 255, 255, 255, 75, 0, 0, 0, 0, 0, 0, 0,
    0, 147, 255, 255, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 95, 255, 255, 255, 255, 247, 15, 0, 0, 111, 239, 195, 67, 0, 0,
    0, 0, 0, 0, 0, 0, 207, 255, 255, 207, 0, 0, 0, 0, 0, 0, 0, 19, 255, 255,
    255, 135, 0, 0, 0, 0, 0, 0, 191, 255, 255, 231, 3, 0, 0, 0, 0, 0, 31, 255,
    255, 255, 63, 0, 0, 0, 0, 0, 0, 199, 255, 255, 227, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 167, 255, 255, 199, 0, 0, 0, 0, 0, 7, 251, 255, 255,
    143, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 223, 255, 255, 159,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 195, 0, 0,
    0, 0, 0, 0, 103, 255, 255, 255, 39, 0, 0, 0, 0, 83, 255, 255, 255, 63, 0, 0,
    0, 0, 0, 0, 143, 255, 255, 255, 135, 7, 0, 83, 255, 255, 255, 219, 3, 0, 0, 0,
    0, 0, 91, 255, 239, 83, 11, 0, 0, 67, 255, 255, 255, 255, 31, 0, 0, 0, 0, 0,
    0, 0, 3, 151, 255, 255, 235, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 75, 0, 0, 0, 0, 0, 0, 0, 35, 255, 255,
    255, 75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 59, 255, 255, 255, 255, 255, 219, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 251, 255, 255, 151, 0, 0, 0, 0, 0, 0, 0, 0, 219, 255, 255, 183, 0, 0,
    0, 0, 0, 0, 243, 255, 255, 167, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 247, 255, 255, 163, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 59, 255, 255, 255, 111, 0, 0, 0, 3, 151, 255, 255, 255, 67, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0,
    0, 0, 0, 0, 31, 127, 223, 243, 187, 75, 119, 255, 255, 255, 7, 0, 0, 0, 0, 0,
    147, 255, 255, 243, 0, 0, 0, 0, 0, 19, 255, 255, 255, 111, 0, 0, 0, 0, 0, 11,
    255, 255, 255, 147, 0, 0, 0, 0, 95, 255, 255, 255, 79, 0, 0, 0, 0, 0, 3, 3,
    0, 0, 0, 0, 0, 0, 55, 255, 255, 255, 115, 0, 0, 0, 0, 0, 0, 0, 0, 3,
    223, 255, 255, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 255, 43,
    0, 7, 191, 255, 255, 239, 7, 0, 0, 0, 0, 0, 0, 0, 175, 255, 255, 187, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255,
    255, 255, 255, 255, 251, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 255,
    255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 211, 0, 0, 0, 0, 0, 23,
    255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 63, 0, 0, 0, 0, 0,
    23, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    111, 255, 255, 255, 255, 115, 135, 255, 255, 255, 255, 167, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 63, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 11, 167,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 51, 0, 0, 0, 0, 0, 179, 255, 255, 211,
    0, 0, 0, 0, 0, 0, 251, 255, 255, 143, 0, 0, 0, 0, 0, 71, 255, 255, 255, 43,
    0, 0, 0, 0, 7, 255, 255, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 235, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 255, 255, 231,
    3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 99, 0, 0, 0, 39, 255,
    255, 255, 75, 0, 0, 0, 0, 0, 0, 0, 59, 255, 255, 255, 47, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 171, 255, 255, 255, 39, 31, 247, 255,
    255, 199, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0,
    0, 0, 0, 0, 0, 0, 191, 255, 255, 223, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127,
    0, 31, 255, 255, 255, 255, 255, 255, 255, 255, 63, 0, 0, 0, 0, 0, 31, 255, 255, 255,
    127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255,
    255, 255, 255, 255, 255, 255, 119, 3, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0,
    0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 175, 255, 255, 255, 255, 235,
    255, 255, 255, 255, 255, 255, 79, 0, 0, 0, 0, 0, 191, 255, 255, 191, 0, 0, 0, 0,
    0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 111, 255, 255, 255, 3, 0, 0, 0, 0,
    0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 247,
    255, 255, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 255, 255, 255, 71, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 231, 255, 255, 131, 0,
    0, 0, 0, 0, 0, 0, 0, 203, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 15, 255, 255, 255, 119, 0, 0, 51, 255, 255, 255, 51, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0,
    0, 0, 195, 255, 255, 203, 0, 0, 0, 0, 0, 15, 255, 255, 255, 131, 0, 31, 255, 255,
    255, 255, 255, 255, 255, 255, 63, 0, 0, 0, 0, 0, 19, 255, 255, 255, 131, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 115, 255, 255, 255, 255, 255, 255,
    255, 243, 47, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0,
    223, 255, 255, 159, 0, 0, 0, 0, 0, 63, 255, 255, 255, 179, 3, 0, 0, 43, 255, 255,
    255, 255, 95, 0, 0, 0, 0, 0, 191, 255, 255, 191, 0, 0, 0, 0, 0, 0, 223, 255,
    255, 159, 0, 0, 0, 0, 0, 127, 255, 255, 255, 23, 0, 0, 0, 0, 0, 239, 255, 255,
    155, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 255, 255, 255, 79, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 203, 255, 255, 255, 167, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 195, 255, 255, 159, 0, 0, 0, 0, 0,
    0, 0, 0, 87, 255, 255, 255, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 35, 255, 255, 255, 75, 0, 0, 3, 255, 255, 255, 95, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 243, 255, 255, 163, 0, 0, 0, 0, 0, 0, 0, 0, 231, 255,
    255, 175, 0, 0, 0, 0, 0, 0, 239, 255, 255, 175, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 243, 255, 255, 171, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 111, 255, 255, 255, 207, 39, 59, 247, 255, 255, 255, 55,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 223, 255, 255, 159,
    0, 0, 0, 0, 0, 147, 255, 255, 255, 23, 0, 0, 0, 0, 127, 255, 255, 255, 95, 0,
    0, 0, 0, 0, 191, 255, 255, 191, 0, 0, 0, 0, 0, 0, 227, 255, 255, 159, 0, 0,
    0, 0, 0, 127, 255, 255, 255, 107, 0, 0, 0, 0, 67, 255, 255, 255, 107, 0, 0, 0,
    0, 0, 0, 0, 0, 63, 127, 127, 163, 255, 255, 255, 255, 175, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 51, 255, 255, 255, 255, 255, 15, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 63, 0, 0, 0, 0, 195, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 3,
    227, 255, 255, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11,
    255, 255, 255, 223, 23, 3, 127, 255, 255, 255, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 191, 255, 255, 219, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 127, 0, 0,
    0, 0, 0, 0, 171, 255, 255, 251, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 191, 255, 255, 239, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7, 247, 255, 255, 159, 0, 0, 0, 0, 175, 255, 255, 203, 0, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0,
    0, 191, 255, 255, 203, 0, 0, 0, 0, 0, 59, 255, 255, 255, 95, 0, 0, 0, 0, 0,
    175, 255, 255, 219, 0, 0, 0, 0, 0, 0, 255, 255, 255, 135, 0, 0, 0, 0, 0, 127,
    255, 255, 255, 255, 63, 0, 0, 39, 255, 255, 255, 255, 23, 0, 0, 0, 0, 0, 0, 0,
    0, 255, 255, 255, 255, 255, 255, 255, 111, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147,
    255, 255, 255, 255, 255, 103, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0,
    0, 0, 0, 231, 255, 255, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 255, 255, 247,
    7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 255, 255, 255,
    255, 255, 255, 255, 255, 179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 107, 255,
    255, 255, 63, 0, 0, 0, 0, 0, 0, 131, 255, 255, 255, 43, 0, 0, 0, 0, 0, 0,
    79, 255, 255, 255, 119, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 107, 255, 255, 255, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47,
    255, 255, 255, 67, 0, 0, 0, 0, 71, 255, 255, 255, 3, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 63, 0, 0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 191, 255, 255,
    191, 0, 0, 0, 0, 0, 43, 255, 255, 255, 75, 0, 0, 0, 0, 0, 139, 255, 255, 251,
    3, 0, 0, 0, 0, 31, 255, 255, 255, 107, 0, 0, 0, 0, 0, 115, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255,
    255, 255, 255, 255, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 247, 255, 255, 187, 255,
    255, 199, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 103, 0, 0, 0, 39, 255,
    255, 255, 75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 255, 255, 255, 107, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 255, 255, 255, 255, 255, 255,
    123, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 247, 255, 255, 243, 23,
    0, 0, 0, 0, 59, 255, 255, 255, 175, 0, 0, 0, 0, 0, 0, 0, 0, 199, 255, 255,
    255, 83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 239, 255,
    255, 255, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 255, 255, 255, 103,
    0, 0, 0, 0, 119, 255, 255, 251, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0,
    0, 0, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 175, 255, 255, 227, 0, 0, 0,
    0, 0, 91, 255, 255, 255, 27, 0, 0, 0, 0, 0, 87, 255, 255, 255, 59, 0, 0, 0,
    0, 91, 255, 255, 255, 51, 0, 0, 0, 0, 0, 79, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 175, 255, 255,
    255, 103, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 251, 27, 255, 255, 255, 39, 0,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 255, 47, 0, 7, 191, 255, 255, 239, 7, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 255, 255, 219, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 255, 255, 255, 255, 131, 35, 47, 171,
    255, 255, 255, 255, 27, 0, 0, 0, 0, 0, 0, 0, 0, 27, 255, 255, 255, 255, 235, 87,
    15, 3, 43, 127, 159, 71, 0, 0, 0, 0, 0, 0, 0, 0, 71, 255, 255, 255, 255, 183,
    59, 23, 51, 127, 159, 71, 0, 0, 0, 0, 0, 0, 219, 255, 255, 255, 91, 7, 11, 107,
    255, 255, 255, 179, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0,
    223, 255, 255, 159, 0, 0, 0, 0, 0, 103, 255, 255, 255, 83, 0, 0, 0, 3, 207, 255,
    255, 207, 0, 0, 0, 0, 0, 0, 11, 255, 255, 255, 171, 0, 0, 0, 3, 211, 255, 255,
    223, 0, 0, 0, 0, 0, 0, 27, 255, 255, 255, 123, 19, 83, 127, 99, 35, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 247, 7, 0,
    0, 0, 0, 0, 0, 0, 199, 255, 255, 159, 0, 187, 255, 255, 135, 0, 0, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 87, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 27, 255, 255, 255, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 83, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 39,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 219, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 127, 0, 0, 0, 0, 0, 0, 51, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 27,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 223, 255, 255, 159,
    0, 0, 0, 0, 0, 7, 231, 255, 255, 255, 143, 43, 71, 255, 255, 255, 255, 91, 0, 0,
    0, 0, 0, 0, 0, 135, 255, 255, 255, 187, 31, 43, 223, 255, 255, 255, 103, 0, 0, 0,
    0, 0, 0, 0, 207, 255, 255, 223, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 55, 0, 0, 0, 0, 0,
    0, 43, 255, 255, 255, 67, 0, 99, 255, 255, 231, 3, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 231, 255, 255, 255, 255, 255, 83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 167, 255, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 23, 155, 255, 255, 255, 255, 255, 255, 115, 7, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 75, 239, 255, 255, 255, 255, 255, 255, 255, 79, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 19, 147, 255, 255, 255, 255, 255, 255, 255, 79, 0, 0,
    0, 0, 0, 0, 0, 23, 163, 255, 255, 255, 255, 255, 255, 139, 15, 0, 0, 0, 0, 0,
    0, 0, 47, 239, 255, 239, 47, 0, 0, 0, 0, 0, 167, 255, 255, 119, 0, 0, 0, 0,
    0, 0, 39, 255, 255, 255, 255, 255, 255, 255, 255, 255, 143, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 191, 255, 255, 255, 255, 255, 255, 255, 255, 143, 0, 0, 0, 0, 0, 0, 0, 0,
    95, 255, 255, 255, 123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 15,
    7, 0, 0, 0, 0, 0, 95, 255, 255, 255, 59, 0, 0, 0, 0, 0, 0, 139, 255, 255,
    227, 0, 0, 19, 255, 255, 255, 71, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 11,
    47, 67, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 255,
    255, 255, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 59, 43, 11, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15,
    139, 255, 255, 255, 255, 255, 255, 75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 99,
    255, 255, 255, 255, 255, 255, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 199, 255, 255,
    255, 211, 59, 35, 87, 151, 91, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 219, 107, 35,
    31, 123, 255, 255, 255, 251, 11, 0, 0, 0, 0, 0, 7, 243, 255, 255, 139, 0, 0, 0,
    187, 255, 255, 167, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 167, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 3,
    3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 227, 255, 255, 255, 255, 255,
    255, 255, 191, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 83, 0, 0, 0, 0, 0, 0, 87, 255, 255, 255, 47, 0, 0, 0, 99, 255, 255, 255,
    15, 0, 0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 255, 255, 255, 27, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 63, 255, 255, 255, 255,
    223, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 99, 255, 255, 255, 255, 255, 255, 131, 0,
    0, 0, 0, 0, 0, 0, 0, 63, 215, 255, 255, 255, 255, 255, 255, 211, 47, 0, 0, 0,
    0, 0, 0, 0, 191, 255, 255, 207, 0, 0, 0, 0, 19, 255, 255, 255, 103, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 219, 255, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 63, 255, 255, 255, 255, 255, 255, 51, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 35, 151, 255, 255, 255, 179, 19, 0, 0, 0, 0, 0,
    159, 255, 255, 255, 167, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23,
    179, 255, 199, 39, 0, 0, 0, 0, 0, 19, 179, 255, 255, 255, 255, 255, 255, 99, 0, 0,
    0, 0, 0, 59, 219, 255, 255, 255, 255, 255, 199, 39, 0, 0, 0, 0, 0, 119, 255, 255,
    99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 239,
    255, 239, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 91, 255, 255, 179, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255,
    255, 95, 0, 0, 0, 0, 0, 0, 0, 19, 127, 255, 255, 255, 171, 0, 0, 0, 0, 0,
    0, 0, 0, 43, 255, 255, 255, 255, 255, 255, 31, 0, 0, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 219, 255, 255, 123, 0,
    0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 255, 255, 255, 159, 0, 0, 0, 0, 0, 95,
    255, 255, 255, 255, 255, 255, 255, 63, 0, 0, 0, 0, 0, 23, 251, 255, 255, 91, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    67, 195, 255, 187, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 191, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 95, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 219, 0, 0, 0, 0, 0, 0, 0, 0, 151,
    255, 255, 255, 183, 131, 71, 7, 0, 0, 0, 0, 0, 63, 127, 171, 255, 255, 255, 191, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 255, 255, 175, 0, 0, 0, 0, 0, 0,
    0, 7, 71, 127, 127, 127, 255, 255, 255, 159, 0, 0, 0, 0, 0, 95, 255, 255, 255, 127,
    127, 127, 79, 15, 0, 0, 0, 0, 0, 0, 51, 255, 255, 255, 47, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 255, 255, 255, 231,
    15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 191, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 159, 255, 255, 243, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 167, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 223, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 83, 255, 255, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 191, 255, 255, 159, 0, 0, 0, 0, 0, 95, 255, 255, 223, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 131, 255, 255, 211, 3, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 255, 255, 255, 255, 39, 0, 0, 0, 0,
    0, 0, 0, 15, 95, 203, 255, 255, 255, 255, 175, 55, 0, 0, 0, 0, 0, 0, 0, 0,
    7, 39, 63, 35, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 39, 103, 127, 127, 103, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 19, 51, 59, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 127, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    3, 223, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255,
    255, 159, 0, 0, 0, 0, 0, 95, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 15, 255, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    11, 63, 115, 127, 167, 255, 255, 255, 255, 215, 23, 0, 0, 0, 0, 0, 0, 0, 79, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 191, 11, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255,
    31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 175, 255, 255, 255, 255,
    255, 255, 255, 255, 143, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    159, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 27, 91, 99, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27,
    131, 251, 255, 255, 255, 179, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 0,
    0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 95, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 255, 255, 255,
    15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 159, 0, 0,
    0, 0, 0, 95, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    135, 255, 255, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 179, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 31, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 203, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 223,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 207, 0, 0, 0, 23, 215, 255, 255,
    255, 255, 251, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 187, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255,
    255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 0, 0, 191, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95,
    255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 255, 255, 175, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 159, 0, 0, 0, 0, 0, 95,
    255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 255, 255, 255,
    47, 0, 0, 0, 0, 0, 0, 0, 0, 135, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 87, 39, 0, 63, 255, 255, 191, 127, 255,
    255, 255, 31, 0, 0, 0, 0, 0, 63, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 23, 123, 107, 7, 0, 0, 0, 0, 87, 255, 255, 255, 99, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 223, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 47, 255, 255, 255, 83, 0, 0, 199, 255, 255, 255, 255, 255, 255, 243,
    15, 0, 0, 0, 0, 0, 0, 0, 59, 255, 255, 255, 255, 191, 103, 91, 151, 255, 255, 255,
    139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 95, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 191,
    255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 223, 0,
    0, 0, 0, 0, 0, 0, 0, 3, 247, 255, 255, 103, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 191, 255, 255, 159, 0, 0, 0, 0, 0, 95, 255, 255, 223, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 231, 255, 255, 119, 0, 0, 0,
    0, 0, 0, 0, 115, 255, 255, 255, 231, 43, 0, 0, 75, 255, 255, 255, 255, 27, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 191, 39, 255, 255, 255, 63, 0,
    0, 0, 0, 0, 63, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 199, 255, 255, 159, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 171, 255, 255, 223, 3, 55, 255, 255, 255, 67, 35, 255, 255, 255, 99, 0, 0, 0,
    0, 0, 0, 35, 255, 255, 255, 139, 3, 0, 0, 0, 0, 0, 59, 67, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 159, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 227, 255, 255, 115, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 255, 255, 255, 11, 0, 0, 0, 0,
    0, 0, 0, 47, 255, 255, 255, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 191, 255, 255, 159, 0, 0, 0, 0, 0, 95, 255, 255, 223, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 179, 255, 255, 175, 0, 0, 0, 0, 0, 0, 23,
    255, 255, 255, 195, 3, 0, 0, 0, 0, 23, 255, 255, 255, 171, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 191, 63, 255, 255, 255, 55, 0, 0, 0, 0, 0,
    63, 255, 255, 255, 31, 19, 83, 107, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 23, 255, 255, 255, 155, 0, 0, 0, 0, 0, 0, 0, 0, 11,
    71, 107, 51, 3, 159, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 255,
    255, 255, 99, 95, 255, 255, 255, 3, 0, 223, 255, 255, 147, 0, 0, 0, 0, 0, 0, 199,
    255, 255, 127, 59, 203, 255, 235, 91, 27, 139, 255, 255, 215, 83, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 255, 35, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 11, 251, 255, 255, 131, 0, 0, 0, 0, 0, 0, 0, 83,
    255, 255, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255,
    255, 159, 0, 0, 0, 0, 0, 95, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 147, 255, 255, 211, 0, 0, 0, 0, 0, 0, 131, 255, 255, 255, 39,
    0, 0, 0, 0, 0, 0, 103, 255, 255, 255, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 63, 255, 255, 219, 227, 255, 255, 247, 7, 0, 0, 0, 0, 0, 63, 255, 255, 255,
    247, 255, 255, 255, 255, 255, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 75, 159, 191,
    211, 255, 255, 255, 255, 255, 71, 0, 0, 0, 0, 0, 0, 3, 147, 255, 255, 255, 255, 255,
    255, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 155, 255, 255, 239, 107,
    255, 255, 255, 0, 0, 223, 255, 255, 159, 0, 0, 0, 0, 0, 71, 255, 255, 215, 111, 255,
    255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 35, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 0,
    0, 0, 0, 0, 139, 255, 255, 255, 255, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 59, 255, 255, 255, 255, 167, 0, 0, 0, 0, 0, 95, 255, 255, 255, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 159, 0, 0,
    0, 0, 0, 95, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 127, 255, 255, 223, 0, 0, 0, 0, 0, 0, 207, 255, 255, 207, 0, 0, 0, 0, 0,
    0, 0, 19, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 255,
    255, 255, 255, 255, 255, 99, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 51, 0, 0, 0, 0, 0, 0, 0, 79, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 91, 0, 0, 0, 0, 0, 0, 0, 163, 255, 255, 255, 255, 255, 255, 255, 255, 255, 223,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 255, 255, 203, 255, 255, 255, 23,
    3, 243, 255, 255, 127, 0, 0, 0, 0, 0, 159, 255, 255, 119, 255, 255, 255, 255, 255, 255,
    255, 255, 235, 39, 195, 255, 255, 203, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255,
    255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 0, 0, 0, 0, 0,
    159, 255, 255, 255, 255, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    39, 235, 255, 255, 255, 191, 0, 0, 0, 0, 0, 95, 255, 255, 255, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 159, 0, 0, 0, 0, 0, 95,
    255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255,
    223, 0, 0, 0, 0, 0, 0, 251, 255, 255, 151, 0, 0, 0, 0, 0, 0, 0, 0, 219,
    255, 255, 179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 223, 255, 255, 255, 255, 255, 255,
    71, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 243, 27, 0, 19, 231, 255, 255, 207,
    0, 0, 0, 0, 0, 0, 0, 215, 255, 255, 255, 199, 191, 163, 103, 35, 0, 0, 0, 0,
    0, 0, 0, 0, 71, 255, 255, 255, 115, 0, 0, 111, 255, 255, 255, 223, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 135, 255, 255, 255, 255, 255, 255, 187, 155, 255, 255, 255,
    55, 0, 0, 0, 0, 0, 207, 255, 255, 119, 255, 255, 255, 59, 11, 227, 255, 255, 251, 3,
    3, 223, 255, 255, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 95, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 0, 0, 0, 0, 0, 0, 11, 143, 255,
    255, 255, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 231, 255, 255, 183,
    23, 0, 0, 0, 0, 0, 0, 87, 255, 255, 255, 15, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 191, 255, 255, 159, 0, 0, 0, 0, 0, 95, 255, 255, 223, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 255, 255, 215, 0, 0, 0,
    0, 0, 23, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 207, 0,
    0, 0, 0, 0, 0, 0, 0, 111, 255, 255, 255, 255, 255, 255, 59, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 63, 255, 255, 255, 63, 0, 0, 0, 75, 255, 255, 255, 43, 0, 0, 0,
    0, 0, 0, 203, 255, 255, 107, 103, 131, 123, 67, 11, 0, 0, 0, 0, 0, 0, 0, 0,
    167, 255, 255, 211, 0, 0, 0, 0, 187, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 15, 255, 255, 255, 243, 255, 255, 255, 255, 255, 255, 143, 0, 0, 0, 0,
    0, 0, 223, 255, 255, 79, 255, 255, 255, 31, 0, 99, 255, 255, 255, 47, 0, 159, 255, 255,
    79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 159, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 3, 239, 255, 255, 103, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 255, 255, 255, 19, 0, 0, 0, 0,
    0, 0, 0, 51, 255, 255, 255, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 191, 255, 255, 159, 0, 0, 0, 0, 0, 95, 255, 255, 223, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 255, 255, 179, 0, 0, 0, 0, 0, 31, 255,
    255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 223, 0, 0, 0, 0, 0,
    0, 0, 71, 255, 255, 255, 255, 255, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    63, 255, 255, 255, 31, 0, 0, 0, 7, 255, 255, 255, 107, 0, 0, 0, 0, 0, 0, 71,
    255, 255, 255, 255, 255, 255, 255, 255, 175, 15, 0, 0, 0, 0, 0, 0, 219, 255, 255, 139,
    0, 0, 0, 0, 159, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 67, 255, 255, 255, 255,
    223, 163, 255, 255, 255, 87, 219, 255, 255, 247, 83, 0, 0, 0, 0, 0, 0, 0, 223, 255,
    255, 35, 255, 255, 255, 75, 0, 39, 255, 255, 255, 99, 0, 159, 255, 255, 83, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 127, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 227, 0, 0, 0, 0, 0, 0, 0, 0, 7,
    255, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255,
    255, 159, 0, 0, 0, 0, 0, 95, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 223, 255, 255, 131, 0, 0, 0, 0, 0, 19, 255, 255, 255, 127, 0,
    0, 0, 0, 0, 0, 0, 0, 195, 255, 255, 203, 0, 0, 0, 0, 0, 0, 0, 167, 255,
    255, 215, 67, 255, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255,
    31, 0, 0, 0, 0, 227, 255, 255, 127, 0, 0, 0, 0, 0, 0, 99, 255, 255, 255, 207,
    131, 195, 255, 255, 255, 199, 0, 0, 0, 0, 0, 0, 255, 255, 255, 107, 0, 0, 0, 0,
    159, 255, 255, 223, 0, 0, 0, 0, 0, 0, 67, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 155, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 255, 255, 39, 203, 255,
    255, 199, 3, 59, 255, 255, 255, 151, 0, 183, 255, 255, 55, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 0,
    0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 95, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 255, 255, 159,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 159, 0, 0,
    0, 0, 0, 95, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    31, 255, 255, 255, 59, 0, 0, 0, 0, 0, 0, 243, 255, 255, 163, 0, 0, 0, 0, 0,
    0, 0, 0, 231, 255, 255, 175, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 159, 63, 255,
    255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 31, 0, 0, 0,
    0, 227, 255, 255, 127, 0, 0, 0, 0, 0, 0, 235, 255, 255, 135, 0, 0, 0, 107, 255,
    255, 255, 67, 0, 0, 0, 0, 0, 255, 255, 255, 107, 0, 0, 0, 0, 159, 255, 255, 223,
    0, 0, 0, 0, 0, 0, 199, 255, 255, 203, 23, 243, 255, 255, 255, 255, 255, 255, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 151, 255, 255, 107, 71, 255, 255, 255, 255, 255,
    255, 255, 255, 207, 7, 251, 255, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255,
    255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 191, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95,
    255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 255, 247, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 159, 0, 0, 0, 0, 0, 95,
    255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 255, 255, 227,
    0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 219, 0, 0, 0, 0, 0, 0, 0, 31, 255,
    255, 255, 123, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 251, 87, 255, 255, 191, 0, 15,
    79, 63, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 31, 0, 0, 0, 7, 255, 255, 255,
    107, 0, 0, 0, 0, 0, 31, 255, 255, 255, 63, 0, 0, 0, 31, 255, 255, 255, 103, 0,
    0, 0, 0, 0, 219, 255, 255, 139, 0, 0, 0, 0, 159, 255, 255, 223, 0, 0, 0, 0,
    0, 11, 255, 255, 255, 103, 0, 139, 255, 255, 223, 223, 255, 255, 175, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 71, 255, 255, 223, 3, 111, 255, 255, 255, 255, 255, 255, 255, 255,
    107, 255, 255, 179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 95, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191,
    255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 223, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 7, 239, 255, 255, 99, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 191, 255, 255, 159, 0, 0, 0, 0, 0, 95, 255, 255, 223, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 227, 255, 255, 111, 0, 0, 0, 0,
    0, 0, 0, 107, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 131, 255, 255, 255, 43, 0,
    0, 0, 0, 0, 0, 0, 43, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 191, 0, 0,
    0, 0, 0, 0, 63, 255, 255, 255, 71, 0, 0, 0, 71, 255, 255, 255, 55, 0, 0, 0,
    0, 0, 27, 255, 255, 255, 75, 0, 0, 0, 43, 255, 255, 255, 127, 0, 0, 0, 0, 0,
    171, 255, 255, 199, 0, 0, 0, 0, 191, 255, 255, 223, 0, 0, 0, 0, 0, 31, 255, 255,
    255, 95, 0, 127, 255, 255, 255, 79, 255, 255, 255, 51, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 199, 255, 255, 147, 0, 47, 179, 255, 231, 135, 187, 255, 187, 255, 255, 255, 55,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 39, 103, 127, 63, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 155, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 115, 255, 255, 223, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 103, 255, 255, 243, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 191, 255, 255, 159, 0, 0, 0, 0, 0, 95, 255, 255, 223, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 115, 255, 255, 231, 7, 0, 0, 0, 0, 0, 0, 0, 15,
    247, 255, 255, 243, 23, 0, 0, 0, 0, 59, 255, 255, 255, 175, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 71, 255, 255, 255, 255, 255, 255, 255, 255, 255, 159, 0, 0, 0, 0, 0, 0,
    63, 255, 255, 255, 247, 31, 0, 15, 223, 255, 255, 211, 0, 0, 0, 0, 0, 0, 0, 219,
    255, 255, 199, 7, 0, 3, 179, 255, 255, 255, 127, 0, 0, 0, 0, 0, 79, 255, 255, 255,
    99, 0, 0, 115, 255, 255, 255, 223, 0, 0, 0, 0, 0, 11, 255, 255, 255, 103, 0, 139,
    255, 255, 223, 0, 203, 255, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35,
    255, 255, 255, 159, 7, 0, 0, 0, 0, 0, 63, 255, 255, 255, 131, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 107, 63, 35, 3, 0,
    0, 0, 0, 0, 31, 63, 95, 255, 255, 255, 199, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 195, 255, 255, 147, 0, 0, 0, 0, 0, 0, 0, 3, 35, 63, 63, 63, 231, 255,
    255, 159, 0, 0, 0, 0, 0, 95, 255, 255, 255, 63, 63, 63, 39, 7, 0, 0, 0, 0,
    0, 0, 31, 255, 255, 255, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 255, 255, 255,
    255, 131, 35, 47, 171, 255, 255, 255, 255, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 51, 187, 255, 255, 255, 147, 71, 15, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 255, 59, 0, 0, 0, 0, 0, 0, 0, 75, 255, 255, 255, 255,
    255, 255, 255, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 175, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 223, 0, 0, 0, 0, 0, 0, 207, 255, 255, 191, 15, 231, 255, 255, 167, 0,
    63, 255, 255, 255, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 255, 255, 255,
    255, 215, 143, 127, 171, 255, 255, 255, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 0,
    0, 0, 0, 0, 0, 0, 0, 59, 255, 255, 255, 255, 255, 255, 31, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 251,
    255, 255, 91, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 255, 255, 255, 255, 159, 0, 0,
    0, 0, 0, 95, 255, 255, 255, 255, 255, 255, 255, 63, 0, 0, 0, 0, 0, 11, 219, 255,
    255, 123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 191, 255, 255, 255,
    255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 127, 0, 0, 0, 0, 0, 0, 7, 147, 255, 255, 255, 255, 255, 219, 255, 255, 223,
    0, 0, 0, 0, 0, 0, 83, 255, 255, 255, 255, 255, 255, 255, 47, 0, 0, 187, 255, 255,
    207, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 179, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 139, 255,
    219, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 103, 127, 63, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 59, 211, 255, 255, 255, 215, 23, 0, 0, 0, 0, 0, 191, 255, 255, 255,
    231, 75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 227, 255, 227, 39,
    0, 0, 0, 0, 0, 23, 215, 255, 255, 255, 255, 255, 255, 119, 0, 0, 0, 0, 0, 71,
    255, 255, 255, 255, 255, 255, 239, 47, 0, 0, 0, 0, 0, 131, 255, 255, 131, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 155, 255, 255, 255, 255, 255, 255, 115, 7,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 239, 255, 143, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 51, 63, 27, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 63, 55, 19, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7, 43, 67, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 83, 255, 255, 255, 255, 255, 59, 0, 0, 0, 47, 239, 255, 243, 51, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 111, 227, 255, 255, 255, 175, 59, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

    /* This is the image data for the font texture. */
static uint8_t s_FontImageDataF[] =
{
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 63,
    23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 255, 255, 35, 0, 0, 0,
    0, 0, 63, 255, 171, 0, 43, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 207, 0, 0, 0, 0, 0, 0, 75, 255,
    191, 0, 63, 255, 203, 0, 0, 0, 0, 0, 0, 203, 255, 127, 0, 0, 0, 0, 0, 0,
    0, 63, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 63, 255, 255, 123, 0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 95, 255,
    223, 0, 0, 0, 0, 0, 0, 147, 255, 227, 3, 0, 0, 0, 0, 0, 0, 95, 255, 223,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    207, 255, 255, 35, 0, 0, 0, 0, 0, 0, 123, 255, 243, 0, 115, 255, 251, 0, 0, 0,
    0, 0, 0, 99, 255, 255, 75, 0, 0, 0, 0, 0, 0, 119, 255, 247, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 255, 255, 207, 0,
    0, 0, 0, 0, 0, 0, 139, 255, 255, 3, 131, 255, 255, 11, 0, 0, 0, 0, 0, 47,
    255, 255, 175, 0, 0, 0, 0, 0, 0, 143, 255, 255, 15, 0, 0, 0, 0, 0, 127, 95,
    0, 0, 7, 99, 175, 171, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 219, 255, 255, 123, 0, 0, 0, 0, 0,
    0, 0, 159, 255, 255, 31, 159, 255, 255, 31, 0, 0, 0, 0, 0, 3, 247, 255, 251, 23,
    0, 0, 0, 0, 0, 167, 255, 255, 39, 0, 0, 0, 0, 0, 219, 235, 67, 115, 231, 255,
    255, 255, 247, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 47, 159, 159, 159, 31, 0, 0, 0, 0, 0, 0, 0, 187, 255,
    255, 55, 183, 255, 255, 59, 0, 0, 0, 0, 0, 0, 203, 255, 255, 119, 0, 0, 0, 0,
    0, 191, 255, 255, 63, 0, 0, 0, 0, 0, 119, 255, 255, 255, 239, 127, 19, 103, 255, 107,
    0, 0, 0, 0, 0, 31, 255, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 131, 223, 223, 191, 0, 0, 0, 0, 0, 223, 255, 255,
    95, 0, 0, 0, 0, 0, 0, 79, 127, 91, 7, 0, 0, 15, 63, 31, 0, 0, 0, 0,
    0, 31, 255, 255, 255, 159, 0, 0, 0, 0, 0, 159, 159, 159, 159, 159, 159, 159, 159, 159,
    79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255,
    255, 159, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 127, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 223, 223, 223, 139, 0, 0,
    0, 0, 0, 31, 31, 31, 31, 31, 31, 31, 31, 31, 15, 0, 0, 0, 0, 0, 47, 63,
    63, 63, 63, 63, 63, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 39, 63, 51, 11, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 255, 255, 255,
    255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 39, 175, 247, 255, 255, 255, 247, 155, 11, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 23, 0, 0, 0, 0, 0, 0, 0, 0, 11,
    51, 63, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 191, 191, 191, 191, 191, 191, 47, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 95, 255, 255, 231, 223, 243, 255, 255, 167, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 51, 199, 255, 31, 0, 0, 0, 0, 0, 0, 11, 155, 247, 255, 255, 255, 243,
    119, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 63, 55, 15, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 131,
    31, 0, 0, 7, 175, 255, 251, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 151, 251,
    255, 219, 19, 0, 0, 0, 0, 0, 0, 187, 255, 255, 239, 199, 231, 255, 159, 0, 0, 0,
    0, 0, 0, 0, 0, 51, 203, 255, 255, 255, 255, 175, 0, 0, 0, 0, 0, 159, 255, 223,
    0, 95, 255, 255, 0, 63, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    131, 255, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 95, 235, 255, 243, 123, 7, 0, 0,
    0, 0, 0, 0, 75, 255, 255, 147, 3, 0, 0, 31, 63, 0, 0, 0, 0, 0, 0, 0,
    47, 243, 255, 255, 223, 207, 243, 223, 0, 0, 0, 0, 0, 159, 255, 223, 0, 95, 255, 255,
    0, 63, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 79, 231, 255, 227, 0,
    0, 0, 0, 0, 0, 0, 43, 195, 255, 255, 163, 23, 0, 0, 0, 0, 0, 0, 0, 0,
    159, 255, 239, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 251, 83,
    0, 0, 7, 67, 0, 0, 0, 0, 0, 159, 255, 223, 0, 95, 255, 255, 0, 63, 255, 255,
    31, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0,
    0, 191, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 63, 23,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 63, 175, 243, 255, 255, 255, 99, 0, 0, 0, 0, 0,
    0, 135, 251, 255, 199, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 255, 191, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 255, 255, 147, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 159, 255, 223, 0, 95, 255, 255, 0, 63, 255, 255, 31, 0, 0, 0,
    0, 0, 159, 255, 223, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0, 0, 191, 255, 191,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 163, 255, 255, 255, 147, 95, 255, 255,
    0, 0, 0, 0, 0, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 139, 255, 255, 255, 243, 163, 51, 0, 0, 0, 0, 0, 0, 0, 223, 235, 95,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 255, 255, 255, 255, 255,
    255, 63, 0, 0, 0, 0, 0, 75, 255, 255, 75, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 159, 255, 223, 0, 95, 255, 255, 0, 63, 255, 255, 31, 0, 0, 0, 0, 0, 159, 255,
    223, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 87, 255, 255, 255, 255, 255, 207, 255, 255, 0, 0, 0, 0,
    0, 255, 255, 255, 127, 0, 0, 0, 0, 0, 0, 3, 255, 255, 191, 0, 87, 255, 255, 131,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 255,
    255, 187, 59, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 251, 151, 15, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 255, 255, 255, 255, 255, 255, 63, 0, 0,
    0, 0, 0, 95, 255, 255, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 223,
    0, 95, 255, 255, 0, 63, 255, 255, 31, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0, 0,
    31, 255, 255, 95, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 151, 255, 247, 35, 3, 131, 255, 255, 255, 0, 0, 0, 0, 0, 255, 255, 255,
    127, 0, 0, 0, 0, 0, 0, 39, 255, 255, 215, 0, 115, 255, 255, 167, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 255, 19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 235, 255, 239, 103, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 207, 255, 191, 0, 0, 0, 63, 255, 255, 59, 0, 0, 0, 0, 0, 95,
    255, 255, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 223, 0, 95, 255, 255,
    0, 63, 255, 255, 31, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0, 0, 31, 255, 255, 95,
    0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183,
    255, 195, 0, 0, 3, 227, 255, 255, 0, 0, 0, 0, 0, 223, 223, 223, 111, 0, 0, 0,
    0, 0, 0, 75, 255, 235, 243, 0, 143, 247, 243, 203, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 11, 251, 255, 255, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 223,
    223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 179, 255, 239, 7, 0, 0, 147, 255, 255, 51,
    0, 0, 0, 0, 0, 95, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 255, 255, 83, 0, 0, 11, 75, 95, 0,
    0, 0, 0, 0, 0, 0, 15, 151, 251, 255, 211, 67, 0, 0, 0, 0, 0, 0, 0, 0,
    159, 255, 223, 0, 0, 0, 87, 255, 255, 19, 0, 0, 0, 0, 0, 75, 255, 255, 75, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 223, 0, 95, 255, 255, 0, 63, 255, 255,
    31, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0,
    0, 191, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0,
    0, 163, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111,
    255, 183, 255, 11, 171, 219, 223, 239, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 255,
    247, 255, 207, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 47, 255, 255, 103, 0, 11, 239, 255, 175, 0, 0, 0, 0, 0,
    0, 95, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 23, 243, 255, 255, 231, 223, 255, 255, 159, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 51, 199, 255, 255, 171, 31, 0, 0, 0, 0, 0, 0, 79, 255, 255, 91,
    0, 7, 195, 255, 207, 0, 0, 0, 0, 0, 0, 23, 255, 255, 147, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 159, 255, 255, 11, 107, 255, 255, 35, 63, 255, 255, 31, 0, 0, 0,
    0, 0, 159, 255, 223, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0, 0, 191, 255, 211,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 127, 255, 255,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 255, 131, 255, 39,
    199, 191, 191, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 255, 159, 251, 255, 15,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 175, 255, 211, 0, 103, 255, 255, 47, 0, 0, 0, 0, 0, 0, 27, 239, 255,
    211, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 55, 203, 255, 255, 255, 255, 215, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 99, 235, 255, 247, 23, 0, 0, 0, 0, 0, 0, 191, 255, 255, 227, 239, 255, 255,
    83, 0, 0, 0, 0, 0, 0, 0, 191, 255, 251, 91, 0, 0, 27, 83, 0, 0, 0, 0,
    0, 159, 255, 255, 159, 199, 255, 255, 171, 171, 255, 255, 31, 0, 0, 0, 0, 0, 159, 255,
    255, 11, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0, 0, 191, 255, 255, 23, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183, 255, 79, 255, 63, 227, 163, 171, 255,
    55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 215, 255, 95, 203, 255, 87, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39,
    251, 255, 59, 211, 255, 163, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 139, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 67, 159, 131, 0, 0, 0, 0, 0, 51, 159, 147, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 19, 35, 31, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15,
    151, 251, 31, 0, 0, 0, 0, 0, 0, 11, 159, 247, 255, 255, 235, 99, 0, 0, 0, 0,
    0, 0, 0, 0, 47, 243, 255, 255, 239, 235, 255, 191, 0, 0, 0, 0, 0, 159, 255, 227,
    255, 255, 255, 203, 255, 255, 255, 247, 3, 0, 0, 0, 0, 0, 159, 255, 255, 83, 0, 0,
    47, 255, 255, 75, 0, 0, 0, 0, 0, 191, 255, 255, 151, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 191, 255, 191, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 219, 255, 59, 227, 95, 255, 135, 151, 255, 91, 0, 0, 0,
    0, 0, 0, 0, 0, 23, 255, 255, 43, 147, 255, 151, 0, 0, 0, 0, 0, 0, 0, 23,
    31, 31, 143, 255, 255, 31, 31, 31, 7, 0, 0, 0, 0, 0, 0, 0, 159, 255, 219, 255,
    251, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 179, 255, 251, 55, 0, 0, 0, 0, 0,
    0, 0, 0, 31, 255, 255, 27, 0, 0, 0, 0, 155, 255, 159, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 19, 0,
    0, 0, 0, 0, 0, 0, 0, 11, 35, 31, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 51, 199, 255, 255, 255, 247, 139, 0, 0, 0, 0, 0, 159, 255, 127, 163, 255, 231, 27,
    139, 255, 255, 135, 0, 0, 0, 0, 0, 0, 159, 255, 255, 223, 35, 3, 143, 255, 255, 43,
    0, 0, 0, 0, 0, 191, 255, 251, 255, 139, 19, 0, 7, 3, 0, 0, 0, 0, 0, 191,
    255, 191, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 255, 255, 31, 203, 151, 255, 111, 127, 255, 131, 0, 0, 0, 0, 0, 0, 0,
    0, 95, 255, 239, 0, 91, 255, 223, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 255, 255,
    255, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 35, 251, 255, 255, 159, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 19, 235, 255, 215, 7, 0, 0, 0, 0, 0, 0, 0, 0,
    195, 255, 111, 0, 0, 0, 3, 235, 255, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31,
    127, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19,
    35, 31, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 11, 0, 0, 27, 23, 0,
    0, 0, 0, 0, 0, 0, 159, 255, 215, 239, 255, 255, 255, 255, 219, 0, 0, 0, 0, 0,
    0, 191, 255, 163, 203, 255, 255, 231, 255, 31, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0,
    0, 127, 255, 255, 0, 0, 0, 0, 0, 255, 255, 255, 127, 0, 0, 0, 0, 0, 39, 255,
    255, 7, 175, 211, 255, 83, 95, 255, 167, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 187,
    0, 35, 255, 255, 31, 0, 0, 0, 0, 0, 0, 191, 255, 255, 255, 255, 255, 255, 255, 255,
    63, 0, 0, 0, 0, 0, 0, 0, 35, 251, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 83, 255, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 111, 255, 195, 0,
    0, 0, 67, 255, 235, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 255, 179, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 159, 255, 191, 55, 219, 255, 255, 231, 59, 0, 0, 0, 0, 0, 0, 191, 255, 159,
    23, 175, 255, 255, 255, 31, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 127, 255, 255,
    0, 0, 0, 0, 0, 255, 255, 255, 127, 0, 0, 0, 0, 0, 79, 255, 243, 0, 151, 251,
    255, 59, 75, 255, 207, 0, 0, 0, 0, 0, 0, 0, 0, 231, 255, 131, 0, 0, 239, 255,
    103, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 159, 255, 203, 251, 251, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 171, 255, 251, 55, 0, 0, 0, 0, 0, 0, 0, 19, 251, 255, 27, 0, 0, 155, 255,
    143, 0, 0, 0, 0, 0, 0, 0, 83, 91, 0, 31, 255, 159, 0, 27, 143, 3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 159, 255, 223, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 35, 31, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 35,
    19, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0,
    0, 255, 255, 255, 127, 0, 0, 0, 0, 0, 115, 255, 219, 0, 123, 255, 255, 31, 55, 255,
    243, 0, 0, 0, 0, 0, 0, 0, 39, 255, 255, 75, 0, 0, 179, 255, 167, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47,
    255, 255, 71, 175, 255, 175, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 235, 255,
    219, 11, 0, 0, 0, 0, 0, 0, 0, 187, 255, 111, 0, 3, 235, 255, 59, 0, 0, 0,
    0, 0, 0, 7, 227, 255, 187, 63, 255, 159, 107, 239, 255, 107, 0, 0, 0, 0, 0, 119,
    159, 159, 159, 159, 159, 159, 159, 159, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255,
    223, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 127,
    255, 255, 111, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 223, 223,
    111, 0, 0, 0, 0, 0, 151, 255, 191, 0, 95, 255, 255, 0, 31, 255, 255, 23, 0, 0,
    0, 0, 0, 0, 107, 255, 255, 19, 0, 0, 123, 255, 235, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 255, 215, 0, 67,
    255, 255, 47, 0, 0, 0, 0, 0, 0, 11, 31, 31, 31, 31, 115, 255, 255, 147, 0, 0,
    0, 0, 0, 0, 0, 91, 255, 195, 0, 67, 255, 219, 0, 0, 0, 0, 0, 0, 0, 0,
    63, 195, 255, 251, 255, 251, 255, 243, 127, 15, 0, 0, 0, 0, 0, 191, 255, 255, 255, 255,
    255, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0, 0,
    31, 255, 255, 95, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 55, 251, 255, 167, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191,
    255, 255, 255, 251, 211, 139, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    175, 255, 219, 0, 0, 0, 67, 255, 255, 47, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255,
    255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 255, 255, 107, 0, 0, 207, 255, 179, 0,
    0, 0, 0, 0, 0, 95, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 0,
    0, 11, 247, 255, 27, 155, 255, 131, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 255,
    255, 255, 207, 23, 0, 0, 0, 0, 0, 0, 0, 71, 95, 95, 95, 95, 95, 95, 95, 95,
    23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0, 0, 31, 255, 255, 95,
    0, 0, 0, 0, 0, 127, 255, 255, 0, 11, 219, 255, 211, 11, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 255, 255,
    255, 255, 231, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 243, 255, 163, 0,
    0, 0, 15, 255, 255, 119, 0, 0, 0, 0, 0, 0, 0, 0, 79, 159, 159, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 191, 255, 239, 11, 0, 0, 99, 255, 255, 63, 0, 0, 0, 0,
    0, 95, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 171, 255,
    115, 235, 255, 43, 0, 0, 0, 0, 0, 0, 0, 0, 23, 143, 247, 255, 255, 255, 255, 207,
    79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0,
    0, 127, 255, 255, 0, 147, 255, 243, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127,
    255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 207, 63, 63, 131, 251, 255, 199,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0,
    31, 255, 255, 255, 255, 255, 255, 255, 159, 0, 0, 0, 0, 0, 127, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 71, 255, 255, 103, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 255, 239, 255, 207, 0,
    0, 0, 0, 0, 0, 0, 0, 7, 231, 255, 227, 107, 255, 175, 159, 255, 255, 111, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 159, 255, 223, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0, 0, 127, 255, 255,
    75, 255, 255, 87, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 115, 255, 255, 55, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 31, 255, 255, 255,
    255, 255, 255, 255, 159, 0, 0, 0, 0, 0, 127, 255, 255, 255, 255, 255, 255, 255, 255, 0,
    0, 0, 0, 0, 0, 7, 247, 255, 167, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 223, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 255, 255, 255, 255, 255,
    223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 187, 191, 191, 99, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 119, 147, 11, 31, 255, 159, 0, 63, 199, 15, 0, 0, 0, 0, 0, 95,
    127, 127, 127, 127, 127, 127, 127, 127, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255,
    223, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0, 0, 127, 255, 255, 231, 255, 147, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 191, 255, 191, 0, 0, 0, 11, 247, 255, 127, 0, 0, 0, 0, 0, 63, 255,
    255, 111, 63, 63, 63, 63, 55, 0, 0, 0, 0, 0, 3, 31, 31, 171, 255, 255, 59, 31,
    19, 0, 0, 0, 0, 0, 79, 255, 255, 143, 31, 31, 31, 31, 31, 0, 0, 0, 0, 0,
    0, 0, 187, 255, 239, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 159,
    0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 43, 255, 171, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 255, 255,
    255, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 11, 0, 0,
    31, 255, 255, 95, 0, 0, 0, 0, 0, 127, 255, 255, 251, 255, 75, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191,
    255, 191, 0, 0, 0, 0, 207, 255, 175, 0, 0, 0, 0, 0, 63, 255, 255, 63, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 31, 0, 0, 0, 0, 0,
    0, 0, 3, 219, 255, 231, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 255,
    255, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 0,
    0, 0, 0, 0, 39, 243, 255, 227, 67, 63, 63, 63, 55, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 11, 51, 63, 39, 3, 0, 0, 0, 0, 0, 255, 255, 127, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 223, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47,
    191, 143, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 127, 127, 127, 127, 127, 127, 127, 127,
    31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 83, 0, 0, 47, 255, 255, 75,
    0, 0, 0, 0, 0, 127, 255, 255, 127, 255, 243, 39, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0,
    0, 0, 175, 255, 195, 0, 0, 0, 0, 0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 107,
    255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 255, 255, 123, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 71, 251, 255, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 247, 255,
    255, 255, 187, 0, 0, 0, 0, 0, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 223, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 159, 255, 255, 223, 35, 3, 143, 255, 255, 43, 0, 0, 0, 0,
    0, 127, 255, 255, 3, 187, 255, 219, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127,
    255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 0, 159, 255,
    223, 0, 0, 0, 0, 0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 159, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 7, 235, 255, 211, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 255, 195, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 255,
    255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 251, 255, 251, 223, 227, 191, 0,
    0, 0, 0, 0, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 207,
    63, 63, 63, 63, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 63, 0, 0,
    0, 0, 0, 11, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 159, 255, 235, 235, 255, 255, 255, 255, 219, 0, 0, 0, 0, 0, 0, 127, 255, 255,
    0, 23, 227, 255, 191, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 0, 159, 255, 223, 0, 0, 0,
    0, 0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159,
    255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 75, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 131, 255, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 223, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183, 255, 243, 31, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 79, 255, 255, 79, 0, 0, 15, 0, 0, 0, 0, 0,
    255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 191, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 0,
    211, 255, 167, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255,
    223, 59, 219, 255, 255, 231, 59, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 59, 251,
    255, 155, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 191, 255, 191, 0, 0, 0, 0, 159, 255, 223, 0, 0, 0, 0, 0, 63, 255,
    255, 87, 31, 31, 31, 31, 19, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 31, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 23, 247, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 43, 255, 255, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 159,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 239, 255, 191, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 95, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 127, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 0, 163, 255, 247, 19,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 63, 47, 7, 0, 0, 0, 0, 0, 0,
    0, 0, 91, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27,
    63, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0, 35,
    31, 3, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 115, 255, 255, 115, 0,
    0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191,
    255, 191, 0, 0, 0, 0, 183, 255, 191, 0, 0, 0, 0, 0, 63, 255, 255, 255, 255, 255,
    255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 31, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 151, 255, 255, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    207, 255, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 255, 87, 0, 0, 0, 0, 0, 0, 0, 0,
    95, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 127, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 223, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 0, 111, 255, 255, 115, 0, 0, 0, 0,
    0, 0, 0, 0, 39, 199, 255, 255, 255, 243, 123, 0, 0, 0, 0, 0, 0, 0, 159, 247,
    123, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 159, 255, 255, 255, 171, 75,
    255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0,
    0, 0, 211, 255, 171, 0, 0, 0, 0, 0, 63, 255, 255, 255, 255, 255, 255, 255, 159, 0,
    0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 35, 255, 255, 167, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 115, 255, 251, 19,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 3, 219, 255, 211, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 31,
    0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 223, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 63, 0, 0, 0, 0, 0, 0, 59, 255, 255, 215, 0, 0, 0, 0, 0, 0, 0, 19,
    231, 255, 251, 207, 235, 255, 255, 123, 0, 0, 0, 0, 0, 0, 115, 251, 255, 219, 71, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 115, 255, 255, 219, 199, 251, 223, 255, 255, 31, 0,
    0, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127,
    255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 15, 251, 255,
    127, 0, 0, 0, 0, 0, 63, 255, 255, 87, 31, 31, 31, 31, 19, 0, 0, 0, 0, 0,
    0, 0, 0, 159, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 255,
    251, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 251, 255, 103, 0, 0, 0, 0,
    0, 0, 63, 127, 127, 239, 255, 207, 127, 127, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 103, 255, 255, 59, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 31, 0, 0, 0, 0,
    0, 0, 0, 0, 255, 255, 143, 31, 31, 31, 31, 19, 0, 0, 0, 0, 0, 223, 255, 191,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 63, 0, 0,
    0, 0, 0, 0, 11, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 131, 255, 251, 59, 0,
    3, 179, 255, 247, 11, 0, 0, 0, 0, 0, 0, 51, 195, 255, 255, 175, 27, 0, 0, 0,
    0, 0, 0, 0, 0, 195, 255, 199, 3, 0, 59, 247, 255, 255, 31, 0, 0, 0, 0, 0,
    0, 0, 159, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 127, 127, 191, 255, 255, 127, 127,
    127, 63, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 135, 255, 255, 59, 0, 0, 0,
    0, 0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159,
    255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 143, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 171, 255, 195, 0, 0, 0, 0, 0, 0, 127, 255,
    255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 255, 255,
    135, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0,
    255, 255, 255, 255, 255, 255, 255, 159, 0, 0, 0, 0, 0, 223, 255, 191, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 0,
    0, 187, 223, 223, 143, 0, 0, 0, 0, 0, 0, 211, 255, 179, 0, 0, 0, 51, 255, 255,
    83, 0, 0, 0, 0, 0, 0, 0, 0, 87, 227, 255, 243, 119, 3, 0, 0, 0, 0, 0,
    0, 223, 255, 127, 0, 0, 0, 151, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 119, 191,
    167, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 127, 0, 0,
    0, 0, 0, 191, 255, 215, 95, 119, 191, 255, 255, 203, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 31, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 255, 243, 15, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 71, 255, 255, 39, 0, 0, 0, 0, 0, 63, 127, 127, 239, 255, 207,
    127, 127, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 227, 255, 183, 0, 0, 0,
    0, 0, 0, 0, 95, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
    255, 255, 255, 159, 0, 0, 0, 0, 0, 223, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 255, 255, 135, 0, 0, 0, 7, 255, 255, 127, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 7, 127, 247, 255, 215, 43, 0, 0, 0, 0, 0, 179, 255, 179,
    0, 0, 0, 95, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 191, 191, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 191, 191, 191, 191, 191, 191, 191, 191, 191, 95, 0, 0, 0, 0, 0, 191,
    255, 255, 255, 255, 255, 255, 219, 35, 0, 0, 0, 0, 0, 0, 63, 255, 255, 63, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 31, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 83, 255, 255, 119, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 215, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 255, 191, 0, 0, 0, 0, 0, 95, 127,
    175, 255, 255, 143, 127, 127, 127, 0, 0, 0, 0, 0, 255, 255, 143, 31, 31, 31, 31, 19,
    0, 0, 0, 0, 0, 223, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 23, 255, 255, 127, 0, 0, 0, 0, 255, 255, 151, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 31, 171, 255, 95, 0, 0, 0, 0, 0, 79, 255, 255, 143, 43, 0, 95,
    255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 191, 191, 191, 191,
    171, 99, 7, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 135, 95, 95, 95, 95, 83, 0,
    0, 0, 0, 0, 11, 95, 95, 195, 255, 255, 115, 95, 59, 0, 0, 0, 0, 0, 47, 95,
    95, 95, 95, 99, 247, 255, 231, 0, 0, 0, 0, 0, 47, 95, 95, 95, 95, 95, 175, 255,
    239, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 163, 0, 0, 0, 0, 0, 0, 0, 0,
    83, 79, 0, 0, 0, 3, 239, 255, 183, 0, 0, 0, 0, 0, 191, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 223, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 255,
    255, 127, 0, 0, 0, 0, 255, 255, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    71, 219, 255, 95, 0, 0, 0, 0, 0, 0, 127, 251, 255, 255, 255, 255, 255, 255, 31, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0,
    31, 255, 255, 255, 255, 255, 255, 255, 159, 0, 0, 0, 0, 0, 127, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 127, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
    0, 0, 0, 0, 0, 187, 255, 227, 35, 7, 63, 0, 0, 0, 0, 0, 95, 255, 183, 83,
    67, 163, 255, 255, 131, 0, 0, 0, 0, 0, 95, 127, 175, 255, 255, 143, 127, 127, 127, 0,
    0, 0, 0, 0, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 191,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 127, 11, 0, 63, 255, 255, 63, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 251, 255, 135, 0, 0,
    0, 7, 255, 255, 123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 183, 255, 255, 175, 27,
    0, 0, 0, 0, 0, 0, 0, 31, 111, 159, 183, 215, 255, 255, 31, 0, 0, 0, 0, 0,
    0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 47, 191, 191, 191, 191, 191, 191, 191, 167, 0, 0, 0, 0, 0, 23, 191, 191, 191,
    191, 191, 191, 191, 119, 0, 0, 0, 0, 0, 95, 191, 191, 191, 191, 191, 191, 191, 191, 0,
    0, 0, 0, 0, 95, 191, 191, 191, 191, 191, 191, 191, 191, 0, 0, 0, 0, 0, 0, 0,
    0, 95, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 59, 247, 255, 255, 255, 255, 255, 235,
    23, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0,
    255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 191, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 63, 255, 231, 99, 67, 255, 255, 63, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 255, 183, 0, 0, 0, 55, 255, 255,
    79, 0, 0, 0, 0, 0, 0, 0, 15, 139, 251, 255, 219, 71, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 27, 0, 0, 0, 0, 0, 0, 0, 255, 255,
    255, 255, 255, 255, 255, 255, 31, 0, 0, 0, 0, 0, 151, 255, 239, 0, 0, 0, 0, 0,
    139, 255, 255, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 231,
    255, 247, 199, 0, 0, 0, 0, 0, 0, 35, 155, 231, 255, 243, 183, 43, 0, 0, 0, 0,
    0, 0, 0, 0, 95, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 175, 95,
    95, 95, 95, 83, 0, 0, 0, 0, 0, 223, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 35, 223, 255, 255, 235, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255,
    191, 0, 0, 0, 0, 0, 0, 123, 255, 251, 63, 0, 7, 179, 255, 239, 11, 0, 0, 0,
    0, 0, 0, 99, 231, 255, 247, 123, 7, 0, 0, 0, 0, 0, 0, 0, 0, 43, 123, 55,
    3, 0, 3, 167, 255, 243, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 159,
    0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 27, 0, 0, 0, 0, 179, 255, 223, 0,
    0, 0, 0, 0, 0, 3, 235, 255, 183, 0, 0, 0, 79, 255, 255, 111, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    95, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 223,
    0, 0, 0, 0, 0, 223, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7,
    123, 247, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 191, 0, 0, 0,
    0, 0, 0, 15, 227, 255, 255, 223, 239, 255, 255, 115, 0, 0, 0, 0, 0, 0, 143, 255,
    255, 175, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 251, 223, 239, 255,
    255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 0,
    0, 0, 0, 0, 31, 255, 255, 79, 0, 0, 0, 0, 235, 255, 159, 0, 0, 0, 0, 0,
    0, 0, 139, 255, 247, 11, 0, 0, 155, 255, 247, 19, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 223, 223, 27,
    0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 191, 191, 191, 191, 167, 0, 0, 0, 0,
    0, 167, 191, 143, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 159, 191,
    191, 47, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 191, 0, 0, 0, 0, 0, 0, 0,
    35, 187, 255, 255, 255, 235, 115, 0, 0, 0, 0, 0, 0, 0, 159, 219, 71, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 163, 227, 255, 255, 255, 251, 171, 19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 227, 255, 131, 0, 0, 0, 23, 255, 255, 99, 0, 0, 0, 0, 0, 0, 0, 43, 255,
    255, 91, 0, 3, 235, 255, 171, 0, 0, 0, 0, 0, 0, 0, 111, 255, 255, 15, 143, 255,
    235, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 127, 255, 223, 0, 0, 0, 0, 0, 111, 255, 255, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 167, 223, 223, 167, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 35,
    31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 7, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 15, 35, 31, 11, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 255, 219,
    159, 159, 159, 183, 255, 255, 39, 0, 0, 0, 0, 0, 0, 0, 0, 203, 255, 175, 0, 67,
    255, 255, 75, 0, 0, 0, 0, 0, 0, 0, 79, 255, 255, 47, 111, 255, 255, 15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 127, 255, 223, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 159, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 219, 255, 255,
    91, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 187, 0, 67, 255, 255, 223, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 223, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 107, 255, 255, 255, 255, 255, 255,
    255, 235, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 255, 247, 7, 151, 255, 227, 3, 0,
    0, 0, 0, 0, 0, 0, 47, 255, 255, 79, 79, 255, 255, 47, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 223,
    0, 0, 0, 0, 0, 127, 255, 227, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159,
    255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 255, 255, 255, 147, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 119, 255, 255, 207, 0, 95, 255, 255, 247, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 159,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 255, 255, 143, 127, 127, 223, 255, 175, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 15, 247, 255, 79, 227, 255, 135, 0, 0, 0, 0, 0, 0,
    0, 0, 19, 255, 255, 111, 47, 255, 255, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 87, 191, 159,
    0, 127, 255, 223, 0, 0, 0, 0, 0, 23, 63, 63, 63, 63, 63, 183, 255, 231, 63, 55,
    0, 0, 0, 0, 0, 0, 0, 0, 79, 255, 203, 255, 207, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 127, 255, 255, 231, 0, 123, 255, 255, 255, 0, 0, 0, 0, 0, 0, 159, 255, 255,
    255, 255, 239, 191, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 191, 255, 223, 0, 0, 0, 131, 255, 255, 63, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 239, 255, 75, 0, 0, 227, 255, 111, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 167, 255, 215, 255, 255, 39, 0, 0, 0, 0, 0, 0, 0, 83, 223, 255,
    255, 239, 227, 255, 255, 235, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 255, 251, 0, 147, 255, 243, 0, 135, 255, 207,
    0, 0, 0, 0, 0, 95, 255, 255, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0,
    0, 0, 0, 0, 135, 255, 131, 239, 251, 11, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255,
    243, 255, 0, 143, 255, 251, 255, 31, 0, 0, 0, 0, 0, 159, 255, 255, 255, 255, 255, 255,
    255, 163, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 191, 255, 223, 0, 0, 0, 211, 255, 255, 63, 0, 0, 0, 0, 0, 223, 255,
    159, 0, 0, 0, 63, 255, 255, 95, 0, 0, 0, 0, 0, 159, 255, 255, 0, 0, 0, 47,
    255, 255, 159, 0, 0, 0, 0, 0, 159, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 159, 255, 223, 0, 0, 0, 0, 207, 255, 219, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 7, 31, 31, 227, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 183, 255, 123, 0, 15, 255, 255, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    67, 255, 255, 255, 195, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 63, 255, 255, 0, 179, 255, 255, 19, 159, 255, 191, 0, 0, 0, 0,
    0, 95, 255, 255, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0,
    191, 255, 83, 191, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 167, 255, 211, 255, 27, 163,
    231, 223, 255, 39, 0, 0, 0, 0, 0, 159, 255, 255, 31, 31, 63, 199, 255, 255, 55, 0,
    0, 0, 0, 0, 0, 0, 31, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191,
    255, 223, 0, 0, 35, 255, 255, 255, 63, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0,
    63, 255, 255, 95, 0, 0, 0, 0, 0, 159, 255, 255, 0, 0, 0, 175, 255, 247, 23, 0,
    0, 0, 0, 0, 159, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159,
    255, 223, 0, 0, 0, 23, 255, 255, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 63, 255, 255, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 255,
    175, 0, 67, 255, 243, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 243, 255, 255,
    115, 0, 0, 0, 0, 0, 0, 0, 0, 23, 63, 187, 255, 223, 63, 207, 255, 203, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 255, 255, 15, 0, 0, 0, 0, 0, 0, 0,
    0, 59, 255, 255, 0, 211, 211, 255, 55, 159, 255, 187, 0, 0, 0, 0, 0, 23, 247, 251,
    35, 0, 0, 159, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 243, 255, 43, 147,
    255, 119, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 171, 255, 51, 191, 207, 223, 255, 63,
    0, 0, 0, 0, 0, 159, 255, 255, 0, 0, 0, 23, 255, 255, 131, 0, 0, 0, 0, 0,
    0, 0, 7, 63, 63, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 223, 0, 0,
    123, 255, 255, 255, 63, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 63, 255, 255, 95,
    0, 0, 0, 0, 0, 159, 255, 255, 0, 0, 47, 255, 255, 143, 0, 0, 0, 0, 0, 0,
    159, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0,
    0, 95, 255, 255, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 255, 219, 0, 115, 255,
    187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 255, 255, 255, 183, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 139, 255, 239, 0, 167, 255, 211, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 3, 227, 255, 255, 103, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255,
    0, 247, 147, 255, 91, 159, 255, 159, 0, 0, 0, 0, 0, 0, 143, 255, 167, 0, 0, 159,
    255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 255, 247, 0, 103, 255, 175, 0, 0,
    0, 0, 0, 0, 0, 0, 207, 255, 127, 255, 71, 219, 187, 199, 255, 79, 0, 0, 0, 0,
    0, 159, 255, 255, 0, 0, 0, 0, 227, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 223, 0, 0, 207, 255, 255, 255,
    63, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 63, 255, 255, 95, 0, 0, 0, 0,
    0, 159, 255, 255, 0, 0, 175, 255, 247, 23, 0, 0, 0, 0, 0, 0, 159, 255, 255, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0, 0, 163, 255, 231,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 247, 255, 15, 167, 255, 127, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 227, 255, 255, 31, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 107, 255, 255, 19, 135, 255, 247, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    75, 255, 255, 255, 203, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 47, 255, 115, 223,
    123, 159, 255, 159, 0, 0, 0, 0, 0, 0, 23, 247, 255, 47, 0, 159, 255, 223, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 111, 255, 207, 0, 51, 255, 239, 0, 0, 0, 0, 0, 0,
    0, 0, 223, 255, 119, 231, 95, 239, 159, 191, 255, 95, 0, 0, 0, 0, 0, 159, 255, 255,
    0, 0, 0, 0, 223, 255, 147, 0, 0, 0, 0, 0, 0, 0, 0, 171, 223, 143, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 191, 255, 223, 0, 35, 255, 219, 255, 255, 63, 0, 0, 0,
    0, 0, 223, 255, 159, 0, 0, 0, 63, 255, 255, 95, 0, 0, 0, 0, 0, 159, 255, 255,
    0, 63, 255, 255, 139, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0, 0, 235, 255, 155, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 195, 255, 67, 211, 255, 67, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 11, 243, 255, 111, 219, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75,
    255, 255, 51, 103, 255, 255, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 171, 255, 183, 251,
    255, 43, 0, 0, 0, 0, 0, 0, 0, 7, 255, 255, 91, 255, 83, 191, 159, 187, 255, 135,
    0, 0, 0, 0, 0, 0, 0, 143, 255, 175, 0, 159, 255, 223, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 167, 255, 159, 0, 11, 255, 255, 39, 0, 0, 0, 0, 0, 0, 0, 247, 255,
    95, 207, 131, 255, 131, 179, 255, 119, 0, 0, 0, 0, 0, 159, 255, 255, 0, 0, 0, 23,
    255, 255, 87, 0, 0, 0, 0, 0, 0, 0, 0, 175, 255, 219, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 191, 255, 223, 0, 111, 255, 131, 255, 255, 63, 0, 0, 0, 0, 0, 223, 255,
    159, 0, 0, 0, 63, 255, 255, 95, 0, 0, 0, 0, 0, 159, 255, 255, 0, 191, 255, 239,
    15, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 159, 255, 223, 0, 0, 59, 255, 255, 71, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 35, 95, 95, 59, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 135, 255, 127, 255, 251, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103,
    255, 251, 27, 127, 255, 227, 3, 0, 0, 0, 0, 0, 0, 0, 0, 43, 255, 255, 87, 71,
    255, 255, 59, 0, 0, 0, 0, 0, 0, 0, 0, 23, 251, 255, 79, 187, 255, 147, 0, 0,
    0, 0, 0, 0, 0, 0, 255, 255, 123, 255, 51, 159, 195, 191, 255, 127, 0, 0, 0, 0,
    0, 0, 0, 23, 247, 255, 47, 159, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223,
    255, 115, 0, 0, 219, 255, 95, 0, 0, 0, 0, 0, 0, 0, 255, 255, 95, 187, 179, 255,
    107, 159, 255, 127, 0, 0, 0, 0, 0, 159, 255, 255, 31, 31, 55, 199, 255, 211, 3, 0,
    0, 0, 0, 0, 0, 0, 0, 99, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 191,
    255, 223, 0, 195, 235, 67, 255, 255, 63, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0,
    63, 255, 255, 95, 0, 0, 0, 0, 0, 159, 255, 255, 63, 255, 255, 127, 0, 0, 0, 0,
    0, 0, 0, 0, 159, 255, 255, 127, 127, 111, 59, 0, 0, 0, 0, 0, 0, 0, 0, 159,
    255, 227, 31, 51, 199, 255, 227, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 95, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75,
    255, 219, 255, 203, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 255, 187, 0, 35,
    255, 255, 75, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 255, 255, 255, 255, 255, 223,
    0, 0, 0, 0, 0, 0, 0, 115, 255, 243, 7, 99, 255, 235, 7, 0, 0, 0, 0, 0,
    0, 0, 247, 255, 155, 255, 19, 127, 227, 191, 255, 119, 0, 0, 0, 0, 0, 0, 0, 0,
    143, 255, 175, 159, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 255, 75, 0, 0,
    175, 255, 151, 0, 0, 0, 0, 0, 0, 31, 255, 255, 67, 159, 231, 255, 87, 159, 255, 159,
    0, 0, 0, 0, 0, 159, 255, 255, 255, 255, 255, 255, 195, 23, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7, 231, 255, 219, 19, 0, 0, 0, 0, 0, 0, 0, 191, 255, 223, 27, 255,
    159, 63, 255, 255, 63, 0, 0, 0, 0, 0, 223, 255, 171, 31, 31, 31, 87, 255, 255, 95,
    0, 0, 0, 0, 0, 159, 255, 255, 191, 255, 239, 15, 0, 0, 0, 0, 0, 0, 0, 0,
    159, 255, 255, 255, 255, 255, 255, 211, 39, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 255,
    255, 255, 163, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    95, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 255, 255, 255, 143,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 255, 255, 99, 0, 0, 207, 255, 171, 0,
    0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0,
    0, 0, 0, 215, 255, 167, 0, 23, 255, 255, 87, 0, 0, 0, 0, 0, 0, 0, 223, 255,
    211, 243, 0, 95, 255, 199, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 23, 247, 255, 207,
    255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 79, 255, 255, 23, 0, 0, 127, 255, 207, 0,
    0, 0, 0, 0, 0, 39, 255, 255, 63, 131, 255, 255, 63, 131, 255, 167, 0, 0, 0, 0,
    0, 159, 255, 255, 255, 255, 255, 239, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    71, 251, 255, 191, 3, 0, 0, 0, 0, 0, 0, 191, 255, 223, 111, 255, 79, 63, 255, 255,
    63, 0, 0, 0, 0, 0, 223, 255, 255, 255, 255, 255, 255, 255, 255, 95, 0, 0, 0, 0,
    0, 159, 255, 255, 255, 255, 131, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 159,
    167, 203, 255, 255, 223, 7, 0, 0, 0, 0, 0, 159, 255, 255, 255, 255, 255, 255, 255, 135,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 127, 127, 79,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 191, 191, 63, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 147, 255, 251, 19, 0, 0, 123, 255, 251, 23, 0, 0, 0, 0,
    0, 0, 31, 63, 211, 255, 207, 63, 231, 255, 183, 55, 0, 0, 0, 0, 0, 0, 55, 255,
    255, 91, 0, 0, 195, 255, 183, 0, 0, 0, 0, 0, 0, 0, 223, 255, 255, 211, 0, 63,
    255, 243, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135, 255, 255, 255, 223, 0, 0,
    0, 0, 0, 0, 0, 0, 139, 255, 239, 0, 0, 0, 83, 255, 255, 11, 0, 0, 0, 0,
    0, 63, 255, 255, 51, 107, 255, 255, 31, 127, 255, 191, 0, 0, 0, 0, 0, 159, 255, 255,
    31, 31, 83, 235, 255, 123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 107, 255, 255,
    135, 0, 0, 0, 0, 0, 0, 191, 255, 223, 191, 243, 7, 63, 255, 255, 63, 0, 0, 0,
    0, 0, 223, 255, 255, 255, 255, 255, 255, 255, 255, 95, 0, 0, 0, 0, 0, 159, 255, 255,
    235, 255, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 0, 0, 0, 83, 255,
    255, 91, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0, 43, 183, 255, 255, 35, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 175, 191, 147, 0, 0, 0, 35, 191, 191, 83, 0, 0, 0, 0, 0, 0, 0, 0,
    167, 255, 215, 0, 199, 255, 183, 0, 0, 0, 0, 0, 0, 0, 155, 255, 247, 11, 0, 0,
    111, 255, 255, 27, 0, 0, 0, 0, 0, 0, 195, 255, 255, 179, 0, 27, 255, 255, 255, 67,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 239, 255, 255, 223, 0, 0, 0, 0, 0, 0,
    0, 0, 195, 255, 191, 0, 0, 0, 39, 255, 255, 67, 0, 0, 0, 0, 0, 79, 255, 255,
    31, 83, 255, 255, 11, 111, 255, 207, 0, 0, 0, 0, 0, 159, 255, 255, 0, 0, 0, 115,
    255, 243, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 171, 255, 247, 19, 0, 0,
    0, 0, 0, 191, 255, 239, 251, 163, 0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 223, 255,
    171, 31, 31, 31, 87, 255, 255, 95, 0, 0, 0, 0, 0, 159, 255, 255, 111, 255, 255, 71,
    0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 0, 0, 0, 0, 235, 255, 143, 0, 0,
    0, 0, 0, 159, 255, 223, 0, 0, 0, 31, 255, 255, 107, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135, 255, 247, 0,
    167, 255, 215, 0, 0, 0, 0, 0, 0, 11, 243, 255, 175, 0, 0, 0, 27, 255, 255, 127,
    0, 0, 0, 0, 0, 0, 191, 255, 255, 147, 0, 0, 251, 255, 255, 63, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 127, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 3, 247, 255,
    147, 0, 0, 0, 0, 247, 255, 123, 0, 0, 0, 0, 0, 95, 255, 255, 31, 31, 127, 127,
    0, 95, 255, 223, 0, 0, 0, 0, 0, 159, 255, 255, 0, 0, 0, 75, 255, 255, 31, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 255, 255, 83, 0, 0, 0, 0, 0, 191,
    255, 255, 255, 83, 0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0,
    63, 255, 255, 95, 0, 0, 0, 0, 0, 159, 255, 255, 7, 219, 255, 207, 3, 0, 0, 0,
    0, 0, 0, 0, 159, 255, 255, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 0, 0, 159,
    255, 223, 0, 0, 0, 0, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 191, 191, 15, 99, 191, 183, 0,
    0, 0, 0, 0, 0, 67, 191, 191, 79, 0, 0, 0, 0, 163, 191, 163, 0, 0, 0, 0,
    0, 0, 135, 191, 191, 91, 0, 0, 167, 191, 191, 39, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 15, 187, 191, 167, 0, 0, 0, 0, 0, 0, 0, 51, 255, 255, 103, 0, 0, 0,
    0, 203, 255, 179, 0, 0, 0, 0, 0, 119, 255, 255, 0, 0, 0, 0, 0, 91, 255, 247,
    0, 0, 0, 0, 0, 159, 255, 255, 0, 0, 0, 119, 255, 255, 31, 0, 0, 0, 0, 0,
    55, 3, 0, 0, 0, 0, 43, 255, 255, 95, 0, 0, 0, 0, 0, 191, 255, 255, 247, 11,
    0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 63, 255, 255, 95,
    0, 0, 0, 0, 0, 159, 255, 255, 0, 95, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0,
    159, 255, 255, 0, 0, 0, 0, 231, 255, 151, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0,
    0, 0, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39,
    59, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 191, 191, 47, 0, 0, 0, 0, 123, 191, 175,
    0, 0, 0, 0, 0, 95, 191, 191, 0, 0, 0, 0, 0, 47, 191, 191, 0, 0, 0, 0,
    0, 159, 255, 255, 95, 95, 139, 243, 255, 231, 0, 0, 0, 0, 0, 0, 159, 231, 131, 71,
    35, 71, 199, 255, 255, 51, 0, 0, 0, 0, 0, 191, 255, 255, 175, 0, 0, 63, 255, 255,
    63, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 63, 255, 255, 95, 0, 0, 0, 0,
    0, 159, 255, 255, 0, 0, 207, 255, 231, 7, 0, 0, 0, 0, 0, 0, 159, 255, 255, 0,
    0, 0, 51, 255, 255, 111, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0, 0, 63, 255, 255,
    99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 251, 159, 11,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 223,
    83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255,
    255, 255, 255, 255, 251, 91, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 255, 255, 255, 255,
    179, 0, 0, 0, 0, 0, 0, 191, 255, 255, 91, 0, 0, 63, 255, 255, 63, 0, 0, 0,
    0, 0, 223, 255, 159, 0, 0, 0, 63, 255, 255, 95, 0, 0, 0, 0, 0, 159, 255, 255,
    0, 0, 71, 255, 255, 127, 0, 0, 0, 0, 0, 0, 159, 255, 255, 95, 95, 127, 235, 255,
    251, 27, 0, 0, 0, 0, 0, 159, 255, 235, 95, 95, 127, 235, 255, 251, 27, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 139, 235, 255, 255, 191, 3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 255, 239, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 191, 191, 191, 191, 191, 143,
    47, 0, 0, 0, 0, 0, 0, 0, 23, 111, 183, 235, 255, 255, 211, 123, 3, 0, 0, 0,
    0, 0, 0, 143, 191, 191, 11, 0, 0, 47, 191, 191, 47, 0, 0, 0, 0, 0, 223, 255,
    159, 0, 0, 0, 63, 255, 255, 95, 0, 0, 0, 0, 0, 159, 255, 255, 0, 0, 0, 191,
    255, 243, 23, 0, 0, 0, 0, 0, 159, 255, 255, 255, 255, 255, 255, 255, 107, 0, 0, 0,
    0, 0, 0, 159, 255, 255, 255, 255, 255, 255, 255, 107, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 251, 255, 95, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 171, 255, 139, 0, 0, 0, 0, 0, 0, 3, 191,
    223, 83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43,
    63, 47, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 63, 47, 3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 55, 39, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 23, 59, 59, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 191, 119, 0, 0, 0,
    47, 191, 191, 71, 0, 0, 0, 0, 0, 119, 191, 191, 0, 0, 0, 51, 191, 191, 103, 0,
    0, 0, 0, 0, 119, 191, 191, 191, 191, 187, 139, 47, 0, 0, 0, 0, 0, 0, 0, 119,
    191, 191, 191, 191, 187, 143, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 163, 255, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 27, 251, 255, 35, 0, 0, 0, 0, 0, 0, 0, 119, 255, 195, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 231, 255, 255, 255, 251, 187,
    55, 0, 0, 0, 0, 0, 0, 0, 35, 191, 255, 255, 255, 239, 115, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 83, 239, 255, 255, 179, 43, 255, 255, 63, 0, 0, 0, 0, 0, 0, 199,
    255, 255, 255, 251, 167, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 59, 31,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 63, 63, 39, 3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 67, 255, 255, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    135, 255, 183, 0, 0, 0, 0, 0, 0, 0, 0, 19, 247, 255, 43, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 131, 255, 255, 255, 227, 255, 255, 255, 127, 0, 0, 0,
    0, 0, 0, 15, 227, 255, 255, 255, 255, 255, 255, 115, 0, 0, 0, 0, 0, 0, 0, 55,
    251, 255, 255, 255, 255, 203, 255, 255, 63, 0, 0, 0, 0, 0, 0, 223, 255, 255, 255, 255,
    255, 179, 0, 0, 0, 0, 0, 0, 0, 191, 255, 159, 79, 239, 255, 255, 183, 11, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 31, 219, 255, 255, 255, 255, 31, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 255,
    255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 231, 255, 75, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 163, 255, 151, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 47, 255, 255, 195, 31, 0, 19, 231, 255, 127, 0, 0, 0, 0, 0, 0, 123,
    255, 255, 95, 0, 23, 199, 255, 239, 11, 0, 0, 0, 0, 0, 0, 171, 255, 251, 95, 7,
    95, 251, 255, 255, 63, 0, 0, 0, 0, 0, 0, 95, 35, 0, 23, 163, 255, 255, 55, 0,
    0, 0, 0, 0, 0, 191, 255, 207, 251, 255, 255, 255, 255, 179, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 139, 255, 255, 227, 191, 219, 27, 0, 0, 0, 0, 0, 0, 0, 0, 15, 59,
    51, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 63, 51, 11, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 3, 43, 63, 43, 3, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 163, 255, 255, 203, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87, 255, 223, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 55, 255, 247, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 155,
    255, 239, 19, 0, 0, 0, 223, 255, 127, 0, 0, 0, 0, 0, 0, 207, 255, 179, 0, 0,
    0, 51, 255, 255, 79, 0, 0, 0, 0, 0, 0, 243, 255, 167, 0, 0, 0, 147, 255, 255,
    63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 235, 255, 139, 0, 0, 0, 0, 0,
    0, 191, 255, 255, 195, 27, 27, 195, 255, 255, 43, 0, 0, 0, 0, 0, 0, 0, 0, 183,
    255, 227, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 167, 255, 255, 255, 247, 135, 3,
    0, 0, 0, 0, 0, 0, 0, 71, 219, 255, 255, 255, 251, 155, 11, 0, 0, 0, 0, 0,
    0, 23, 151, 243, 255, 255, 255, 243, 135, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19,
    63, 47, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 47, 63, 39, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 15, 55, 63, 23, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7, 43, 63, 51, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 243, 255, 255, 255, 23, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 199, 255, 119, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 203, 255, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 227, 255, 159, 0, 0,
    0, 0, 223, 255, 127, 0, 0, 0, 0, 0, 11, 255, 255, 111, 0, 0, 0, 0, 239, 255,
    139, 0, 0, 0, 0, 0, 27, 255, 255, 103, 0, 0, 0, 79, 255, 255, 63, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 175, 255, 203, 0, 0, 0, 0, 0, 0, 191, 255, 251,
    23, 0, 0, 39, 255, 255, 115, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 167, 255, 255, 255, 255, 255, 255, 131, 0, 0, 0, 0,
    0, 0, 35, 251, 255, 255, 255, 255, 255, 255, 159, 0, 0, 0, 0, 0, 0, 127, 255, 255,
    255, 255, 255, 255, 255, 151, 0, 0, 0, 0, 0, 0, 0, 11, 171, 255, 255, 255, 231, 79,
    0, 0, 0, 0, 0, 0, 0, 75, 195, 251, 255, 255, 255, 231, 107, 0, 0, 0, 0, 0,
    0, 0, 31, 195, 255, 255, 255, 255, 203, 51, 0, 0, 0, 0, 0, 0, 0, 155, 247, 255,
    255, 255, 251, 171, 23, 0, 0, 0, 0, 0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 79, 255, 231, 215, 255, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 47, 255, 247, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 215,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 255, 255, 103, 0, 0, 0, 0, 223, 255,
    127, 0, 0, 0, 0, 0, 43, 255, 255, 67, 0, 0, 0, 0, 195, 255, 171, 0, 0, 0,
    0, 0, 35, 255, 255, 67, 0, 0, 0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0,
    39, 95, 99, 31, 135, 255, 243, 0, 0, 0, 0, 0, 0, 191, 255, 207, 0, 0, 0, 0,
    231, 255, 155, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 27, 255, 255, 159, 7, 15, 199, 255, 243, 7, 0, 0, 0, 0, 0, 139, 255,
    255, 107, 0, 19, 199, 255, 251, 15, 0, 0, 0, 0, 0, 127, 215, 83, 11, 0, 31, 203,
    255, 251, 23, 0, 0, 0, 0, 0, 0, 155, 255, 255, 235, 251, 255, 247, 35, 0, 0, 0,
    0, 0, 0, 159, 255, 255, 255, 255, 255, 255, 255, 111, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 255, 255, 255, 255, 243, 39, 0, 0, 0, 0, 0, 0, 223, 255, 255, 255, 255, 255, 255,
    183, 0, 0, 0, 0, 0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 163, 255, 159, 151, 255, 175, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 151, 255,
    163, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 239, 255, 71, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 47, 255, 255, 67, 0, 0, 0, 0, 223, 255, 127, 0, 0, 0,
    0, 0, 63, 255, 255, 43, 0, 0, 0, 0, 171, 255, 191, 0, 0, 0, 0, 0, 31, 255,
    255, 67, 0, 0, 0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 0, 131, 255, 255, 255, 247,
    207, 255, 255, 15, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 0, 195, 255, 163, 0,
    0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91,
    255, 255, 31, 0, 0, 83, 255, 255, 51, 0, 0, 0, 0, 0, 191, 255, 235, 0, 0, 0,
    83, 255, 255, 63, 0, 0, 0, 0, 0, 55, 7, 0, 0, 0, 0, 75, 255, 255, 75, 0,
    0, 0, 0, 0, 23, 251, 255, 135, 0, 27, 235, 255, 147, 0, 0, 0, 0, 0, 0, 155,
    163, 71, 31, 31, 103, 247, 255, 235, 3, 0, 0, 0, 0, 0, 59, 167, 67, 7, 11, 131,
    255, 255, 159, 0, 0, 0, 0, 0, 0, 163, 87, 15, 0, 39, 223, 255, 255, 19, 0, 0,
    0, 0, 0, 223, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 243, 255, 87,
    87, 255, 243, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 247, 255, 55, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 139, 255, 175, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 63, 255, 255, 63, 0, 27, 31, 31, 227, 255, 127, 0, 0, 0, 0, 0, 63, 255,
    255, 31, 0, 0, 0, 0, 159, 255, 191, 0, 0, 0, 0, 0, 31, 255, 255, 103, 0, 0,
    0, 83, 255, 255, 63, 0, 0, 0, 0, 0, 59, 255, 255, 231, 163, 227, 255, 255, 255, 31,
    0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 0, 195, 255, 159, 0, 0, 0, 0, 0,
    0, 0, 0, 191, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131, 255, 247, 0, 0,
    0, 47, 255, 255, 91, 0, 0, 0, 0, 0, 223, 255, 195, 0, 0, 0, 47, 255, 255, 95,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 95, 0, 0, 0, 0, 0,
    95, 255, 251, 11, 0, 0, 135, 255, 223, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0,
    0, 135, 255, 255, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 255, 235, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 115, 255, 255, 63, 0, 0, 0, 0, 0, 55,
    63, 63, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87, 255, 251, 11, 23, 255, 255, 71,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 255, 203, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 35, 255, 251, 27, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255,
    255, 63, 0, 223, 255, 255, 255, 255, 127, 0, 0, 0, 0, 0, 67, 255, 255, 31, 0, 0,
    0, 0, 159, 255, 195, 0, 0, 0, 0, 0, 0, 247, 255, 167, 0, 0, 0, 163, 255, 255,
    63, 0, 0, 0, 0, 0, 151, 255, 247, 27, 0, 15, 231, 255, 255, 31, 0, 0, 0, 0,
    0, 191, 255, 211, 0, 0, 0, 0, 231, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 191,
    255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 223, 0, 0, 0, 31, 255, 255,
    95, 0, 0, 0, 0, 0, 223, 255, 191, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 103, 255, 255, 59, 0, 0, 0, 0, 0, 147, 255, 207, 0,
    0, 0, 79, 255, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 255, 255,
    63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 255, 255, 7, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 95, 255, 255, 75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 175, 255, 191, 0, 0, 215, 255, 151, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 215, 255, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 183, 255, 135, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 63, 0, 223,
    255, 255, 255, 255, 127, 0, 0, 0, 0, 0, 63, 255, 255, 31, 0, 0, 0, 0, 159, 255,
    191, 0, 0, 0, 0, 0, 0, 183, 255, 251, 95, 31, 95, 251, 255, 255, 63, 0, 0, 0,
    0, 0, 199, 255, 199, 0, 0, 0, 147, 255, 255, 31, 0, 0, 0, 0, 0, 191, 255, 255,
    35, 0, 0, 39, 255, 255, 119, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 159, 255, 235, 0, 0, 0, 35, 255, 255, 95, 0, 0, 0,
    0, 0, 223, 255, 191, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 43, 231, 255, 239, 7, 0, 0, 0, 0, 0, 183, 255, 167, 0, 0, 0, 39, 255,
    255, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 255, 255, 63, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 95, 255, 255, 95, 0, 0, 0, 0, 0, 111, 223, 223, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 11, 247, 255, 119, 0, 0, 151, 255, 227, 0, 0, 0, 0, 0, 0, 0, 0,
    71, 255, 239, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75,
    255, 231, 7, 0, 0, 0, 0, 0, 0, 0, 39, 255, 255, 75, 0, 27, 31, 31, 31, 31,
    15, 0, 0, 0, 0, 0, 63, 255, 255, 51, 0, 0, 0, 0, 179, 255, 191, 0, 0, 0,
    0, 0, 0, 63, 255, 255, 255, 255, 255, 211, 255, 255, 63, 0, 0, 0, 0, 0, 223, 255,
    163, 0, 0, 0, 107, 255, 255, 31, 0, 0, 0, 0, 0, 191, 255, 255, 195, 39, 39, 195,
    255, 255, 55, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 159, 255, 255, 19, 0, 0, 71, 255, 255, 71, 0, 0, 0, 0, 0, 223, 255,
    191, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 27, 143, 247, 255,
    255, 103, 0, 0, 0, 0, 0, 0, 195, 255, 159, 0, 19, 3, 31, 255, 255, 67, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 151, 255, 255, 23, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 155, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255,
    255, 95, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91,
    255, 255, 39, 0, 0, 87, 255, 255, 47, 0, 0, 0, 0, 0, 0, 0, 175, 255, 139, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 223, 255, 87, 0,
    0, 0, 0, 0, 0, 0, 11, 255, 255, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 35, 255, 255, 75, 0, 0, 0, 0, 203, 255, 163, 0, 0, 0, 0, 0, 0, 0,
    103, 239, 255, 255, 167, 75, 255, 255, 63, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0,
    95, 255, 255, 31, 0, 0, 0, 0, 0, 191, 255, 223, 243, 255, 255, 255, 255, 191, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159,
    255, 255, 151, 0, 3, 167, 255, 255, 23, 0, 0, 0, 0, 0, 223, 255, 191, 0, 0, 0,
    31, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 115, 247, 255, 255, 247, 103, 0, 0, 0,
    0, 0, 0, 0, 223, 255, 135, 71, 251, 195, 7, 255, 255, 95, 0, 0, 0, 0, 0, 0,
    0, 15, 31, 71, 147, 255, 255, 167, 0, 0, 0, 0, 0, 0, 11, 95, 95, 19, 0, 3,
    219, 255, 227, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 95, 0, 0,
    0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 255, 223, 0, 0,
    0, 23, 255, 255, 123, 0, 0, 0, 0, 0, 0, 27, 251, 255, 31, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 255, 199, 0, 0, 0, 0, 0,
    0, 0, 0, 211, 255, 183, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 247,
    255, 119, 0, 0, 0, 3, 243, 255, 123, 0, 0, 0, 0, 0, 0, 0, 0, 7, 35, 23,
    0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 215, 255, 175, 0, 0, 0, 123, 255, 255, 0,
    0, 0, 0, 0, 0, 191, 255, 191, 75, 231, 255, 255, 191, 23, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 191, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 255, 235,
    235, 255, 255, 175, 0, 0, 0, 0, 0, 0, 223, 255, 191, 0, 0, 0, 31, 255, 255, 95,
    0, 0, 0, 0, 0, 0, 139, 255, 255, 251, 159, 35, 0, 0, 0, 0, 0, 0, 0, 0,
    223, 255, 127, 131, 255, 255, 3, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255,
    255, 243, 151, 11, 0, 0, 0, 0, 0, 0, 31, 255, 255, 223, 131, 187, 255, 255, 151, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 95, 0, 0, 0, 0, 0, 135,
    255, 255, 7, 0, 0, 0, 0, 0, 0, 0, 15, 247, 255, 151, 0, 0, 0, 0, 215, 255,
    199, 0, 0, 0, 0, 0, 0, 135, 255, 179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 19, 247, 255, 47, 0, 0, 0, 0, 0, 0, 0, 131,
    255, 251, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 255, 199, 0, 0,
    0, 71, 255, 255, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255,
    63, 0, 0, 0, 0, 0, 175, 255, 219, 0, 0, 0, 171, 255, 211, 0, 0, 0, 0, 0,
    0, 191, 255, 191, 0, 7, 35, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191,
    255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135, 255, 255, 147, 251, 255, 255, 191, 23,
    0, 0, 0, 0, 0, 0, 223, 255, 191, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0,
    0, 47, 255, 255, 211, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 219, 255, 143, 75,
    255, 203, 15, 255, 255, 91, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 227, 95, 0,
    0, 0, 0, 0, 0, 0, 19, 255, 255, 255, 255, 255, 255, 231, 31, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 95, 255, 255, 95, 0, 0, 0, 0, 0, 159, 255, 255, 31, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 167, 191, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 159, 255, 151, 0, 0, 0, 0, 0, 0, 0, 23, 239, 255, 235, 103,
    39, 35, 79, 155, 0, 0, 0, 0, 0, 0, 0, 99, 255, 255, 143, 47, 79, 223, 255, 223,
    3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 63, 0, 0, 0,
    0, 0, 107, 255, 255, 131, 47, 107, 251, 255, 143, 0, 0, 0, 0, 0, 0, 191, 255, 191,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 107, 255, 255, 15, 19, 63, 23, 0, 0, 0, 0, 0, 0,
    0, 0, 223, 255, 191, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0, 0, 131, 255, 255,
    35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 159, 0, 23, 7, 31, 255,
    255, 63, 0, 0, 0, 0, 0, 0, 0, 15, 31, 55, 147, 255, 255, 91, 0, 0, 0, 0,
    0, 0, 0, 255, 255, 147, 159, 191, 143, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 95, 255, 255, 95, 0, 0, 0, 0, 0, 159, 255, 255, 31, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 51, 255, 247, 15, 0, 0, 0, 0, 0, 0, 0, 75, 243, 255, 255, 255, 255, 255, 255,
    0, 0, 0, 0, 0, 0, 0, 3, 191, 255, 255, 255, 255, 255, 251, 71, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 63, 0, 0, 0, 0, 0, 7, 215,
    255, 255, 255, 255, 255, 243, 31, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 39, 63, 63, 207, 255, 191, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 63, 255, 255, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255,
    191, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0, 0, 159, 255, 227, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 175, 255, 175, 0, 0, 0, 47, 255, 255, 47, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 255, 219, 0, 0, 0, 0, 0, 0, 0, 255,
    255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255,
    255, 95, 0, 0, 0, 0, 0, 159, 255, 255, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 163, 191,
    75, 0, 0, 0, 0, 0, 0, 0, 0, 35, 155, 227, 255, 255, 219, 155, 0, 0, 0, 0,
    0, 0, 0, 0, 11, 135, 223, 255, 247, 187, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 47, 191, 191, 47, 0, 0, 0, 0, 0, 0, 19, 155, 235, 255, 247,
    191, 51, 0, 0, 0, 0, 0, 0, 0, 191, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 159, 255, 255, 255, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7,
    247, 255, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 255, 191, 0, 0, 0,
    31, 255, 255, 95, 0, 0, 0, 0, 0, 143, 255, 247, 15, 0, 0, 0, 0, 27, 0, 0,
    0, 0, 0, 0, 139, 255, 215, 0, 0, 0, 87, 255, 255, 11, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 127, 255, 255, 11, 0, 0, 0, 0, 0, 0, 255, 255, 123, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 95, 0, 0,
    0, 0, 0, 167, 255, 255, 39, 0, 0, 0, 0, 0, 0, 0, 11, 31, 27, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 143, 191, 143, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    119, 191, 191, 191, 191, 143, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 155, 255, 251, 107,
    35, 43, 99, 63, 0, 0, 0, 0, 0, 0, 223, 255, 191, 0, 0, 0, 31, 255, 255, 95,
    0, 0, 0, 0, 0, 67, 255, 255, 199, 67, 43, 83, 167, 219, 0, 0, 0, 0, 0, 0,
    87, 255, 255, 27, 0, 0, 155, 255, 215, 0, 0, 0, 0, 0, 0, 27, 7, 0, 0, 0,
    0, 143, 255, 255, 19, 0, 0, 0, 0, 0, 0, 255, 255, 127, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 95, 0, 0, 0, 0, 0, 191,
    255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 7, 63,
    63, 47, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 231, 255, 255, 255, 255, 255, 95,
    0, 0, 0, 0, 0, 0, 223, 255, 191, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0,
    0, 0, 167, 255, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 0, 11, 243, 255, 175,
    35, 75, 247, 255, 127, 0, 0, 0, 0, 0, 0, 95, 231, 123, 63, 43, 103, 243, 255, 227,
    0, 0, 0, 0, 0, 0, 0, 251, 255, 175, 95, 95, 95, 95, 59, 0, 0, 0, 0, 0,
    0, 0, 0, 83, 95, 95, 155, 255, 255, 95, 0, 0, 0, 0, 0, 191, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 31, 255, 255, 255, 247, 155,
    11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 171, 239, 255, 247, 203, 59, 0, 0, 0, 0,
    0, 0, 167, 191, 143, 0, 0, 0, 23, 191, 191, 71, 0, 0, 0, 0, 0, 0, 3, 107,
    215, 255, 255, 231, 171, 75, 0, 0, 0, 0, 0, 0, 0, 119, 255, 255, 255, 255, 255, 231,
    15, 0, 0, 0, 0, 0, 0, 95, 255, 255, 255, 255, 255, 255, 255, 91, 0, 0, 0, 0,
    0, 0, 0, 223, 255, 255, 255, 255, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 223,
    255, 255, 255, 255, 255, 95, 0, 0, 0, 0, 0, 191, 255, 255, 63, 0, 0, 0, 0, 0,
    0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 23, 191, 199, 239, 255, 255, 147, 0, 0, 0,
    0, 0, 59, 159, 147, 123, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 11, 99, 131, 159, 139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 159, 155, 23, 0,
    0, 0, 0, 0, 99, 159, 119, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 159, 159, 159,
    159, 159, 79, 0, 0, 0, 0, 0, 159, 159, 159, 159, 159, 159, 39, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 223, 255, 247, 183, 39, 0, 0, 0, 0,
    0, 0, 0, 3, 91, 183, 239, 255, 247, 195, 71, 0, 0, 0, 0, 0, 0, 0, 0, 167,
    191, 191, 191, 191, 191, 191, 119, 0, 0, 0, 0, 0, 0, 0, 0, 167, 191, 191, 191, 191,
    191, 71, 0, 0, 0, 0, 0, 147, 191, 191, 51, 0, 0, 0, 0, 0, 0, 0, 95, 255,
    223, 0, 0, 0, 0, 0, 0, 0, 0, 3, 207, 255, 219, 0, 0, 0, 0, 0, 95, 255,
    255, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 215, 255, 255,
    255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 23, 215, 255, 95, 0, 0, 0, 0, 0, 0,
    11, 211, 255, 111, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 255, 255, 255, 127, 0,
    0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 71, 127, 127, 15, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 31, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 147, 255, 255, 0, 0, 0, 0, 0, 23, 63, 63, 171, 255, 219,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 255, 243, 87, 63, 55, 0, 0,
    0, 0, 0, 0, 0, 0, 187, 255, 147, 0, 0, 0, 0, 0, 0, 0, 0, 31, 243, 251,
    63, 0, 0, 0, 0, 0, 0, 0, 47, 63, 63, 63, 207, 255, 127, 0, 0, 0, 0, 0,
    255, 255, 111, 63, 63, 63, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    195, 255, 227, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 31, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 103, 255, 223, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 255, 223, 7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 127, 0, 0, 0, 0, 0, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 255, 255, 123, 0,
    0, 0, 0, 0, 0, 0, 7, 103, 255, 255, 163, 99, 15, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 3, 31, 31, 11, 0, 0, 0, 0, 0, 27, 31, 19, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 63, 63, 63, 19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255,
    255, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 127, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 231, 255, 95,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 219, 255, 111, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 191, 255, 127, 0, 0, 0, 0, 0, 255, 255, 63, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 19, 63, 91, 223, 255, 195, 3, 0, 0, 0, 0, 0,
    0, 51, 231, 255, 255, 255, 255, 255, 227, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 147, 231, 255, 255, 255, 255, 255, 203, 59, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 11, 59, 47, 3, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 31, 63, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    31, 63, 51, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 99, 151, 159, 143,
    95, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 63, 51, 15, 0, 0, 0, 0,
    0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0,
    0, 0, 0, 0, 0, 31, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    127, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 255, 227, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 103, 255, 227, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    191, 255, 127, 0, 0, 0, 0, 0, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 35, 191, 255, 255, 255, 255, 227, 11, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255,
    255, 255, 207, 255, 255, 199, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31,
    255, 255, 95, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 255, 255, 239, 199, 191, 207, 251, 255, 251, 43, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 111, 247, 255, 255, 219, 51, 0, 0, 0, 0, 0, 0, 0, 39, 207, 255, 255,
    255, 227, 91, 171, 255, 243, 31, 0, 0, 0, 0, 0, 0, 0, 75, 215, 255, 255, 255, 247,
    159, 11, 0, 0, 0, 0, 0, 0, 0, 0, 59, 227, 255, 255, 255, 255, 255, 127, 0, 0,
    0, 0, 0, 0, 0, 0, 71, 215, 255, 255, 255, 255, 195, 0, 0, 0, 0, 0, 95, 255,
    223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0,
    0, 31, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 159, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 195, 255, 143, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 19, 251, 255, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 127, 0,
    0, 0, 0, 0, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 227, 255,
    255, 255, 255, 255, 255, 107, 0, 0, 0, 0, 0, 0, 0, 95, 159, 55, 255, 255, 31, 171,
    255, 255, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 95, 0,
    0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167,
    59, 0, 0, 0, 0, 35, 239, 255, 143, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 255,
    255, 255, 255, 255, 219, 0, 0, 0, 0, 0, 0, 15, 231, 255, 255, 255, 255, 255, 255, 255,
    255, 115, 0, 0, 0, 0, 0, 0, 0, 67, 251, 255, 255, 231, 247, 255, 255, 191, 0, 0,
    0, 0, 0, 0, 0, 27, 239, 255, 251, 167, 127, 135, 199, 127, 0, 0, 0, 0, 0, 0,
    0, 79, 251, 255, 255, 243, 235, 255, 255, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 159, 0, 0, 0, 0, 0,
    0, 0, 0, 11, 251, 255, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    199, 255, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 127, 0, 0, 0, 0, 0,
    255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 255, 255, 95, 0, 23, 199,
    255, 235, 7, 0, 0, 0, 0, 0, 0, 11, 0, 31, 255, 255, 31, 95, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0, 0,
    223, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 215, 255, 155, 0, 0, 0, 0, 0, 0, 0, 0, 0, 139, 255, 255, 47, 143, 255,
    255, 47, 0, 0, 0, 0, 0, 95, 255, 255, 179, 35, 51, 187, 255, 255, 207, 3, 0, 0,
    0, 0, 0, 0, 0, 199, 255, 231, 51, 0, 7, 155, 255, 255, 71, 0, 0, 0, 0, 0,
    0, 147, 255, 251, 63, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 15, 239, 255, 243,
    83, 0, 0, 31, 127, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 15, 255, 255, 35, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 163, 255, 143, 0, 0, 0, 0, 0, 0, 0, 0, 55,
    255, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 255, 183, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 127, 0, 0, 0, 0, 0, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 255, 179, 0, 0, 0, 51, 255, 255, 71, 0,
    0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 31, 111, 255, 255, 51, 0, 0, 0, 0, 0,
    0, 0, 0, 3, 51, 47, 0, 31, 255, 255, 95, 0, 0, 0, 0, 0, 223, 255, 159, 0,
    15, 63, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 55, 83, 115, 195, 255, 255,
    95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 255, 0, 95, 255, 255, 63, 0, 0,
    0, 0, 0, 127, 255, 255, 55, 0, 0, 151, 255, 255, 183, 0, 0, 0, 0, 0, 0, 0,
    3, 255, 255, 115, 0, 0, 0, 15, 255, 255, 131, 0, 0, 0, 0, 0, 0, 235, 255, 155,
    3, 143, 235, 247, 199, 95, 0, 0, 0, 0, 0, 0, 99, 255, 255, 87, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255,
    255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 171, 255, 147, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 35, 239, 251, 47, 0, 0, 0, 0, 0, 0, 0, 0, 91, 255, 243, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 115, 255, 219, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 191, 255, 127, 0, 0, 0, 0, 0, 255, 255, 63, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 11, 255, 255, 111, 0, 0, 0, 0, 239, 255, 131, 0, 0, 0, 0, 0,
    0, 0, 0, 31, 255, 255, 71, 227, 255, 247, 11, 0, 0, 0, 0, 0, 0, 0, 59, 231,
    255, 255, 199, 55, 255, 255, 95, 0, 0, 0, 0, 0, 223, 255, 159, 103, 247, 255, 255, 159,
    3, 0, 0, 0, 0, 0, 0, 0, 127, 247, 255, 255, 255, 255, 251, 151, 3, 0, 0, 0,
    0, 0, 11, 35, 0, 0, 135, 255, 255, 71, 147, 255, 255, 43, 0, 0, 0, 0, 0, 123,
    255, 255, 59, 0, 59, 255, 255, 255, 255, 23, 0, 0, 0, 0, 0, 0, 27, 255, 255, 63,
    0, 0, 0, 0, 223, 255, 155, 0, 0, 0, 0, 0, 35, 255, 255, 71, 135, 255, 255, 255,
    255, 255, 147, 0, 0, 0, 0, 0, 171, 255, 231, 3, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 23, 191, 255, 231, 223, 27, 0, 0, 0, 0, 0, 139, 223, 247,
    243, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    191, 255, 127, 0, 0, 0, 0, 0, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    43, 255, 255, 67, 0, 0, 0, 0, 195, 255, 167, 0, 0, 0, 0, 0, 0, 0, 0, 31,
    255, 255, 255, 255, 255, 147, 0, 0, 0, 0, 0, 0, 0, 31, 243, 255, 255, 255, 255, 207,
    255, 255, 95, 0, 0, 0, 0, 0, 223, 255, 211, 251, 255, 255, 255, 255, 147, 0, 0, 0,
    0, 0, 0, 67, 255, 255, 211, 155, 127, 83, 23, 0, 0, 0, 0, 0, 0, 0, 31, 251,
    143, 23, 47, 251, 255, 255, 255, 255, 207, 0, 0, 0, 0, 0, 0, 55, 255, 255, 159, 7,
    215, 255, 227, 255, 255, 83, 0, 0, 0, 0, 0, 0, 0, 243, 255, 99, 0, 0, 0, 11,
    255, 255, 119, 0, 0, 0, 0, 0, 75, 255, 255, 23, 231, 255, 135, 3, 187, 255, 191, 0,
    0, 0, 0, 0, 215, 255, 171, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255,
    223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 11, 151, 255, 255, 255, 31, 0, 0, 0, 0, 0, 159, 255, 255, 223, 67, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 127, 0,
    0, 0, 0, 0, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 43,
    0, 0, 0, 0, 171, 255, 191, 0, 0, 0, 0, 0, 0, 0, 11, 175, 255, 255, 255, 255,
    147, 3, 0, 0, 0, 0, 0, 0, 0, 143, 255, 255, 119, 7, 75, 243, 255, 255, 95, 0,
    0, 0, 0, 0, 223, 255, 255, 171, 19, 39, 215, 255, 251, 19, 0, 0, 0, 0, 0, 71,
    255, 255, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 247, 135, 107,
    235, 255, 255, 199, 39, 0, 0, 0, 0, 0, 0, 0, 187, 255, 255, 187, 255, 255, 87, 223,
    255, 131, 0, 0, 0, 0, 0, 0, 0, 159, 255, 211, 11, 0, 0, 151, 255, 255, 43, 0,
    0, 0, 0, 0, 95, 255, 255, 15, 255, 255, 51, 0, 159, 255, 191, 0, 0, 0, 0, 0,
    247, 255, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 127, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 255,
    175, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 247, 251, 43, 0, 0, 0, 0, 0,
    0, 0, 0, 95, 255, 239, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    111, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 127, 0, 0, 0, 0, 0,
    255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 31, 0, 0, 0, 0,
    159, 255, 191, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 255, 255, 191, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 211, 255, 199, 0, 0, 0, 127, 255, 255, 95, 0, 0, 0, 0, 0,
    223, 255, 243, 11, 0, 0, 71, 255, 255, 83, 0, 0, 0, 0, 0, 3, 219, 255, 167, 127,
    127, 87, 11, 0, 0, 0, 0, 0, 0, 0, 3, 111, 231, 255, 255, 239, 127, 39, 19, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 23, 231, 255, 255, 255, 183, 0, 191, 255, 159, 0, 0,
    0, 0, 0, 0, 0, 23, 219, 255, 203, 103, 183, 255, 255, 155, 0, 0, 0, 0, 0, 0,
    95, 255, 255, 31, 255, 255, 31, 0, 159, 255, 191, 0, 0, 0, 0, 0, 255, 255, 127, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 0, 7,
    31, 31, 143, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 15, 251, 255, 43, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 171, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 59,
    255, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 139, 255, 187, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 127, 0, 0, 0, 0, 0, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 67, 255, 255, 31, 0, 0, 0, 0, 159, 255, 195, 0,
    0, 0, 0, 0, 0, 67, 255, 255, 179, 111, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 255, 255, 135, 0, 0, 0, 51, 255, 255, 95, 0, 0, 0, 0, 0, 223, 255, 179, 0,
    0, 0, 7, 255, 255, 127, 0, 0, 0, 0, 0, 0, 151, 255, 255, 255, 255, 255, 235, 59,
    0, 0, 0, 0, 0, 0, 0, 0, 7, 127, 239, 255, 255, 231, 111, 7, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 43, 251, 255, 255, 171, 3, 191, 255, 159, 0, 0, 0, 0, 0, 0,
    0, 0, 19, 203, 255, 255, 255, 251, 139, 3, 0, 0, 0, 0, 0, 0, 95, 255, 255, 31,
    255, 255, 31, 0, 159, 255, 191, 0, 0, 0, 0, 0, 255, 255, 127, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 255,
    255, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255, 3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 131, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 15, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 143, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 191, 255, 127, 0, 0, 0, 0, 0, 255, 255, 63, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 63, 255, 255, 31, 0, 0, 0, 0, 159, 255, 191, 0, 0, 0, 0, 0,
    0, 119, 255, 255, 35, 95, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 255, 99,
    0, 0, 0, 31, 255, 255, 95, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 0, 227,
    255, 151, 0, 0, 0, 0, 0, 87, 255, 255, 119, 39, 75, 215, 255, 239, 15, 0, 0, 0,
    0, 0, 0, 0, 43, 91, 83, 139, 247, 255, 255, 223, 75, 0, 0, 0, 0, 0, 0, 0,
    0, 111, 255, 255, 255, 255, 171, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 255,
    255, 239, 255, 251, 131, 0, 0, 0, 0, 0, 0, 0, 95, 255, 255, 15, 255, 255, 51, 0,
    159, 255, 191, 0, 0, 0, 0, 0, 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 0, 63, 255, 255, 255, 255, 255, 0, 0, 0,
    0, 0, 0, 0, 0, 31, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    127, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 255, 127, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7, 247, 255, 75, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    191, 255, 127, 0, 0, 0, 0, 0, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    63, 255, 255, 51, 0, 0, 0, 0, 179, 255, 191, 0, 0, 0, 0, 0, 0, 127, 255, 255,
    15, 95, 255, 191, 0, 3, 0, 0, 0, 0, 0, 0, 23, 255, 255, 99, 0, 0, 0, 31,
    255, 255, 95, 0, 0, 0, 0, 0, 223, 255, 159, 0, 0, 0, 0, 227, 255, 151, 0, 0,
    0, 0, 0, 191, 255, 167, 0, 0, 0, 55, 255, 255, 83, 0, 0, 0, 0, 0, 3, 171,
    255, 255, 255, 227, 63, 143, 247, 255, 159, 0, 0, 0, 0, 0, 0, 0, 15, 239, 255, 219,
    171, 255, 255, 131, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 247, 255, 167, 7, 51, 231,
    255, 119, 0, 0, 0, 0, 0, 0, 71, 255, 255, 19, 223, 255, 135, 19, 215, 255, 191, 0,
    0, 0, 0, 0, 239, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255,
    223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 31, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 159, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 119, 255, 215, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 87, 255, 239, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 127, 0,
    0, 0, 0, 0, 255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 255, 255, 75,
    0, 0, 0, 0, 203, 255, 163, 0, 0, 0, 0, 0, 0, 87, 255, 255, 107, 95, 255, 199,
    91, 187, 0, 0, 0, 0, 0, 0, 0, 255, 255, 135, 0, 0, 0, 51, 255, 255, 95, 0,
    0, 0, 0, 0, 223, 255, 179, 0, 0, 0, 7, 255, 255, 127, 0, 0, 0, 0, 0, 223,
    255, 127, 0, 0, 0, 0, 255, 255, 127, 0, 0, 0, 0, 0, 107, 255, 255, 243, 255, 255,
    203, 0, 35, 159, 155, 0, 0, 0, 0, 0, 0, 0, 119, 255, 255, 79, 3, 191, 255, 247,
    19, 0, 0, 0, 0, 0, 0, 0, 0, 131, 255, 235, 7, 0, 0, 99, 255, 243, 7, 0,
    0, 0, 0, 0, 35, 255, 255, 67, 127, 255, 255, 255, 255, 255, 191, 0, 0, 0, 0, 0,
    207, 255, 179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 255,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 159, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 19, 247, 255, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 199,
    255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 127, 0, 0, 0, 0, 0,
    255, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 247, 255, 119, 0, 0, 0, 3,
    243, 255, 123, 0, 0, 0, 0, 0, 0, 11, 235, 255, 255, 239, 255, 255, 255, 223, 0, 0,
    0, 0, 0, 0, 0, 219, 255, 199, 0, 0, 0, 131, 255, 255, 95, 0, 0, 0, 0, 0,
    223, 255, 243, 15, 0, 0, 71, 255, 255, 91, 0, 0, 0, 0, 0, 219, 255, 139, 0, 0,
    0, 31, 255, 255, 127, 0, 0, 0, 0, 0, 179, 255, 239, 11, 155, 255, 255, 15, 0, 0,
    11, 0, 0, 0, 0, 0, 0, 0, 191, 255, 235, 0, 0, 63, 255, 255, 83, 0, 0, 0,
    0, 0, 0, 0, 0, 183, 255, 191, 0, 0, 0, 35, 255, 255, 55, 0, 0, 0, 0, 0,
    0, 227, 255, 147, 3, 139, 223, 211, 195, 255, 159, 0, 0, 0, 0, 0, 159, 255, 239, 7,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 95, 95, 95, 0, 0, 0, 0, 0, 0, 0, 0, 59, 255, 255, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 127, 255, 207, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 255, 239, 15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 127, 0, 0, 0, 0, 0, 255, 255, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 255, 199, 0, 0, 0, 71, 255, 255, 67, 0,
    0, 0, 0, 0, 0, 0, 59, 227, 255, 255, 255, 255, 251, 147, 0, 0, 0, 0, 0, 0,
    0, 155, 255, 255, 119, 31, 83, 243, 255, 255, 95, 0, 0, 0, 0, 0, 223, 255, 255, 175,
    39, 47, 215, 255, 255, 27, 0, 0, 0, 0, 0, 163, 255, 235, 39, 0, 3, 167, 255, 255,
    127, 0, 0, 0, 0, 0, 191, 255, 223, 0, 127, 255, 255, 31, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 211, 255, 211, 0, 0, 43, 255, 255, 95, 0, 0, 0, 0, 0, 0, 0,
    0, 179, 255, 211, 0, 0, 0, 63, 255, 255, 51, 0, 0, 0, 0, 0, 0, 139, 255, 247,
    51, 0, 0, 0, 171, 255, 135, 0, 0, 0, 0, 0, 79, 255, 255, 111, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255,
    255, 0, 0, 0, 0, 0, 11, 31, 31, 143, 255, 227, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 99, 255, 235, 51, 31, 27, 0, 0, 0, 0, 0, 0, 0, 7, 211, 255,
    119, 0, 0, 0, 0, 0, 0, 0, 0, 19, 227, 255, 91, 0, 0, 0, 0, 0, 0, 0,
    23, 31, 31, 31, 199, 255, 127, 0, 0, 0, 0, 0, 255, 255, 87, 31, 31, 31, 7, 0,
    0, 0, 0, 0, 0, 99, 255, 255, 143, 47, 79, 223, 255, 223, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 7, 75, 155, 255, 207, 15, 0, 0, 0, 0, 0, 0, 0, 0, 43, 251, 255,
    255, 255, 255, 187, 255, 255, 95, 0, 0, 0, 0, 0, 223, 255, 191, 251, 255, 255, 255, 255,
    167, 0, 0, 0, 0, 0, 0, 55, 251, 255, 251, 199, 231, 235, 255, 255, 127, 0, 0, 0,
    0, 0, 167, 255, 247, 79, 199, 255, 247, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    163, 255, 255, 135, 75, 195, 255, 255, 43, 0, 0, 0, 0, 0, 0, 0, 0, 119, 255, 255,
    127, 35, 51, 207, 255, 239, 7, 0, 0, 0, 0, 0, 0, 19, 231, 255, 243, 147, 107, 171,
    255, 255, 47, 0, 0, 0, 0, 0, 3, 215, 255, 251, 127, 43, 35, 83, 139, 0, 0, 0,
    0, 0, 95, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 0, 0, 0,
    0, 0, 95, 255, 255, 255, 255, 119, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    15, 231, 255, 255, 255, 223, 0, 0, 0, 0, 0, 0, 0, 0, 35, 235, 251, 67, 0, 0,
    0, 0, 0, 0, 3, 187, 255, 143, 0, 0, 0, 0, 0, 0, 0, 0, 191, 255, 255, 255,
    255, 255, 127, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 63, 0, 0, 0, 0, 0,
    0, 3, 191, 255, 255, 255, 255, 255, 251, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 95, 255, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 231, 255, 255, 183, 11,
    255, 255, 95, 0, 0, 0, 0, 0, 223, 255, 127, 83, 239, 255, 255, 171, 11, 0, 0, 0,
    0, 0, 0, 0, 79, 231, 255, 255, 219, 55, 223, 255, 127, 0, 0, 0, 0, 0, 71, 255,
    255, 255, 255, 255, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 243, 255, 255,
    255, 255, 255, 163, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 215, 255, 255, 255, 255, 255,
    255, 103, 0, 0, 0, 0, 0, 0, 0, 0, 55, 227, 255, 255, 255, 255, 251, 111, 0, 0,
    0, 0, 0, 0, 0, 51, 239, 255, 255, 255, 255, 255, 223, 0, 0, 0, 0, 0, 59, 159,
    139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 127, 127, 0, 0, 0, 0, 0, 71, 191,
    191, 159, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 135, 179,
    191, 167, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 191, 179, 23, 0, 0, 0, 0, 0,
    107, 191, 151, 3, 0, 0, 0, 0, 0, 0, 0, 0, 143, 191, 191, 191, 191, 191, 95, 0,
    0, 0, 0, 0, 191, 191, 191, 191, 191, 191, 47, 0, 0, 0, 0, 0, 0, 0, 11, 135,
    223, 255, 247, 187, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 191, 143,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 35, 23, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 7, 35, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 35, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 219, 255, 239, 151,
    11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 183, 247, 255, 219, 123, 3,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 151, 231, 255, 251, 195, 83, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7, 91, 143, 159, 123, 43, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 31, 155, 235, 255, 251, 207, 119, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};
