﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
/**
* @file nns_Log.h
*
* ログ出力と画面出力を行うAPI のヘッダです。
*/
#pragma once

#include <nn/nn_Common.h>

namespace nns {
namespace gfxLog {
namespace detail{

/**
* @brief ログ出力を行います。
*
* @param[in]    format   ログ出力するテキスト
* @details ログ出力を行います。この関数を直接呼ばず、NNS_LOG() を使ってください。
*/
void PrintLog(const char * format, ...) NN_NOEXCEPT;
} // detail
} // namespace gfxLog
} // namespace nns

/*!
*   @brief ログ出力を行います。
*
*   @details このマクロで出力する際 "\n" を入れると改行します。
*/
#define NNS_LOG(...)    nns::gfxLog::detail::PrintLog( __VA_ARGS__ )
