﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nns/nac/nac_MemoryAllocator.h>

namespace nns {
namespace nac {

//------------------------------------------------------------------------------
//! @brief FileLoad
//!
//! @param[in] outBuffer        読み込んだバッファ
//! @param[in] outBufferSize    読み込んだバッファサイズ
//! @param[in] filePath         ファイルパス
//! @param[in] basePath         コンテンツディレクトリパス(Cafeの場合はNULLでも可)
//! @param[in] allocator        メモリアロケータ
//! @param[in] alignment        メモリ確保時のアライメント
//------------------------------------------------------------------------------
bool FileLoad( void**           outBuffer,
               size_t*             outBufferSize,
               const char*      filePath,
               const char*      basePath,
               MemoryAllocator* allocator,
               int              alignment );

}
}
