﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       デジタルボタンに関する API の宣言
 */

#pragma once

#include <nn/util/util_BitFlagSet.h>

namespace nns { namespace hid {

const int ButtonCountMax = 27;  //!< デジタルボタンの数です。

/**
 * @brief       デジタルボタンの定義です。
 */
struct Button
{
    typedef nn::util::BitFlagSet<32, Button>::Flag< 0> A;       //!< A ボタン
    typedef nn::util::BitFlagSet<32, Button>::Flag< 1> B;       //!< B ボタン
    typedef nn::util::BitFlagSet<32, Button>::Flag< 2> X;       //!< X ボタン
    typedef nn::util::BitFlagSet<32, Button>::Flag< 3> Y;       //!< Y ボタン
    typedef nn::util::BitFlagSet<32, Button>::Flag< 4> StickL;  //!< 左スティック押し込み
    typedef nn::util::BitFlagSet<32, Button>::Flag< 5> StickR;  //!< 右スティック押し込み
    typedef nn::util::BitFlagSet<32, Button>::Flag< 6> Minus;   //!< - ボタン
    typedef nn::util::BitFlagSet<32, Button>::Flag< 7> Plus;    //!< + ボタン
    typedef nn::util::BitFlagSet<32, Button>::Flag< 8> Start;   //!< Start ボタン
    typedef nn::util::BitFlagSet<32, Button>::Flag< 9> Select;  //!< Select ボタン
    typedef nn::util::BitFlagSet<32, Button>::Flag<10> ZL;      //!< ZL ボタン
    typedef nn::util::BitFlagSet<32, Button>::Flag<11> ZR;      //!< ZR ボタン
    typedef nn::util::BitFlagSet<32, Button>::Flag<12> L;       //!< L ボタン
    typedef nn::util::BitFlagSet<32, Button>::Flag<13> R;       //!< R ボタン
    typedef nn::util::BitFlagSet<32, Button>::Flag<14> Touch;   //!< ポインティングデバイス
    typedef nn::util::BitFlagSet<32, Button>::Flag<15> Up;      //!< 十字ボタン 上
    typedef nn::util::BitFlagSet<32, Button>::Flag<16> Down;    //!< 十字ボタン 下
    typedef nn::util::BitFlagSet<32, Button>::Flag<17> Left;    //!< 十字ボタン 左
    typedef nn::util::BitFlagSet<32, Button>::Flag<18> Right;   //!< 十字ボタン 右
    typedef nn::util::BitFlagSet<32, Button>::Flag<19> LsUp;    //!< 左スティック 上
    typedef nn::util::BitFlagSet<32, Button>::Flag<20> LsDown;  //!< 左スティック 下
    typedef nn::util::BitFlagSet<32, Button>::Flag<21> LsLeft;  //!< 左スティック 左
    typedef nn::util::BitFlagSet<32, Button>::Flag<22> LsRight; //!< 左スティック 右
    typedef nn::util::BitFlagSet<32, Button>::Flag<23> RsUp;    //!< 右スティック 上
    typedef nn::util::BitFlagSet<32, Button>::Flag<24> RsDown;  //!< 右スティック 下
    typedef nn::util::BitFlagSet<32, Button>::Flag<25> RsLeft;  //!< 右スティック 左
    typedef nn::util::BitFlagSet<32, Button>::Flag<26> RsRight; //!< 右スティック 右
};

/**
 * @brief       デジタルボタンの集合を扱う型です。
 */
typedef nn::util::BitFlagSet<32, Button> ButtonSet;

}} // namespace nns::hid
