﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid/hid_Keyboard.h>
#include <nn/util/util_BitFlagSet.h>

namespace nns {
namespace console {

// PadButton : Npad, DebugPad のボタン入力のマップ
struct PadButton
{
    typedef nn::util::BitFlagSet<32, PadButton>::Flag<0> A;
    typedef nn::util::BitFlagSet<32, PadButton>::Flag<1> B;
    typedef nn::util::BitFlagSet<32, PadButton>::Flag<2> X;
    typedef nn::util::BitFlagSet<32, PadButton>::Flag<3> Y;
    typedef nn::util::BitFlagSet<32, PadButton>::Flag<4> L;
    typedef nn::util::BitFlagSet<32, PadButton>::Flag<5> R;
    typedef nn::util::BitFlagSet<32, PadButton>::Flag<6> ZL;
    typedef nn::util::BitFlagSet<32, PadButton>::Flag<7> ZR;
    typedef nn::util::BitFlagSet<32, PadButton>::Flag<8> Plus;
    typedef nn::util::BitFlagSet<32, PadButton>::Flag<9> Minus;
    typedef nn::util::BitFlagSet<32, PadButton>::Flag<10> Left;
    typedef nn::util::BitFlagSet<32, PadButton>::Flag<11> Up;
    typedef nn::util::BitFlagSet<32, PadButton>::Flag<12> Right;
    typedef nn::util::BitFlagSet<32, PadButton>::Flag<13> Down;
};
typedef nn::util::BitFlagSet<32, PadButton> PadButtonSet;

// PadEventListenerBase : Npad, DebugPad のボタン入力イベントのハンドラ
class PadEventListenerBase
{
protected:
    // 派生型において、必要に応じて下記を実装する
    virtual void OnButtonPressedImpl(const PadButtonSet&) NN_NOEXCEPT
    {
    }
    virtual void OnButtonReleasedImpl(const PadButtonSet&) NN_NOEXCEPT
    {
    }
    virtual void OnButtonRepeatedImpl(const PadButtonSet&) NN_NOEXCEPT
    {
    }

public:
    void OnButtonPressed(const PadButtonSet& buttons) NN_NOEXCEPT
    {
        OnButtonPressedImpl(buttons);
    }
    void OnButtonReleased(const PadButtonSet& buttons) NN_NOEXCEPT
    {
        OnButtonReleasedImpl(buttons);
    }
    void OnButtonRepeated(const PadButtonSet& buttons) NN_NOEXCEPT
    {
        OnButtonRepeatedImpl(buttons);
    }
};

// KeyboardEventListenerBase : USB Keyboard のキー入力イベントのハンドラ
class KeyboardEventListenerBase
{
protected:
    // 派生型において、必要に応じて下記を実装する
    virtual void OnKeyPressedImpl(const nn::hid::KeyboardKeySet&, const nn::hid::KeyboardModifierSet&) NN_NOEXCEPT
    {
    }
    virtual void OnKeyReleasedImpl(const nn::hid::KeyboardKeySet&, const nn::hid::KeyboardModifierSet&) NN_NOEXCEPT
    {
    }
    virtual void OnKeyRepeatedImpl(const nn::hid::KeyboardKeySet&, const nn::hid::KeyboardModifierSet&) NN_NOEXCEPT
    {
    }

public:
    void OnKeyPressed(const nn::hid::KeyboardKeySet& key, const nn::hid::KeyboardModifierSet& modifier) NN_NOEXCEPT
    {
        OnKeyPressedImpl(key, modifier);
    }
    void OnKeyReleased(const nn::hid::KeyboardKeySet& key, const nn::hid::KeyboardModifierSet& modifier) NN_NOEXCEPT
    {
        OnKeyReleasedImpl(key, modifier);
    }
    void OnKeyRepeated(const nn::hid::KeyboardKeySet& key, const nn::hid::KeyboardModifierSet& modifier) NN_NOEXCEPT
    {
        OnKeyRepeatedImpl(key, modifier);
    }
};

} // ~namespace nn::console
}
