﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//------------------------------------------------------------------
// デモ: FsFileStream
//
// 概要
//   nw::ut::FsFileStream クラスのデモです。
//------------------------------------------------------------------

#define NW_CONSOLE_ENABLE

#include <nw/demo/demo_Main.h>
#include <nw/demo/demo_DefaultAllocator.h>
#include <nw/ut.h>

#if defined(NW_PLATFORM_CAFE)
#include <cafe.h>
#else
#include <winext/cafe.h>
using namespace nw::internal::winext;
#endif

static FSClient*   s_FsClient   = NULL;
static FSCmdBlock* s_FsCmdBlock = NULL;

/*---------------------------------------------------------------------------*
  Name:         main

  Description:  サンプルのメイン関数です。

  Arguments:    なし。

  Returns:      なし。
 *---------------------------------------------------------------------------*/
int
NwDemoMain(int /* argc */, char ** /* argv */)
{
    nw::demo::DefaultAllocator allocator;

    FSInit();
    s_FsClient   = reinterpret_cast<FSClient*>(allocator.Alloc(sizeof(FSClient)));
    s_FsCmdBlock = reinterpret_cast<FSCmdBlock*>(allocator.Alloc(sizeof(FSCmdBlock)));
    FSAddClient(s_FsClient, FS_RET_NO_ERROR);
    FSInitCmdBlock(s_FsCmdBlock);

    nw::ut::FsFileStream file;
    bool result = file.Open( s_FsClient, s_FsCmdBlock, "/vol/content/ut/FsFileStream/abc.txt", "r" );
    NW_ASSERTMSG( result, "Failed: FsFileStream::Open\n" );

    const u32 fileSize = file.GetSize();
#ifdef NW_PLATFORM_CAFE
    char* buffer = reinterpret_cast<char*>(allocator.Alloc(fileSize+1, PPC_IO_BUFFER_ALIGN));
#else
    char* buffer = reinterpret_cast<char*>(allocator.Alloc(fileSize+1));
#endif
    s32 readSize = file.Read( buffer, fileSize );
    NW_ASSERT( readSize == static_cast<s32>(fileSize) );
    buffer[fileSize] = '\0';

    file.Close();

    NW_LOG( "ReadFile: %s\n",  buffer );

    FSDelClient(s_FsClient, FS_RET_NO_ERROR);
    allocator.Free(s_FsClient);
    allocator.Free(s_FsCmdBlock);
    s_FsClient = NULL;
    s_FsCmdBlock = NULL;

    NW_LOG( "End of demo.\n" );
    return 0;
}

