﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifdef _WIN32
#include <clocale>
#define NOMINMAX
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <crtdbg.h>
#else
#include <cafe/demo.h>
#endif

#include <nw/g3d.h>
#include <g3ddemo_DemoUtility.h>

int EmptyMain(int argc, const char* argv[]);
int SimpleMain(int argc, const char* argv[]);
int UserModelMain(int argc, const char* argv[]);
int StreamOutMain(int argc, const char* argv[]);
int EditMain(int argc, const char* argv[]);
int MaterialPickMain(int argc, const char* argv[]);
int ParallelMain(int argc, const char* argv[]);
int OutlineMain(int argc, const char* argv[]);
int TownMain(int argc, const char* argv[]);

#define DEFINE_MENU(title) { #title, strlen(#title), title##Main }

nw::g3d::demo::CmdMenu::Item s_MenuItems[] = {
    DEFINE_MENU(Empty),
    DEFINE_MENU(Simple),
    DEFINE_MENU(UserModel),
    DEFINE_MENU(StreamOut),
    DEFINE_MENU(Edit),
    DEFINE_MENU(MaterialPick),
    DEFINE_MENU(Parallel),
    DEFINE_MENU(Outline),
    DEFINE_MENU(Town),
    { "Exit", strlen("Exit"), NULL }
};

int main(int argc, const char* argv[])
{
#ifndef _WIN32
    DEMOInit();
#endif

    nw::g3d::demo::InitLauncher();

    --argc;
    ++argv;

    nw::g3d::DebugPrint("[g3d demo launcher]\n");
    nw::g3d::demo::CmdMenu menu(s_MenuItems);
    int result = menu.Loop(argc, argv);

#ifndef _WIN32
    DEMOShutdown();
#endif

    return result;
}
