﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/g3d.h>
#include <g3ddemo_DemoUtility.h>
#include <g3ddemo_GfxUtility.h>

namespace g3ddemo = nw::g3d::demo;

int EmptyMain(int argc, const char* argv[])
{
    (void)argc;
    (void)argv;

    // 初期化処理。
    g3ddemo::Init();
    g3ddemo::InitDisplay();

    g3ddemo::Pad pad;
    if (!pad.Reset())
    {
        g3ddemo::PostQuitMsg();
    }

    // グラフィックスリソースの初期化処理。
    nw::g3d::GfxContext::Prepare(); // 構築に GL コンテクストが必要。
    nw::g3d::GfxContext* pCtx = nw::g3d::demo::AllocMem2<nw::g3d::GfxContext>(
        sizeof(*pCtx), GX2_CONTEXT_STATE_ALIGNMENT);
    pCtx->Setup();
    pCtx->TempPrepare();

    g3ddemo::FrameBuffer frameBufferTV;
    {
        g3ddemo::FrameBuffer::InitArg initArg(1280, 720);
        initArg.colorBufferFTV = true;
        size_t bufferSize = g3ddemo::FrameBuffer::CalcSize(initArg);
        frameBufferTV.Init(initArg, g3ddemo::AllocMem2(bufferSize), bufferSize);
        frameBufferTV.Setup();
        frameBufferTV.Alloc(g3ddemo::AllocMem1);
    }

    g3ddemo::FrameBuffer frameBufferDRC;
    {
        g3ddemo::FrameBuffer::InitArg initArg(854, 480);
        size_t bufferSize = g3ddemo::FrameBuffer::CalcSize(initArg);
        frameBufferDRC.Init(initArg, g3ddemo::AllocMem2(bufferSize), bufferSize);
        frameBufferDRC.Setup();
        frameBufferDRC.Alloc(g3ddemo::AllocMem1);
    }

    nw::g3d::GfxColorBuffer& colorBufferTV =
        frameBufferTV.GetColorBufferTexture(GX2_RENDER_TARGET_0)->renderBuffer;
    nw::g3d::GfxDepthBuffer& depthBufferTV = frameBufferTV.GetDepthBufferTexture()->renderBuffer;
    nw::g3d::GfxColorBuffer& colorBufferDRC =
        frameBufferDRC.GetColorBufferTexture(GX2_RENDER_TARGET_0)->renderBuffer;
    nw::g3d::GfxDepthBuffer& depthBufferDRC = frameBufferDRC.GetDepthBufferTexture()->renderBuffer;

    // メインループ
    u32 counter = 0;
    while (g3ddemo::ProcessMsg())
    {
        if (!pad.Read() || pad.IsTriggered(g3ddemo::Pad::BUTTON_START))
        {
            g3ddemo::PostQuitMsg();
        }

        // 計算
        float sinR, sinG, sinB, cosR, cosG, cosB;
        {
            counter += 0x1000000;
            nw::g3d::math::Math::SinCosIdx(&sinR, &cosR, counter);
            nw::g3d::math::Math::SinCosIdx(&sinG, &cosG, counter + 0x50000000);
            nw::g3d::math::Math::SinCosIdx(&sinB, &cosB, counter + 0xA0000000);
            sinR = sinR * 0.5f + 0.5f; cosR = cosR * 0.5f + 0.5f;
            sinG = sinG * 0.5f + 0.5f; cosG = cosG * 0.5f + 0.5f;
            sinB = sinB * 0.5f + 0.5f; cosB = cosB * 0.5f + 0.5f;
        }

        // DRC 描画。
        {
            nw::g3d::ClearBuffers(&colorBufferDRC, &depthBufferDRC,
                sinR, sinG, sinB, 1.0f, GX2_CLEAR_BOTH);

            pCtx->Activate(); // Clear に変更されたコンテクストの復帰。
            frameBufferDRC.Load();

            g3ddemo::CopyOut(&colorBufferDRC, GX2_SCAN_TARGET_DRC_FIRST);
        }

        // TV 描画。
        {
            nw::g3d::ClearBuffers(&colorBufferTV, &depthBufferTV,
                cosR, cosG, cosB, 1.0f, GX2_CLEAR_BOTH);

            pCtx->Activate(); // Clear に変更されたコンテクストの復帰。
            frameBufferTV.Load();

            g3ddemo::CopyOut(&colorBufferTV, GX2_SCAN_TARGET_TV);
        }

        nw::g3d::GfxManage::DrawDone(); // コマンドをフラッシュして描画完了を待つ。
        g3ddemo::SwapScanBuffers(); // （描画完了後に）垂直同期を待ってスワップコマンドを積む。
        nw::g3d::GfxManage::FlushCommands(); // スワップコマンドをフラッシュする。
    }

    // グラフィックスリソースの終了処理。
    pCtx->TempPrepare();

    frameBufferTV.Free(g3ddemo::FreeMem1);
    frameBufferTV.Cleanup();
    g3ddemo::FreeMem2(frameBufferTV.GetBufferPtr());

    frameBufferDRC.Free(g3ddemo::FreeMem1);
    frameBufferDRC.Cleanup();
    g3ddemo::FreeMem2(frameBufferDRC.GetBufferPtr());

    pCtx->Cleanup();
    g3ddemo::FreeMem2(pCtx);
    pCtx = NULL;

    // 終了処理。
    g3ddemo::ShutdownDisplay();
    g3ddemo::Shutdown();
    return 0;
}
