﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

layout(std140) uniform Env  // @@ id="env"
{
    vec3 skyColor;          // @@ id="sky_color" default="0.7 0.7 0.9" item="color"
    vec3 groundColor;       // @@ id="ground_color" default="0.3 0.2 0.2" item="color"

    vec3 dirLightDir;       // @@ id="dir_light_dir" default="-1 -1 -1"
    vec3 dirLightColor;     // @@ id="dir_light_color" default="1 1 1" item="color"
};

#ifdef ENV_AS_MATERIAL
// @@ block_id="env" type="material"

// @@ group="hemisphere" label="半球ライト" order="0"
/* @@ hemisphere:
    uniform_id="sky_color"          order="1"   label="スカイカラー"
    uniform_id="ground_color"       order="2"   label="グラウンドカラー"
*/

// @@ group="directional" label="ディレクショナルライト" order="1"
/* @@ directional:
    uniform_id="dir_light_dir"      order="1"   label="ライト方向"
    uniform_id="dir_light_color"    order="2"   label="ライトカラー"
*/

#endif
