﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;

namespace NintendoWare.Spy
{
    // TODO : IWaveSourceContainer ができたら WaveSourceInfo に改名する。
    /// <summary>
    /// 波形ソースの情報を格納します。
    /// </summary>
    public class WaveSourceOutputInfo
    {
        public WaveSourceOutputInfo(string name, int channelCount)
        {
            this.Name = name;
            this.ChannelCount = channelCount;
        }

        /// <summary>
        /// ターゲットの名前を取得します。
        /// </summary>
        public string Name { get; private set; }

        /// <summary>
        /// ターゲットのチャンネル数を取得します。
        /// </summary>
        public int ChannelCount { get; private set; }
    }

    // TODO : IWaveSourceContainer を新設し、IWaveSource は１つのターゲットを扱うようにする。
    /// <summary>
    /// 波形を供給するインターフェイスです。
    /// </summary>
    public interface IWaveSource
    {
        int SamplingRate { get; }
        int BitsPerSample { get; }

        int Mix(byte[] buffer, int offset, int count, string targetName, int channelCount);

        IEnumerable<WaveSourceOutputInfo> EnumerateWaveSourceOutputInfos();
    }
}
