﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Management;

namespace NintendoWare.Spy
{
    public static class WMI
    {
        private static uint processorCoreCount = uint.MaxValue;

        //-----------------------------------------------------------------

        /// <summary>
        /// CPUコア数を取得します。
        /// </summary>
        /// <returns>CPUコア数を返します。</returns>
        public static uint GetProcessorCoreCount()
        {
            // WMI クエリ処理に少し時間がかかるので、結果をキャッシュしておきます。
            if (processorCoreCount != uint.MaxValue)
            {
                return processorCoreCount;
            }

            uint coreCountTotal = 0;

            try
            {
                ManagementObjectCollection result = new ManagementObjectSearcher("SELECT * FROM Win32_Processor").Get();

                if (result != null)
                {
                    foreach (ManagementObject obj in result)
                    {
                        PropertyData numberOfCores = obj.Properties["NumberOfCores"];

                        if (numberOfCores.Value is uint)
                        {
                            coreCountTotal += (uint)numberOfCores.Value;
                        }
                        else
                        {
                            coreCountTotal++;
                        }
                    }
                }
            }
            catch
            {
            }

            processorCoreCount = coreCountTotal == 0 ? 1 : coreCountTotal;

            return processorCoreCount;
        }
    }
}
