﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System;

namespace NintendoWare.Spy
{
    /// <summary>
    /// Spy データ変更イベントに関する情報を格納します。
    /// </summary>
    public sealed class SpyDataChangedEventArgs : EventArgs
    {
        private readonly string _dataName;

        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="dataID">データ名を指定します。</param>
        public SpyDataChangedEventArgs(string dataName)
        {
            Assertion.Argument.NotNull(dataName);

            _dataName = dataName;
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// 変更されたデータ名を取得します。
        /// </summary>
        public string DataName
        {
            get { return _dataName; }
        }
    }
}
