﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.Spy
{
    /// <summary>
    /// Spy データブロックです。
    /// </summary>
    public class SpyDataBlock
    {
        public SpyDataBlock(long dataBlockID, byte[] rawData, long timestamp, long position)
        {
            this.ID = dataBlockID;
            this.RawData = rawData;
            this.Timestamp = new SpyGlobalTime(timestamp);
            this.Position = position;
        }

        /// <summary>
        /// データブロック ID を取得します。
        /// </summary>
        public long ID { get; }

        /// <summary>
        /// データ配列を取得します。
        /// </summary>
        public byte[] RawData { get; }

        /// <summary>
        /// パケット送信時間です。
        /// </summary>
        public SpyGlobalTime Timestamp { get; }

        /// <summary>
        /// ファイル内のデータブロックの位置を取得します。
        /// </summary>
        public long Position { get; }
    }
}
