﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows;
using System.Windows.Input;

namespace NintendoWare.Spy.Windows.Interactivity
{
    public class KeyEventTrigger : System.Windows.Interactivity.EventTrigger
    {
        public static readonly DependencyProperty FiredOnProperty = DependencyProperty.Register(
            nameof(FiredOn),
            typeof(KeyEventTriggerFiredOn),
            typeof(KeyEventTrigger),
            new PropertyMetadata(KeyEventTriggerFiredOn.KeyDown, OnFiredOnChanged));

        public static readonly DependencyProperty KeyProperty = DependencyProperty.Register(
            nameof(Key),
            typeof(Key),
            typeof(KeyEventTrigger),
            new PropertyMetadata(Key.None));

        public static readonly DependencyProperty ModifiersProperty = DependencyProperty.Register(
            nameof(Modifiers),
            typeof(ModifierKeys),
            typeof(KeyEventTrigger),
            new PropertyMetadata(ModifierKeys.None));

        //-----------------------------------------------------------------

        public KeyEventTriggerFiredOn FiredOn
        {
            get { return (KeyEventTriggerFiredOn)GetValue(FiredOnProperty); }
            set { SetValue(FiredOnProperty, value); }
        }

        public Key Key
        {
            get { return (Key)GetValue(KeyProperty); }
            set { SetValue(KeyProperty, value); }
        }

        public ModifierKeys Modifiers
        {
            get { return (ModifierKeys)GetValue(ModifiersProperty); }
            set { SetValue(ModifiersProperty, value); }
        }

        //-----------------------------------------------------------------

        protected override void OnAttached()
        {
            this.UpdateEventName();
            base.OnAttached();
        }

        protected override void OnEvent(EventArgs eventArgs)
        {
            var keyEventArgs = eventArgs as KeyEventArgs;

            if (keyEventArgs == null)
            {
                return;
            }

            if (keyEventArgs.Key != this.Key)
            {
                return;
            }

            if (this.Modifiers != ModifierKeys.None &&
                (this.Modifiers & Keyboard.Modifiers) != this.Modifiers)
            {
                return;
            }

            base.OnEvent(eventArgs);
        }

        private void UpdateEventName()
        {
            switch (this.FiredOn)
            {
                case KeyEventTriggerFiredOn.KeyDown:
                    this.EventName = "KeyDown";
                    break;

                case KeyEventTriggerFiredOn.KeyUp:
                    this.EventName = "KeyUp";
                    break;
            }
        }

        private static void OnFiredOnChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            var target = (KeyEventTrigger)sender;
            target.UpdateEventName();
        }
    }
}
