﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows;
using System.Windows.Interactivity;

namespace NintendoWare.Spy.Windows.Interactivity
{
    public class CallMethodAction : TriggerAction<DependencyObject>
    {
        public static readonly DependencyProperty TargetProperty = DependencyProperty.Register(
            nameof(Target),
            typeof(object),
            typeof(CallMethodAction),
            new PropertyMetadata());

        public static readonly DependencyProperty MethodNameProperty = DependencyProperty.Register(
            nameof(MethodName),
            typeof(string),
            typeof(CallMethodAction),
            new PropertyMetadata());

        //-----------------------------------------------------------------

        public object Target
        {
            get { return this.GetValue(CallMethodAction.TargetProperty); }
            set { this.SetValue(CallMethodAction.TargetProperty, value); }
        }

        public string MethodName
        {
            get { return (string)this.GetValue(CallMethodAction.MethodNameProperty); }
            set { this.SetValue(CallMethodAction.MethodNameProperty, value); }
        }

        //-----------------------------------------------------------------

        protected override void Invoke(object parameter)
        {
            if (this.AssociatedObject == null)
            {
                return;
            }

            var target = this.Target;

            if (target == null)
            {
                return;
            }

            var methodName = this.MethodName;

            if (string.IsNullOrEmpty(methodName))
            {
                return;
            }

            var targetType = target.GetType();
            var methodInfo = targetType.GetMethod(methodName);

            if (methodInfo == null)
            {
                return;
            }

            methodInfo.Invoke(target, new object[0]);
        }
    }
}
