﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.ComponentModel;
using System.Windows;

namespace NintendoWare.Spy.Windows
{
    /// <summary>
    /// デザインモードのためのユーティリティクラスです。
    /// </summary>
    public static class DesignModeUtility
    {
        /// <summary>
        /// 指定要素がデザインモードで利用されているのかどうかを調べます。
        /// </summary>
        /// <param name="element">要素を指定します。</param>
        /// <returns>デザインモードで利用されている場合は true、そうでない場合は false を返します。</returns>
        public static bool IsInDesignMode(this DependencyObject element)
        {
            return DesignerProperties.GetIsInDesignMode(element) || Application.Current == null;
        }
    }
}
