﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.Spy.Settings
{
    /// <summary>
    /// CafeAudio 設定を格納します。
    /// TODO : ★SoundSpyCafe.dll ができたら、Cafe 依存パラメータを移動します。
    /// </summary>
    public sealed class CafeAudioSettings
    {
        public CafeAudioSettings()
        {
            this.FinalOutTvWaveVisibility = WaveVisibility.Surround4ch;
            this.FinalOutDrcWaveVisibility = WaveVisibility.Stereo;

            this.LoudnessTvWaveVisibility = WaveVisibility.Surround4ch;
            this.LoudnessDrcWaveVisibility = WaveVisibility.Stereo;
        }

        //-----------------------------------------------------------------

        public WaveVisibility FinalOutTvWaveVisibility { get; set; }
        public WaveVisibility FinalOutDrcWaveVisibility { get; set; }

        public WaveVisibility LoudnessTvWaveVisibility { get; set; }
        public WaveVisibility LoudnessDrcWaveVisibility { get; set; }
    }
}
